<?php
namespace App\Core;

use App\Shared\Helpers\MetricCollector;

class Router
{
    private static function handleCors()
    {
        if (isset($_SERVER['HTTP_ORIGIN'])) {
            header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400');
        }

        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD'])) {
                header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
            }
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS'])) {
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
            }
            exit(0);
        }
    }

    public static function dispatch()
    {
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }

        MetricCollector::clear();
        self::handleCors();
        
        $protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http");
        $host = $_SERVER['HTTP_HOST'];
        
        $script_dir = str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME']));
        $base_dir = str_replace('/public', '', $script_dir);
        $base_dir = rtrim($base_dir, '/');

        if(!defined('BASE_URL')){
            define('BASE_URL', $protocol . "://" . $host . ($base_dir ?: ''));
        }

        $request_uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

        if ($base_dir !== '' && strpos($request_uri, $base_dir) === 0) {
            $path = substr($request_uri, strlen($base_dir));
        } else {
            $path = $request_uri;
        }

        $url = trim($path, '/');
        $parts = !empty($url) ? explode('/', $url) : [];

        if (empty($parts) || (isset($parts[0]) && empty($parts[0]))) {
            $parts = ['Auth'];
        }

        $ctrlClass = null;
        $act = 'index';
        $params = [];

        for ($i = 0; $i < count($parts); $i++) {
            $modulePathParts = array_slice($parts, 0, $i + 1);
            $casedModulePath = array_map(function($part) {
                return str_replace(' ', '', ucwords(str_replace('-', ' ', $part)));
            }, $modulePathParts);

            $controllerName = end($casedModulePath);

            $potentialCtrlClass = 'App\\Modules\\' . implode('\\', $casedModulePath) . '\\Controllers\\' . $controllerName . 'Controller';

            if (class_exists($potentialCtrlClass)) {
                $ctrlClass = $potentialCtrlClass;
                $act = $parts[$i + 1] ?? 'index';
                $params = array_slice($parts, $i + 2);
            }
        }

        if ($ctrlClass === null) {
            http_response_code(404);
            die('Modulo nao encontrado');
        }

        $ctrl = new $ctrlClass();

        // Middleware global: Aplica a autenticação a todas as rotas, exceto as da whitelist.
        $authWhitelist = [
            \App\Modules\Auth\Controllers\AuthController::class,
            \App\Modules\Config\Controllers\ConfigController::class
            // Adicione outros controllers que não exigem autenticação aqui.
        ];

        if (!in_array($ctrlClass, $authWhitelist, true)) {
            (new \App\Shared\Middlewares\Authenticate())->handle();
        }
        
        if (!method_exists($ctrl, $act)) {
            http_response_code(404);
            die('Acao nao encontrada');
        }

        call_user_func_array([$ctrl, $act], $params);
    }
}