<?php

namespace App\Core;

class View
{
    protected $layout = 'layout.php';
    protected $content;
    protected $data = [];
    protected $noLayout = false;

    public function __construct($view, $data = [])
    {
        $this->data = $data;
        $viewFile = __DIR__ . '/../Modules/' . $view . '.php';

        ob_start();
        
        extract($this->data);
        
        if (file_exists($viewFile)) {
            require $viewFile;
        } else {
            echo "View não encontrada: " . $viewFile;
        }
        
        $this->content = ob_get_clean();
    }

    public function setLayout($layout)
    {
        $this->layout = $layout;
    }

    public function setNoLayout($noLayout = true)
    {
        $this->noLayout = $noLayout;
    }



    public function render()
    {
        if ($this->noLayout) {
            echo $this->content;
            return;
        }

        // Torna o conteúdo da view disponível para o layout
        $content = $this->content;
        
        // Inclui o layout, que agora tem acesso a $content
        $layoutFile = __DIR__ . '/../../' . $this->layout;
        if (file_exists($layoutFile)) {
            require $layoutFile;
        } else {
            echo "Layout não encontrado: " . $layoutFile;
        }
    }
}