<?php
namespace App\Modules\Auth\Controllers;

use App\Core\View;
use App\Core\Security;

class AuthController
{
    public function __construct()
    {
        // Session is now started globally in the Router.
    }

    /**
     * Redirects base /auth URL to the login page.
     */
    public function index()
    {
        if (isset($_SESSION['user'])) {
            // User is logged in, send them to the main dashboard.
            header('Location: ' . url('/customer'));
            exit;
        }
        // User is not logged in, send them to the login page.
        header('Location: ' . url('/auth/login'));
        exit;
    }

    /**
     * Displays the login page.
     */
    public function login()
    {
        // If user is already logged in, redirect to home/dashboard
        if (isset($_SESSION['user'])) {
            header('Location: ' . url('/customer'));
            exit;
        }

        $view = new View('Auth/Views/login', [
            'csrf' => Security::generateCSRF()
        ]);
        $view->setNoLayout();
        $view->render();
    }

    /**
     * Processes the login form submission.
     */
    public function doLogin()
    {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            header('Location: ' . url('/auth/login'));
            exit;
        }

        Security::checkCSRF();

        $user = $_POST['user'] ?? '';
        $password = $_POST['password'] ?? '';

        // IMPORTANT: Replace this with proper database user authentication and password hashing.
        // This is for demonstration purposes only.
        if ($user === 'admin' && $password === 'admin@123') {
            // Regenerate session ID to prevent session fixation attacks
            session_regenerate_id(true);
            $_SESSION['user'] = ['name' => 'Admin']; // Store user data in session
            header('Location: ' . url('/customer')); // Redirect to a protected page
            exit;
        }

        // On failure, render the login page again with an error message.
        $view = new View('Auth/Views/login', [
            'csrf' => Security::generateCSRF(),
            'error' => 'Invalid username or password.'
        ]);
        $view->setNoLayout();
        $view->render();
    }

    /**
     * Logs the user out.
     */
    public function logout()
    {
        // Unset all of the session variables.
        $_SESSION = [];

        // If it's desired to kill the session, also delete the session cookie.
        if (ini_get("session.use_cookies")) {
            $params = session_get_cookie_params();
            setcookie(
                session_name(),
                '',
                time() - 42000,
                $params["path"],
                $params["domain"],
                $params["secure"],
                $params["httponly"]
            );
        }

        // Finally, destroy the session.
        session_destroy();

        header('Location: ' . url('/auth/login'));
        exit;
    }
}