<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/public/assets/css/login.css">
</head>

<body>

    <div class="container">
        <div class="left-panel">
            <div class="grid"></div>
            <div class="blob b1"></div>
            <div class="blob b2"></div>
            <h1>LOGIN</h1>
        </div>
        <div class="right-panel">
            <div class="login-form">
                <h2>Acesso Restrito</h2>

                <?php if (isset($error)): ?>
                    <div class="error-message"><?php echo htmlspecialchars($error); ?></div>
                <?php endif; ?>

                <form action="<?php echo url('/auth/doLogin'); ?>" method="post">
                    <input type="hidden" name="csrf" value="<?php echo htmlspecialchars($csrf ?? ''); ?>">

                    <div class="input-group">
                        <input type="text" id="user" name="user" required placeholder=" " value="">
                        <label for="user">Usuário</label>
                    </div>

                    <div class="input-group">
                        <input type="password" id="password" name="password" required placeholder=" " value="">
                        <label for="password">Senha</label>
                        <span class="password-toggle"><i class="fas fa-eye"></i></span>
                    </div>

                    <button type="submit" class="btn-login">Entrar</button>
                </form>
            </div>
        </div>
    </div>

    <script src="<?php echo BASE_URL; ?>/public/assets/js/login.js"></script>
</body>

</html>