<?php

namespace App\Modules\Cliente\Models;

use App\Core\Orm;

class ClienteModel extends Orm
{
    public function __construct()
    {
        parent::__construct();
        $this->tabela = "cliente";
        $this->chave_primaria = "cliente_id";
        $this->order_by = "cliente_id DESC";

        // Configuração dos Timestamps automáticos do ORM
        $this->created_at_column = 'cliente_criadoEm';
        $this->updated_at_column = 'cliente_alteradoEm';

        $this->colunas = [
            'cliente_id',
            'cliente_nome',
            'cliente_telefone',
            'cliente_celular',
            'cliente_email',
            'cliente_cep',
            'cliente_endCidade',
            'cliente_endEstado',
            'cliente_cpf',
            'cliente_endereco',
            'cliente_bairro',
            'cliente_endComplemento',
            'cliente_limiteCredito',
            'cliente_criadoEm',
            'cliente_alteradoEm',
            'cliente_status'
        ];
    }

    /**
     * Atalho estático para iniciar uma consulta fluida
     * @return self
     */
    public static function query()
    {
        return new self();
    }

    public function getDashboardStats()
    {
        $stats = [];

        // Total de Clientes
        $stats['total_customers'] = (new self())->contar();

        // Novos Clientes (últimos 30 dias)
        $stats['new_customers_30_days'] = (new self())
            ->whereRaw('cliente_criadoEm >= DATE_SUB(NOW(), INTERVAL 30 DAY)')
            ->contar();

        // Clientes Atualizados (últimos 30 dias)
        $stats['updated_customers_30_days'] = (new self())
            ->whereRaw('cliente_alteradoEm >= DATE_SUB(NOW(), INTERVAL 30 DAY)')
            ->whereRaw('cliente_alteradoEm > cliente_criadoEm')
            ->contar();

        // Inadimplentes (placeholder, lógica a ser definida)
        $stats['overdue_customers'] = 0;

        return $stats;
    }
}
