<div id="toast" class="fixed top-5 right-5 bg-green-500 text-white py-2 px-4 rounded-lg shadow-md z-50"
    style="display: none; transition: opacity 0.5s ease;"></div>

<div class="h-screen bg-gradient-to-br from-gray-50 to-gray-100 p-4 md:p-6">
    <div class="mx-auto container p-4 w-full">
        <!-- Header -->
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-8 gap-4">
            <div class="flex items-center gap-3">
                <div class="p-3 bg-gradient-to-r from-blue-500 to-cyan-400 rounded-xl shadow-md">
                    <i class="fas fa-users text-white text-lg"></i>
                </div>
                <div class="min-w-0">
                    <h1 class="text-2xl sm:text-3xl font-bold text-gray-800 truncate"><?= e($title) ?></h1>
                    <p class="text-gray-600 text-sm mt-1 truncate">Adicione as informações do cliente</p>
                </div>
            </div>

            <a href="<?= BASE_URL ?>/cliente"
                class="flex items-center gap-2 px-4 py-2.5 bg-gray-500 text-white rounded-md hover:bg-gray-600  font-medium transition-all border border-grey-200 hover:border-grey-300 shadow-sm hover:shadow whitespace-nowrap">
                <i class="fas fa-arrow-left text-sm"></i>
                Voltar para a Lista
            </a>
        </div>

        <!-- Form Container -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-200 overflow-hidden">
            <!-- Form Header -->
            <div class="px-6 py-4 border-b border-gray-100 bg-blue-50">
                <div class="flex items-center justify-between">
                    <h2 class="text-lg font-semibold text-gray-800 truncate">
                        <i class="fas fa-edit mr-2"></i>
                        Dados do Cliente
                    </h2>
                </div>
            </div>

            <!-- Form -->
            <form id="client-form" class="p-4 sm:p-6">
                <!-- Hidden fields -->
                <input type="hidden" name="cliente_id" id="cliente_id" value="<?= e($client->cliente_id ?? '') ?>">

                <div class="space-y-6 sm:space-y-8">
                    <!-- Informações Básicas -->
                    <div>
                        <div class="mt-6 mb-4">
                            <h3
                                class="text-sm font-semibold text-gray-700 uppercase tracking-wider mb-4 flex items-center">
                                <i class="fas fa-user mr-2 flex-shrink-0"></i>
                                <span class="truncate">Informações Básicas</span>
                            </h3>
                            <div class="border-b border-gray-200 mt-2"></div>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 sm:gap-6">
                            <!-- Nome -->
                            <div class="w-full md:col-span-2">
                                <div class="flex items-center justify-between mb-1">
                                    <label for="cliente_nome"
                                        class="text-xs font-medium text-gray-700 uppercase tracking-wider">
                                        NOME <span class="text-red-500 ml-1">*</span>
                                    </label>
                                </div>
                                <div class="relative">
                                    <input type="text" id="cliente_nome" name="cliente_nome" required
                                        placeholder="Nome do Cliente"
                                        class="w-full px-4 pr-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200 text-sm"
                                        value="<?= e($client->cliente_nome ?? '') ?>">
                                </div>
                            </div>

                            <div class="w-full">
                                <div class="flex items-center justify-between mb-1">
                                    <label for="cliente_cpf"
                                        class="text-xs font-medium text-gray-700 uppercase tracking-wider">
                                        CPF/CNPJ
                                    </label>
                                </div>
                                <div class="relative">
                                    <input type="text" id="cliente_cpf" name="cliente_cpf" placeholder="CPF ou CNPJ"
                                        data-mask="cpf_cnpj" data-validate="cpf_cnpj" data-required="true"
                                        class="w-full px-4 pr-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200 text-sm"
                                        value="<?= e($client->cliente_cpf ?? '') ?>" <?= isset($client->cliente_id) ? 'readonly' : '' ?>>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Contato -->
                    <div>
                        <div class="mt-6 mb-4">
                            <h3
                                class="text-sm font-semibold text-gray-700 uppercase tracking-wider mb-4 flex items-center mt-4">
                                <i class="fas fa-envelope mr-2 flex-shrink-0"></i>
                                <span class="truncate">Contato</span>
                            </h3>
                            <div class="border-b border-gray-200 mt-2"></div>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 sm:gap-6">
                            <!-- Telefone -->
                            <div class="w-full">
                                <div class="flex items-center justify-between mb-1">
                                    <label for="cliente_telefone" data-mask="phone"
                                        class="text-xs font-medium text-gray-700 uppercase tracking-wider">
                                        Telefone
                                    </label>
                                </div>
                                <div class="relative">
                                    <input type="text" id="cliente_telefone" name="cliente_telefone"
                                        placeholder="(99) 9999-9999" data-mask="phone"
                                        class="w-full px-4 pr-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200 text-sm"
                                        value="<?= e($client->cliente_telefone ?? '') ?>">
                                </div>
                            </div>

                            <!-- Celular -->
                            <div class="w-full">
                                <div class="flex items-center justify-between mb-1">
                                    <label for="cliente_celular" data-mask="phone"
                                        class="text-xs font-medium text-gray-700 uppercase tracking-wider">
                                        Celular
                                    </label>
                                </div>
                                <div class="relative">
                                    <input type="text" id="cliente_celular" name="cliente_celular"
                                        placeholder="(99) 99999-9999" data-mask="phone"
                                        class="w-full px-4 pr-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200 text-sm"
                                        value="<?= e($client->cliente_celular ?? '') ?>">
                                </div>
                            </div>

                            <!-- Email -->
                            <div class="w-full">
                                <div class="flex items-center justify-between mb-1">
                                    <label for="cliente_email"
                                        class="text-xs font-medium text-gray-700 uppercase tracking-wider">
                                        Email
                                    </label>
                                </div>
                                <div class="relative">
                                    <input type="email" id="cliente_email" name="cliente_email"
                                        placeholder="email@exemplo.com"
                                        class="w-full px-4 pr-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200 text-sm"
                                        value="<?= e($client->cliente_email ?? '') ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Endereço -->
                    <div>
                        <div class="mt-6 mb-4">
                            <h3 class="text-sm font-semibold text-gray-700 uppercase tracking-wider flex items-center">
                                <i class="fas fa-map-marker-alt mr-2 text-gray-500"></i>
                                <span>Endereço</span>
                            </h3>
                            <div class="border-b border-gray-200 mt-2"></div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-4 gap-4 sm:gap-6">
                            <!-- CEP -->
                            <div class="w-full md:col-span-1">
                                <div class="flex items-center justify-between mb-1">
                                    <label for="cliente_cep"
                                        class="text-xs font-medium text-gray-700 uppercase tracking-wider">
                                        CEP
                                    </label>
                                </div>
                                <div class="relative">
                                    <input type="text" id="cliente_cep" name="cliente_cep" placeholder="00000-000"
                                        data-mask="cep"
                                        class="w-full px-4 pr-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200 text-sm"
                                        value="<?= e($client->cliente_cep ?? '') ?>">
                                </div>
                            </div>
                            <!-- Endereço -->
                            <div class="w-full md:col-span-3">
                                <div class="flex items-center justify-between mb-1">
                                    <label for="cliente_endereco"
                                        class="text-xs font-medium text-gray-700 uppercase tracking-wider">
                                        Endereço
                                    </label>
                                </div>
                                <input type="text" id="cliente_endereco" name="cliente_endereco"
                                    placeholder="Av. Exemplo, 123"
                                    class="w-full px-4 pr-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200 text-sm"
                                    value="<?= e($client->cliente_endereco ?? '') ?>">
                            </div>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 sm:gap-6 mt-4">
                            <!-- Bairro -->
                            <div class="w-full">
                                <div class="flex items-center justify-between mb-1">
                                    <label for="cliente_bairro"
                                        class="text-xs font-medium text-gray-700 uppercase tracking-wider">
                                        Bairro
                                    </label>
                                </div>
                                <input type="text" id="cliente_bairro" name="cliente_bairro" placeholder="Centro"
                                    class="w-full px-4 pr-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200 text-sm"
                                    value="<?= e($client->cliente_bairro ?? '') ?>">
                            </div>
                            <!-- Cidade -->
                            <div class="w-full">
                                <div class="flex items-center justify-between mb-1">
                                    <label for="cliente_endCidade"
                                        class="text-xs font-medium text-gray-700 uppercase tracking-wider">
                                        Cidade
                                    </label>
                                </div>
                                <input type="text" id="cliente_endCidade" name="cliente_endCidade"
                                    placeholder="Sua Cidade"
                                    class="w-full px-4 pr-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200 text-sm"
                                    value="<?= e($client->cliente_endCidade ?? '') ?>">
                            </div>
                            <!-- Estado -->
                            <div class="w-full">
                                <div class="flex items-center justify-between mb-1">
                                    <label for="cliente_endEstado"
                                        class="text-xs font-medium text-gray-700 uppercase tracking-wider">
                                        Estado
                                    </label>
                                </div>
                                <input type="text" id="cliente_endEstado" name="cliente_endEstado" placeholder="UF"
                                    class="w-full px-4 pr-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200 text-sm"
                                    value="<?= e($client->cliente_endEstado ?? '') ?>">
                            </div>
                        </div>
                        <!-- Complemento -->
                        <div class="w-full mt-4">
                            <div class="flex items-center justify-between mb-1">
                                <label for="cliente_endComplemento"
                                    class="text-xs font-medium text-gray-700 uppercase tracking-wider">
                                    Complemento
                                </label>
                            </div>
                            <input type="text" id="cliente_endComplemento" name="cliente_endComplemento"
                                placeholder="Apto, Bloco, etc."
                                class="w-full px-4 pr-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200 text-sm"
                                value="<?= e($client->cliente_endComplemento ?? '') ?>">
                        </div>
                    </div>
                    <!-- Financeiro -->
                    <div>
                        <div class="mt-6 mb-4">
                            <h3
                                class="text-sm font-semibold text-gray-700 uppercase tracking-wider mb-4 flex items-center mt-4">
                                <i class="fas fa-dollar-sign mr-2 flex-shrink-0"></i>
                                <span class="truncate">Financeiro</span>
                            </h3>
                            <div class="border-b border-gray-200 mt-2"></div>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 sm:gap-6">
                            <!-- Limite de Crédito -->
                            <div class="w-full">
                                <div class="flex items-center justify-between mb-1">
                                    <label for="cliente_limiteCredito"
                                        class="text-xs font-medium text-gray-700 uppercase tracking-wider">
                                        Limite de Crédito
                                    </label>
                                </div>
                                <div class="relative">
                                    <input type="text" id="cliente_limiteCredito" name="cliente_limiteCredito"
                                        step="0.01" data-mask="money" data-unmask="money" placeholder="R$ 0.00"
                                        class="w-full px-4 pr-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200 text-sm"
                                        value="<?= e($client->cliente_limiteCredito ?? '') ?>">
                                </div>
                            </div>
                            <!-- Status -->
                            <div class="w-full">
                                <div class="flex items-center justify-between mb-1">
                                    <label for="cliente_status"
                                        class="text-xs font-medium text-gray-700 uppercase tracking-wider">
                                        Status
                                    </label>
                                </div>
                                <div class="relative">
                                    <select id="cliente_status" name="cliente_status"
                                        class="w-full px-4 pr-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200 text-sm">
                                        <option value="ativo" <?= (isset($client->cliente_status) && $client->cliente_status == 'ativo') ? 'selected' : '' ?>>Ativo</option>
                                        <option value="inativo" <?= (isset($client->cliente_status) && $client->cliente_status == 'inativo') ? 'selected' : '' ?>>Inativo</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Form Actions -->
                <div
                    class="flex flex-col sm:flex-row justify-between items-center gap-4 mt-8 sm:mt-8 pt-6 border-t border-gray-200">
                    <div class="text-sm text-gray-500 w-full sm:w-auto text-center sm:text-left">
                        <p class="flex items-center justify-center sm:justify-start gap-2 flex-wrap">
                            <i class="fas fa-info-circle flex-shrink-0"></i>
                            <span>Campos marcados com <span class="text-red-500">*</span>, são obrigatórios.</span>
                        </p>
                    </div>

                    <div class="flex flex-col sm:flex-row gap-3 w-full sm:w-auto mt-4">
                        <button type="submit" id="submit-btn"
                            class="flex items-center justify-center gap-2 px-4 sm:px-5 py-2.5 bg-gradient-to-r from-blue-600 to-indigo-600 text-white rounded-xl font-medium hover:shadow-lg hover:from-blue-700 hover:to-indigo-700 transition-all shadow-md hover:scale-[1.00] whitespace-nowrap order-1 sm:order-2">
                            <i class="fas fa-save"></i>
                            <span id="submit-text">Salvar Cliente</span>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<script type="module" src="<?= BASE_URL ?>/assets/js/cliente/clienteWrapper.js"></script>