<div id="toast" class="fixed top-5 right-5 bg-green-500 text-white py-2 px-4 rounded-lg shadow-md z-50"
    style="display: none; transition: opacity 0.5s ease;"></div>

<div class="container mx-auto p-4">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold"><?= e($title) ?></h1>
        <a href="<?= BASE_URL ?>/cliente/form"
            class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 shadow-sm">Novo Cliente</a>
    </div>

    <!-- Stats Section -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
        <div class="bg-white p-6 rounded-xl shadow-md border-l-4 border-blue-500 hover:shadow-lg transition-shadow">
            <div class="flex items-center">
                <div class="p-3 bg-blue-100 rounded-full">
                    <i class="fa-solid fa-users text-blue-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500 uppercase tracking-wider">Cadastrados</p>
                    <p class="text-2xl font-bold text-gray-800"><?= e($stats['total_customers'] ?? 0) ?></p>
                </div>
            </div>
        </div>
        <div class="bg-white p-6 rounded-xl shadow-md border-l-4 border-red-500 hover:shadow-lg transition-shadow">
            <div class="flex items-center">
                <div class="p-3 bg-red-100 rounded-full">
                    <i class="fa-solid fa-file-invoice-dollar text-red-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500 uppercase tracking-wider">Inadimplentes</p>
                    <p class="text-2xl font-bold text-gray-800"><?= e($stats['overdue_customers'] ?? 0) ?></p>
                </div>
            </div>
        </div>
        <div class="bg-white p-6 rounded-xl shadow-md border-l-4 border-green-500 hover:shadow-lg transition-shadow">
            <div class="flex items-center">
                <div class="p-3 bg-green-100 rounded-full">
                    <i class="fa-solid fa-user-plus text-green-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500 uppercase tracking-wider">Novos <span
                            class="text-xs font-normal">(30 dias)</span></p>
                    <p class="text-2xl font-bold text-gray-800"><?= e($stats['new_customers_30_days'] ?? 0) ?></p>
                </div>
            </div>
        </div>
        <div class="bg-white p-6 rounded-xl shadow-md border-l-4 border-orange-500 hover:shadow-lg transition-shadow">
            <div class="flex items-center">
                <div class="p-3 bg-orange-100 rounded-full">
                    <i class="fa-solid fa-arrows-rotate text-orange-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500 uppercase tracking-wider">Atualizados <span
                            class="text-xs font-normal">(30 dias)</span></p>
                    <p class="text-2xl font-bold text-gray-800"><?= e($stats['updated_customers_30_days'] ?? 0) ?></p>
                </div>
            </div>
        </div>
    </div>
    <!-- End Stats Section -->

    <div class="bg-white p-6 rounded-lg shadow-md">
        <h2 class="text-xl font-bold mb-4">Lista de Clientes</h2>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nome
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            CPF/CNPJ</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Telefone</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Celular</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Email
                        </th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Ações</th>
                    </tr>
                </thead>
                <tbody id="cliente-list">
                    <tr>
                        <td colspan="7" class="text-center py-6 text-gray-400">
                            Carregando clientes...
                        </td>
                    </tr>
                </tbody>

            </table>
        </div>
        <!-- Pagination Controls -->
        <div id="pagination-controls" class="mt-4 flex justify-center items-center space-x-2">
            <!-- Os botões da paginação serão inseridos aqui pelo JavaScript -->
        </div>
    </div>
</div>
<script type="module" src="<?= BASE_URL ?>/assets/js/cliente/clienteWrapper.js"></script>