<div class="p-6">
    <!-- Cabeçalho -->
    <div class="mb-8">
        <div class="flex items-center justify-between mb-4">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">Dashboard Comercial</h1>
                <p class="text-gray-600 mt-1">Análise de vendas, pedidos e desempenho comercial</p>
            </div>
            <div class="flex items-center gap-3">
                <div class="relative">
                    <select class="px-4 py-2 bg-white border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent">
                        <option>Últimos 7 dias</option>
                        <option>Este mês</option>
                        <option>Último trimestre</option>
                        <option>Este ano</option>
                    </select>
                </div>
                <button class="px-4 py-2 bg-gradient-to-r from-purple-600 to-purple-700 text-white rounded-lg hover:from-purple-700 hover:to-purple-800 transition-all duration-300 flex items-center gap-2">
                    <i class="fas fa-plus text-sm"></i>
                    Novo Pedido
                </button>
            </div>
        </div>
        
        <!-- Status Cards -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
            <!-- Faturamento -->
            <div class="bg-gradient-to-br from-purple-50 to-white rounded-xl p-5 shadow-sm border border-purple-100 hover:shadow-md transition-shadow duration-300">
                <div class="flex items-center justify-between mb-4">
                    <div class="w-12 h-12 bg-gradient-to-br from-purple-600 to-purple-700 rounded-lg flex items-center justify-center">
                        <i class="fas fa-money-bill-wave text-white text-lg"></i>
                    </div>
                    <span class="text-sm font-medium text-purple-600">Faturamento</span>
                </div>
                <h3 class="text-2xl font-bold text-gray-800 mb-1">R$ 248.750</h3>
                <p class="text-gray-600 text-sm">Este mês</p>
                <div class="mt-3 pt-3 border-t border-purple-100">
                    <span class="text-xs text-green-600 flex items-center gap-1">
                        <i class="fas fa-arrow-up"></i>
                        +12,5% vs mês anterior
                    </span>
                </div>
            </div>
            
            <!-- Pedidos -->
            <div class="bg-gradient-to-br from-blue-50 to-white rounded-xl p-5 shadow-sm border border-blue-100 hover:shadow-md transition-shadow duration-300">
                <div class="flex items-center justify-between mb-4">
                    <div class="w-12 h-12 bg-gradient-to-br from-blue-600 to-blue-700 rounded-lg flex items-center justify-center">
                        <i class="fas fa-shopping-cart text-white text-lg"></i>
                    </div>
                    <span class="text-sm font-medium text-blue-600">Pedidos</span>
                </div>
                <h3 class="text-2xl font-bold text-gray-800 mb-1">156</h3>
                <p class="text-gray-600 text-sm">Em andamento</p>
                <div class="mt-3 pt-3 border-t border-blue-100">
                    <span class="text-xs text-blue-600 flex items-center gap-1">
                        <i class="fas fa-clock"></i>
                        24 novos hoje
                    </span>
                </div>
            </div>
            
            <!-- Clientes -->
            <div class="bg-gradient-to-br from-emerald-50 to-white rounded-xl p-5 shadow-sm border border-emerald-100 hover:shadow-md transition-shadow duration-300">
                <div class="flex items-center justify-between mb-4">
                    <div class="w-12 h-12 bg-gradient-to-br from-emerald-600 to-emerald-700 rounded-lg flex items-center justify-center">
                        <i class="fas fa-users text-white text-lg"></i>
                    </div>
                    <span class="text-sm font-medium text-emerald-600">Clientes</span>
                </div>
                <h3 class="text-2xl font-bold text-gray-800 mb-1">845</h3>
                <p class="text-gray-600 text-sm">Clientes ativos</p>
                <div class="mt-3 pt-3 border-t border-emerald-100">
                    <span class="text-xs text-emerald-600 flex items-center gap-1">
                        <i class="fas fa-user-plus"></i>
                        +28 este mês
                    </span>
                </div>
            </div>
            
            <!-- Taxa de Conversão -->
            <div class="bg-gradient-to-br from-amber-50 to-white rounded-xl p-5 shadow-sm border border-amber-100 hover:shadow-md transition-shadow duration-300">
                <div class="flex items-center justify-between mb-4">
                    <div class="w-12 h-12 bg-gradient-to-br from-amber-600 to-amber-700 rounded-lg flex items-center justify-center">
                        <i class="fas fa-chart-line text-white text-lg"></i>
                    </div>
                    <span class="text-sm font-medium text-amber-600">Conversão</span>
                </div>
                <h3 class="text-2xl font-bold text-gray-800 mb-1">68%</h3>
                <p class="text-gray-600 text-sm">Taxa de conversão</p>
                <div class="mt-3 pt-3 border-t border-amber-100">
                    <span class="text-xs text-amber-600 flex items-center gap-1">
                        <i class="fas fa-trending-up"></i>
                        +5,2% este mês
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Gráficos e Métricas -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">
        <!-- Faturamento Mensal -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
            <div class="border-b border-gray-200 px-6 py-4 bg-gradient-to-r from-purple-50 to-white">
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-gradient-to-br from-purple-600 to-purple-700 rounded-lg flex items-center justify-center">
                            <i class="fas fa-chart-bar text-white"></i>
                        </div>
                        <div>
                            <h3 class="font-bold text-gray-800">Faturamento Mensal</h3>
                            <p class="text-sm text-gray-600">Últimos 6 meses</p>
                        </div>
                    </div>
                    <button class="text-purple-600 hover:text-purple-800 text-sm font-medium flex items-center gap-1">
                        <i class="fas fa-download"></i>
                        Exportar
                    </button>
                </div>
            </div>
            
            <div class="p-6">
                <!-- Gráfico Simulado -->
                <div class="h-64 flex items-end gap-3 justify-between">
                    <div class="flex flex-col items-center flex-1">
                        <div class="w-10 bg-gradient-to-t from-purple-400 to-purple-600 rounded-t-lg mb-2" style="height: 60%;"></div>
                        <span class="text-xs text-gray-500">Jan</span>
                        <span class="text-sm font-medium text-gray-800">R$ 45K</span>
                    </div>
                    <div class="flex flex-col items-center flex-1">
                        <div class="w-10 bg-gradient-to-t from-purple-400 to-purple-600 rounded-t-lg mb-2" style="height: 75%;"></div>
                        <span class="text-xs text-gray-500">Fev</span>
                        <span class="text-sm font-medium text-gray-800">R$ 56K</span>
                    </div>
                    <div class="flex flex-col items-center flex-1">
                        <div class="w-10 bg-gradient-to-t from-purple-400 to-purple-600 rounded-t-lg mb-2" style="height: 90%;"></div>
                        <span class="text-xs text-gray-500">Mar</span>
                        <span class="text-sm font-medium text-gray-800">R$ 68K</span>
                    </div>
                    <div class="flex flex-col items-center flex-1">
                        <div class="w-10 bg-gradient-to-t from-purple-400 to-purple-600 rounded-t-lg mb-2" style="height: 80%;"></div>
                        <span class="text-xs text-gray-500">Abr</span>
                        <span class="text-sm font-medium text-gray-800">R$ 62K</span>
                    </div>
                    <div class="flex flex-col items-center flex-1">
                        <div class="w-10 bg-gradient-to-t from-purple-400 to-purple-600 rounded-t-lg mb-2" style="height: 95%;"></div>
                        <span class="text-xs text-gray-500">Mai</span>
                        <span class="text-sm font-medium text-gray-800">R$ 72K</span>
                    </div>
                    <div class="flex flex-col items-center flex-1">
                        <div class="w-10 bg-gradient-to-t from-purple-500 to-purple-700 rounded-t-lg mb-2" style="height: 100%;"></div>
                        <span class="text-xs text-gray-500">Jun</span>
                        <span class="text-sm font-medium text-gray-800">R$ 85K</span>
                    </div>
                </div>
                
                <!-- Legenda -->
                <div class="mt-6 pt-6 border-t border-gray-100">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center gap-2">
                            <div class="w-3 h-3 bg-purple-500 rounded-full"></div>
                            <span class="text-sm text-gray-600">Faturamento Bruto</span>
                        </div>
                        <div class="text-sm text-gray-800 font-medium">
                            Crescimento: <span class="text-green-600">+18,5%</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Status dos Pedidos -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
            <div class="border-b border-gray-200 px-6 py-4 bg-gradient-to-r from-blue-50 to-white">
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-gradient-to-br from-blue-600 to-blue-700 rounded-lg flex items-center justify-center">
                            <i class="fas fa-clipboard-list text-white"></i>
                        </div>
                        <div>
                            <h3 class="font-bold text-gray-800">Status dos Pedidos</h3>
                            <p class="text-sm text-gray-600">Distribuição atual</p>
                        </div>
                    </div>
                    <a href="<?= url('/vendas') ?>" class="text-blue-600 hover:text-blue-800 text-sm font-medium flex items-center gap-1">
                        Ver todos
                        <i class="fas fa-arrow-right text-xs"></i>
                    </a>
                </div>
            </div>
            
            <div class="p-6">
                <!-- Gráfico de Pizza Simulado -->
                <div class="flex items-center justify-center mb-6">
                    <div class="relative w-48 h-48">
                        <!-- Gráfico de pizza usando gradientes -->
                        <div class="absolute inset-0 rounded-full border-8 border-blue-500"></div>
                        <div class="absolute inset-0 rounded-full border-8 border-emerald-500" style="clip-path: polygon(50% 50%, 50% 0%, 100% 0%, 100% 50%);"></div>
                        <div class="absolute inset-0 rounded-full border-8 border-amber-500" style="clip-path: polygon(50% 50%, 100% 50%, 100% 100%, 50% 100%);"></div>
                        <div class="absolute inset-0 rounded-full border-8 border-purple-500" style="clip-path: polygon(50% 50%, 50% 100%, 0% 100%, 0% 50%);"></div>
                        
                        <div class="absolute inset-0 flex items-center justify-center">
                            <div class="text-center">
                                <div class="text-2xl font-bold text-gray-800">156</div>
                                <div class="text-sm text-gray-500">Pedidos</div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Legenda -->
                <div class="space-y-3">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center gap-2">
                            <div class="w-3 h-3 bg-blue-500 rounded-full"></div>
                            <span class="text-sm text-gray-600">Pendentes</span>
                        </div>
                        <span class="text-sm font-medium text-gray-800">45 (29%)</span>
                    </div>
                    <div class="flex items-center justify-between">
                        <div class="flex items-center gap-2">
                            <div class="w-3 h-3 bg-emerald-500 rounded-full"></div>
                            <span class="text-sm text-gray-600">Em produção</span>
                        </div>
                        <span class="text-sm font-medium text-gray-800">68 (44%)</span>
                    </div>
                    <div class="flex items-center justify-between">
                        <div class="flex items-center gap-2">
                            <div class="w-3 h-3 bg-amber-500 rounded-full"></div>
                            <span class="text-sm text-gray-600">Aguardando</span>
                        </div>
                        <span class="text-sm font-medium text-gray-800">25 (16%)</span>
                    </div>
                    <div class="flex items-center justify-between">
                        <div class="flex items-center gap-2">
                            <div class="w-3 h-3 bg-purple-500 rounded-full"></div>
                            <span class="text-sm text-gray-600">Entregues</span>
                        </div>
                        <span class="text-sm font-medium text-gray-800">18 (11%)</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Listas -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
        <!-- Top Clientes -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
            <div class="border-b border-gray-200 px-6 py-4 bg-gradient-to-r from-emerald-50 to-white">
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-gradient-to-br from-emerald-600 to-emerald-700 rounded-lg flex items-center justify-center">
                            <i class="fas fa-crown text-white"></i>
                        </div>
                        <div>
                            <h3 class="font-bold text-gray-800">Top Clientes</h3>
                            <p class="text-sm text-gray-600">Por faturamento</p>
                        </div>
                    </div>
                    <a href="<?= url('/cliente') ?>" class="text-emerald-600 hover:text-emerald-800 text-sm font-medium flex items-center gap-1">
                        Ver todos
                        <i class="fas fa-arrow-right text-xs"></i>
                    </a>
                </div>
            </div>
            
            <div class="p-6">
                <div class="space-y-4">
                    <div class="flex items-center justify-between p-3 hover:bg-gray-50 rounded-lg transition-colors duration-200">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 bg-gradient-to-br from-purple-500 to-purple-600 rounded-full flex items-center justify-center">
                                <span class="text-white font-medium">TC</span>
                            </div>
                            <div>
                                <h4 class="font-medium text-gray-800">TechCorp Solutions</h4>
                                <p class="text-sm text-gray-500">Cliente Premium</p>
                            </div>
                        </div>
                        <div class="text-right">
                            <div class="font-bold text-gray-800">R$ 42.580</div>
                            <div class="text-xs text-green-600">+15% este mês</div>
                        </div>
                    </div>
                    
                    <div class="flex items-center justify-between p-3 hover:bg-gray-50 rounded-lg transition-colors duration-200">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-blue-600 rounded-full flex items-center justify-center">
                                <span class="text-white font-medium">ID</span>
                            </div>
                            <div>
                                <h4 class="font-medium text-gray-800">Indústria Delta</h4>
                                <p class="text-sm text-gray-500">Cliente Corporativo</p>
                            </div>
                        </div>
                        <div class="text-right">
                            <div class="font-bold text-gray-800">R$ 31.250</div>
                            <div class="text-xs text-green-600">+8% este mês</div>
                        </div>
                    </div>
                    
                    <div class="flex items-center justify-between p-3 hover:bg-gray-50 rounded-lg transition-colors duration-200">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 bg-gradient-to-br from-amber-500 to-amber-600 rounded-full flex items-center justify-center">
                                <span class="text-white font-medium">GS</span>
                            </div>
                            <div>
                                <h4 class="font-medium text-gray-800">Global Systems</h4>
                                <p class="text-sm text-gray-500">Cliente Internacional</p>
                            </div>
                        </div>
                        <div class="text-right">
                            <div class="font-bold text-gray-800">R$ 28.940</div>
                            <div class="text-xs text-green-600">+22% este mês</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Pedidos Recentes -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
            <div class="border-b border-gray-200 px-6 py-4 bg-gradient-to-r from-amber-50 to-white">
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-gradient-to-br from-amber-600 to-amber-700 rounded-lg flex items-center justify-center">
                            <i class="fas fa-clock text-white"></i>
                        </div>
                        <div>
                            <h3 class="font-bold text-gray-800">Pedidos Recentes</h3>
                            <p class="text-sm text-gray-600">Últimas 24 horas</p>
                        </div>
                    </div>
                    <a href="<?= url('/vendas') ?>" class="text-amber-600 hover:text-amber-800 text-sm font-medium flex items-center gap-1">
                        Ver todos
                        <i class="fas fa-arrow-right text-xs"></i>
                    </a>
                </div>
            </div>
            
            <div class="p-6">
                <div class="space-y-4">
                    <div class="flex items-center justify-between p-3 hover:bg-gray-50 rounded-lg transition-colors duration-200">
                        <div>
                            <div class="flex items-center gap-2 mb-1">
                                <span class="font-medium text-gray-800">PED-2024-0456</span>
                                <span class="px-2 py-1 bg-blue-100 text-blue-700 text-xs rounded">Novo</span>
                            </div>
                            <p class="text-sm text-gray-500">Cliente: TechCorp Solutions</p>
                        </div>
                        <div class="text-right">
                            <div class="font-bold text-gray-800">R$ 8.450</div>
                            <div class="text-xs text-gray-500">10:30 AM</div>
                        </div>
                    </div>
                    
                    <div class="flex items-center justify-between p-3 hover:bg-gray-50 rounded-lg transition-colors duration-200">
                        <div>
                            <div class="flex items-center gap-2 mb-1">
                                <span class="font-medium text-gray-800">PED-2024-0455</span>
                                <span class="px-2 py-1 bg-emerald-100 text-emerald-700 text-xs rounded">Produção</span>
                            </div>
                            <p class="text-sm text-gray-500">Cliente: Indústria Delta</p>
                        </div>
                        <div class="text-right">
                            <div class="font-bold text-gray-800">R$ 12.300</div>
                            <div class="text-xs text-gray-500">09:15 AM</div>
                        </div>
                    </div>
                    
                    <div class="flex items-center justify-between p-3 hover:bg-gray-50 rounded-lg transition-colors duration-200">
                        <div>
                            <div class="flex items-center gap-2 mb-1">
                                <span class="font-medium text-gray-800">PED-2024-0454</span>
                                <span class="px-2 py-1 bg-purple-100 text-purple-700 text-xs rounded">Aguardando</span>
                            </div>
                            <p class="text-sm text-gray-500">Cliente: Global Systems</p>
                        </div>
                        <div class="text-right">
                            <div class="font-bold text-gray-800">R$ 5.680</div>
                            <div class="text-xs text-gray-500">Ontem, 16:45</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Ações Rápidas -->
    <div class="mt-8">
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
            <div class="border-b border-gray-200 px-6 py-4 bg-gradient-to-r from-gray-50 to-white">
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-gradient-to-br from-gray-600 to-gray-700 rounded-lg flex items-center justify-center">
                            <i class="fas fa-bolt text-white"></i>
                        </div>
                        <div>
                            <h3 class="font-bold text-gray-800">Ações Rápidas</h3>
                            <p class="text-sm text-gray-600">Acesse rapidamente funcionalidades</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="p-6">
                <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                    <a href="<?= url('/vendas') ?>" class="p-4 bg-gradient-to-r from-blue-50 to-blue-100 rounded-lg hover:from-blue-100 hover:to-blue-200 transition-all duration-300 group">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 bg-gradient-to-br from-blue-600 to-blue-700 rounded-lg flex items-center justify-center">
                                <i class="fas fa-clipboard-list text-white"></i>
                            </div>
                            <div>
                                <h4 class="font-medium text-gray-800 group-hover:text-blue-700">Novo Pedido</h4>
                                <p class="text-xs text-gray-600">Criar venda</p>
                            </div>
                        </div>
                    </a>
                    
                    <a href="<?= url('/orcamentos') ?>" class="p-4 bg-gradient-to-r from-purple-50 to-purple-100 rounded-lg hover:from-purple-100 hover:to-purple-200 transition-all duration-300 group">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 bg-gradient-to-br from-purple-600 to-purple-700 rounded-lg flex items-center justify-center">
                                <i class="fas fa-file-contract text-white"></i>
                            </div>
                            <div>
                                <h4 class="font-medium text-gray-800 group-hover:text-purple-700">Orçamento</h4>
                                <p class="text-xs text-gray-600">Criar proposta</p>
                            </div>
                        </div>
                    </a>
                    
                    <a href="<?= url('/cliente') ?>" class="p-4 bg-gradient-to-r from-emerald-50 to-emerald-100 rounded-lg hover:from-emerald-100 hover:to-emerald-200 transition-all duration-300 group">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 bg-gradient-to-br from-emerald-600 to-emerald-700 rounded-lg flex items-center justify-center">
                                <i class="fas fa-user-plus text-white"></i>
                            </div>
                            <div>
                                <h4 class="font-medium text-gray-800 group-hover:text-emerald-700">Novo Cliente</h4>
                                <p class="text-xs text-gray-600">Cadastrar</p>
                            </div>
                        </div>
                    </a>
                    
                    <a href="<?= url('/contratos') ?>" class="p-4 bg-gradient-to-r from-amber-50 to-amber-100 rounded-lg hover:from-amber-100 hover:to-amber-200 transition-all duration-300 group">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 bg-gradient-to-br from-amber-600 to-amber-700 rounded-lg flex items-center justify-center">
                                <i class="fas fa-file-signature text-white"></i>
                            </div>
                            <div>
                                <h4 class="font-medium text-gray-800 group-hover:text-amber-700">Contrato</h4>
                                <p class="text-xs text-gray-600">Gerar contrato</p>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Estilos adicionais -->
<style>
    /* Animação suave para os cards */
    .hover-lift {
        transition: transform 0.2s ease, box-shadow 0.2s ease;
    }
    
    .hover-lift:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
    }
    
    /* Animação para gráficos */
    @keyframes growBar {
        from { height: 0; }
        to { height: var(--final-height); }
    }
    
    .chart-bar {
        animation: growBar 1s ease-out forwards;
        transform-origin: bottom;
    }
</style>

<!-- Script para interatividade -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Efeito hover lift nos cards
        const cards = document.querySelectorAll('.bg-gradient-to-br');
        cards.forEach(card => {
            card.addEventListener('mouseenter', function() {
                this.classList.add('hover-lift');
            });
            
            card.addEventListener('mouseleave', function() {
                this.classList.remove('hover-lift');
            });
        });
        
        // Atualizar seletor de período
        const periodSelect = document.querySelector('select');
        if (periodSelect) {
            periodSelect.addEventListener('change', function() {
                // Aqui você pode adicionar lógica para atualizar os dados conforme o período selecionado
                console.log('Período selecionado:', this.value);
            });
        }
        
        // Botão novo pedido
        const newOrderBtn = document.querySelector('button:contains("Novo Pedido")');
        if (newOrderBtn) {
            newOrderBtn.addEventListener('click', function() {
                // Redirecionar para página de novo pedido
                window.location.href = '<?= url("/vendas/novo") ?>';
            });
        }
        
        // Animar barras do gráfico
        const bars = document.querySelectorAll('[style*="height:"]');
        bars.forEach(bar => {
            const height = bar.style.height;
            bar.style.setProperty('--final-height', height);
            bar.style.height = '0';
            setTimeout(() => {
                bar.style.height = height;
                bar.classList.add('chart-bar');
            }, 100);
        });
    });
</script>