<?php

namespace App\Modules\Config\Controllers;

use App\Core\Security;

class ConfigController
{
    /**
     * Retorna as configurações essenciais para o frontend.
     */
    public function index()
    {
        header('Content-Type: application/json');

        $allApiEndpoints = [
            'cliente' => [
                'list' => BASE_URL . '/cliente/list',
                'create' => BASE_URL . '/cliente/create',
                'update' => BASE_URL . '/cliente/update', // O ID será adicionado no JS
                'delete' => BASE_URL . '/cliente/delete', // O ID será adicionado no JS
                'form' => BASE_URL . '/cliente/form'
            ],
            'customer' => [
                'list' => BASE_URL . '/customer/list',
                'create' => BASE_URL . '/customer/create',
                'update' => BASE_URL . '/customer/update', // O ID será adicionado no JS
                'delete' => BASE_URL . '/customer/delete', // O ID será adicionado no JS
                'form' => BASE_URL . '/customer/form'
            ],
            'fornecedor' => [
                'list' => BASE_URL . '/fornecedor/list',
                'create' => BASE_URL . '/fornecedor/create',
                'update' => BASE_URL . '/fornecedor/update', // O ID será adicionado no JS
                'delete' => BASE_URL . '/fornecedor/delete', // O ID será adicionado no JS
                'form' => BASE_URL . '/fornecedor/form'
            ],
            'contasBancarias' => [
                'list' => BASE_URL . '/contasbancarias/list',
                'create' => BASE_URL . '/contasbancarias/create',
                'update' => BASE_URL . '/contasbancarias/update', // O ID será adicionado no JS
                'delete' => BASE_URL . '/contasbancarias/delete', // O ID será adicionado no JS
                'form' => BASE_URL . '/contasbancarias/form'
            ],
            'planoDeContas' => [
                'list' => BASE_URL . '/financeiro/planodecontas/list',
                'create' => BASE_URL . '/financeiro/planodecontas/create',
                'update' => BASE_URL . '/financeiro/planodecontas/update', // O ID será adicionado no JS
                'delete' => BASE_URL . '/financeiro/planodecontas/delete', // O ID será adicionado no JS
                'form' => BASE_URL . '/financeiro/planodecontas/form'
            ],
            'unidadeMedida' => [
                'list' => BASE_URL . '/estoque/unidademedida/list',
                'create' => BASE_URL . '/estoque/unidademedida/create',
                'update' => BASE_URL . '/estoque/unidademedida/update',
                'delete' => BASE_URL . '/estoque/unidademedida/delete',
                'form' => BASE_URL . '/estoque/unidademedida/form'
            ],
            'categoriaProduto' => [
                'list' => BASE_URL . '/estoque/categoriaproduto/list',
                'create' => BASE_URL . '/estoque/categoriaproduto/create',
                'update' => BASE_URL . '/estoque/categoriaproduto/update',
                'delete' => BASE_URL . '/estoque/categoriaproduto/delete',
                'form' => BASE_URL . '/estoque/categoriaproduto/form'
            ],
            'produtos' => [
                'list' => BASE_URL . '/estoque/produtos/list',
                'create' => BASE_URL . '/estoque/produtos/create',
                'update' => BASE_URL . '/estoque/produtos/update',
                'delete' => BASE_URL . '/estoque/produtos/delete',
                'form' => BASE_URL . '/estoque/produtos/form'
            ],
            'produtoCategoria' => [
                'list' => BASE_URL . '/estoque/categorias/list',
                'create' => BASE_URL . '/estoque/categorias/create',
                'update' => BASE_URL . '/estoque/categorias/update', // O ID será adicionado no JS
                'delete' => BASE_URL . '/estoque/categorias/delete', // O ID será adicionado no JS
                'form' => BASE_URL . '/estoque/categorias/form'
            ],
            'contas-a-pagar' => [
                'list' => BASE_URL . '/financeiro/contasPagar/list',
                'create' => BASE_URL . '/financeiro/contasPagar/create',
                'update' => BASE_URL . '/financeiro/contasPagar/update',
                'delete' => BASE_URL . '/financeiro/contasPagar/delete',
                'form' => BASE_URL . '/financeiro/contasPagar/form'
            ],
            'contas-a-receber' => [
                'list' => BASE_URL . '/financeiro/contasReceber/list',
                'create' => BASE_URL . '/financeiro/contasReceber/create',
                'update' => BASE_URL . '/financeiro/contasReceber/update',
                'delete' => BASE_URL . '/financeiro/contasReceber/delete',
                'form' => BASE_URL . '/financeiro/contasReceber/form'
            ]
            // Adicione outros endpoints aqui
        ];

        $module = $_GET['module'] ?? null;
        $endpoints = [];

        if ($module) {
            if ($module === 'produtos') {
                // Include dependencies
                $endpoints = [
                    'produtos' => $allApiEndpoints['produtos'],
                    'categoriaProduto' => $allApiEndpoints['categoriaProduto'],
                    'unidadeMedida' => $allApiEndpoints['unidadeMedida']
                ];
            } elseif (isset($allApiEndpoints[$module])) {
                $endpoints = [$module => $allApiEndpoints[$module]];
            }
        } elseif (!$module) {
            $endpoints = $allApiEndpoints;
        }

        $config = [
            'baseUrl' => BASE_URL,
            'csrfToken' => Security::generateCSRF(),
            'apiEndpoints' => $endpoints
        ];

        echo json_encode($config);
    }
}
