<div class="p-6">
    <!-- Cabeçalho -->
    <div class="mb-8">
        <div class="flex items-center justify-between mb-4">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">Configurações do Sistema</h1>
                <p class="text-gray-600 mt-1">Gerencie usuários, permissões e preferências do sistema</p>
            </div>
            <div class="flex items-center gap-3">
                <button class="px-4 py-2 bg-gradient-to-r from-gray-700 to-gray-800 text-white rounded-lg hover:from-gray-800 hover:to-gray-900 transition-all duration-300 flex items-center gap-2">
                    <i class="fas fa-sync-alt text-sm"></i>
                    Atualizar
                </button>
                <button class="px-4 py-2 bg-gradient-to-r from-blue-600 to-blue-700 text-white rounded-lg hover:from-blue-700 hover:to-blue-800 transition-all duration-300 flex items-center gap-2">
                    <i class="fas fa-plus text-sm"></i>
                    Novo Usuário
                </button>
            </div>
        </div>
        
        <!-- Status Cards -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
            <!-- Total de Usuários -->
            <div class="bg-gradient-to-br from-gray-50 to-white rounded-xl p-5 shadow-sm border border-gray-100 hover:shadow-md transition-shadow duration-300">
                <div class="flex items-center justify-between mb-4">
                    <div class="w-12 h-12 bg-gradient-to-br from-gray-600 to-gray-700 rounded-lg flex items-center justify-center">
                        <i class="fas fa-users text-white text-lg"></i>
                    </div>
                    <span class="text-sm font-medium text-gray-500">Total</span>
                </div>
                <h3 class="text-2xl font-bold text-gray-800 mb-1">48</h3>
                <p class="text-gray-600 text-sm">Usuários Ativos</p>
                <div class="mt-3 pt-3 border-t border-gray-100">
                    <span class="text-xs text-green-600 flex items-center gap-1">
                        <i class="fas fa-arrow-up"></i>
                        +5 este mês
                    </span>
                </div>
            </div>
            
            <!-- Administradores -->
            <div class="bg-gradient-to-br from-blue-50 to-white rounded-xl p-5 shadow-sm border border-blue-100 hover:shadow-md transition-shadow duration-300">
                <div class="flex items-center justify-between mb-4">
                    <div class="w-12 h-12 bg-gradient-to-br from-blue-600 to-blue-700 rounded-lg flex items-center justify-center">
                        <i class="fas fa-user-shield text-white text-lg"></i>
                    </div>
                    <span class="text-sm font-medium text-blue-600">Admin</span>
                </div>
                <h3 class="text-2xl font-bold text-gray-800 mb-1">12</h3>
                <p class="text-gray-600 text-sm">Administradores</p>
                <div class="mt-3 pt-3 border-t border-blue-100">
                    <span class="text-xs text-blue-600 flex items-center gap-1">
                        <i class="fas fa-user-check"></i>
                        100% ativos
                    </span>
                </div>
            </div>
            
            <!-- Permissões -->
            <div class="bg-gradient-to-br from-emerald-50 to-white rounded-xl p-5 shadow-sm border border-emerald-100 hover:shadow-md transition-shadow duration-300">
                <div class="flex items-center justify-between mb-4">
                    <div class="w-12 h-12 bg-gradient-to-br from-emerald-600 to-emerald-700 rounded-lg flex items-center justify-center">
                        <i class="fas fa-shield-alt text-white text-lg"></i>
                    </div>
                    <span class="text-sm font-medium text-emerald-600">Grupos</span>
                </div>
                <h3 class="text-2xl font-bold text-gray-800 mb-1">8</h3>
                <p class="text-gray-600 text-sm">Grupos de Permissão</p>
                <div class="mt-3 pt-3 border-t border-emerald-100">
                    <span class="text-xs text-emerald-600 flex items-center gap-1">
                        <i class="fas fa-layer-group"></i>
                        32 permissões
                    </span>
                </div>
            </div>
            
            <!-- Atividade -->
            <div class="bg-gradient-to-br from-amber-50 to-white rounded-xl p-5 shadow-sm border border-amber-100 hover:shadow-md transition-shadow duration-300">
                <div class="flex items-center justify-between mb-4">
                    <div class="w-12 h-12 bg-gradient-to-br from-amber-600 to-amber-700 rounded-lg flex items-center justify-center">
                        <i class="fas fa-chart-line text-white text-lg"></i>
                    </div>
                    <span class="text-sm font-medium text-amber-600">Atividade</span>
                </div>
                <h3 class="text-2xl font-bold text-gray-800 mb-1">156</h3>
                <p class="text-gray-600 text-sm">Logins Hoje</p>
                <div class="mt-3 pt-3 border-t border-amber-100">
                    <span class="text-xs text-amber-600 flex items-center gap-1">
                        <i class="fas fa-clock"></i>
                        Última 1h: 24
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Seções Principais -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
        <!-- Gerenciamento de Usuários -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
            <div class="border-b border-gray-200 px-6 py-4 bg-gradient-to-r from-gray-50 to-white">
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-gradient-to-br from-gray-600 to-gray-700 rounded-lg flex items-center justify-center">
                            <i class="fas fa-user-cog text-white"></i>
                        </div>
                        <div>
                            <h3 class="font-bold text-gray-800">Gerenciar Usuários</h3>
                            <p class="text-sm text-gray-600">Administre contas de usuário</p>
                        </div>
                    </div>
                    <a href="<?= url('/usuarios') ?>" class="text-blue-600 hover:text-blue-800 text-sm font-medium flex items-center gap-1">
                        Ver todos
                        <i class="fas fa-arrow-right text-xs"></i>
                    </a>
                </div>
            </div>
            
            <div class="p-6">
                <!-- Lista de Usuários Recentes -->
                <div class="space-y-4">
                    <div class="flex items-center justify-between p-3 hover:bg-gray-50 rounded-lg transition-colors duration-200">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-blue-600 rounded-full flex items-center justify-center">
                                <span class="text-white font-medium">AD</span>
                            </div>
                            <div>
                                <h4 class="font-medium text-gray-800">Admin Sistema</h4>
                                <p class="text-sm text-gray-500">admin@sistema.com</p>
                            </div>
                        </div>
                        <span class="px-3 py-1 bg-blue-100 text-blue-700 text-xs font-medium rounded-full">
                            Admin
                        </span>
                    </div>
                    
                    <div class="flex items-center justify-between p-3 hover:bg-gray-50 rounded-lg transition-colors duration-200">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 bg-gradient-to-br from-emerald-500 to-emerald-600 rounded-full flex items-center justify-center">
                                <span class="text-white font-medium">JS</span>
                            </div>
                            <div>
                                <h4 class="font-medium text-gray-800">João Silva</h4>
                                <p class="text-sm text-gray-500">vendas@empresa.com</p>
                            </div>
                        </div>
                        <span class="px-3 py-1 bg-emerald-100 text-emerald-700 text-xs font-medium rounded-full">
                            Comercial
                        </span>
                    </div>
                    
                    <div class="flex items-center justify-between p-3 hover:bg-gray-50 rounded-lg transition-colors duration-200">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 bg-gradient-to-br from-amber-500 to-amber-600 rounded-full flex items-center justify-center">
                                <span class="text-white font-medium">MF</span>
                            </div>
                            <div>
                                <h4 class="font-medium text-gray-800">Maria Ferreira</h4>
                                <p class="text-sm text-gray-500">financeiro@empresa.com</p>
                            </div>
                        </div>
                        <span class="px-3 py-1 bg-amber-100 text-amber-700 text-xs font-medium rounded-full">
                            Financeiro
                        </span>
                    </div>
                </div>
                
                <!-- Ações Rápidas -->
                <div class="mt-6 pt-6 border-t border-gray-100">
                    <h4 class="font-medium text-gray-800 mb-3">Ações Rápidas</h4>
                    <div class="grid grid-cols-2 gap-3">
                        <button class="px-4 py-2 bg-gradient-to-r from-blue-50 to-blue-100 text-blue-700 rounded-lg hover:from-blue-100 hover:to-blue-200 transition-all duration-300 flex items-center justify-center gap-2 text-sm">
                            <i class="fas fa-user-plus"></i>
                            Novo Usuário
                        </button>
                        <button class="px-4 py-2 bg-gradient-to-r from-gray-50 to-gray-100 text-gray-700 rounded-lg hover:from-gray-100 hover:to-gray-200 transition-all duration-300 flex items-center justify-center gap-2 text-sm">
                            <i class="fas fa-lock"></i>
                            Redefinir Senhas
                        </button>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Controle de Permissões -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
            <div class="border-b border-gray-200 px-6 py-4 bg-gradient-to-r from-gray-50 to-white">
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-gradient-to-br from-gray-600 to-gray-700 rounded-lg flex items-center justify-center">
                            <i class="fas fa-shield-alt text-white"></i>
                        </div>
                        <div>
                            <h3 class="font-bold text-gray-800">Controle de Acesso</h3>
                            <p class="text-sm text-gray-600">Gerencie permissões e grupos</p>
                        </div>
                    </div>
                    <a href="<?= url('/permissoes') ?>" class="text-blue-600 hover:text-blue-800 text-sm font-medium flex items-center gap-1">
                        Ver todos
                        <i class="fas fa-arrow-right text-xs"></i>
                    </a>
                </div>
            </div>
            
            <div class="p-6">
                <!-- Grupos de Permissão -->
                <div class="mb-6">
                    <h4 class="font-medium text-gray-800 mb-4">Grupos de Permissão</h4>
                    <div class="grid grid-cols-2 gap-3">
                        <div class="p-3 bg-blue-50 rounded-lg border border-blue-100">
                            <div class="flex items-center gap-2 mb-2">
                                <i class="fas fa-user-shield text-blue-600"></i>
                                <span class="font-medium text-blue-700">Administrador</span>
                            </div>
                            <p class="text-xs text-blue-600 mb-2">Acesso total ao sistema</p>
                            <span class="text-xs text-gray-500">12 usuários</span>
                        </div>
                        
                        <div class="p-3 bg-emerald-50 rounded-lg border border-emerald-100">
                            <div class="flex items-center gap-2 mb-2">
                                <i class="fas fa-chart-line text-emerald-600"></i>
                                <span class="font-medium text-emerald-700">Gerente</span>
                            </div>
                            <p class="text-xs text-emerald-600 mb-2">Relatórios e análises</p>
                            <span class="text-xs text-gray-500">8 usuários</span>
                        </div>
                        
                        <div class="p-3 bg-purple-50 rounded-lg border border-purple-100">
                            <div class="flex items-center gap-2 mb-2">
                                <i class="fas fa-shopping-cart text-purple-600"></i>
                                <span class="font-medium text-purple-700">Comercial</span>
                            </div>
                            <p class="text-xs text-purple-600 mb-2">Vendas e clientes</p>
                            <span class="text-xs text-gray-500">18 usuários</span>
                        </div>
                        
                        <div class="p-3 bg-amber-50 rounded-lg border border-amber-100">
                            <div class="flex items-center gap-2 mb-2">
                                <i class="fas fa-coins text-amber-600"></i>
                                <span class="font-medium text-amber-700">Financeiro</span>
                            </div>
                            <p class="text-xs text-amber-600 mb-2">Contas e pagamentos</p>
                            <span class="text-xs text-gray-500">10 usuários</span>
                        </div>
                    </div>
                </div>
                
                <!-- Configurações do Sistema -->
                <div class="pt-6 border-t border-gray-100">
                    <h4 class="font-medium text-gray-800 mb-3">Configurações do Sistema</h4>
                    <div class="space-y-3">
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div class="flex items-center gap-3">
                                <i class="fas fa-bell text-gray-600"></i>
                                <span class="text-sm text-gray-700">Notificações por Email</span>
                            </div>
                            <div class="w-12 h-6 bg-blue-600 rounded-full relative">
                                <div class="absolute right-1 top-1 w-4 h-4 bg-white rounded-full"></div>
                            </div>
                        </div>
                        
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div class="flex items-center gap-3">
                                <i class="fas fa-history text-gray-600"></i>
                                <span class="text-sm text-gray-700">Log de Atividades</span>
                            </div>
                            <div class="w-12 h-6 bg-gray-300 rounded-full relative">
                                <div class="absolute left-1 top-1 w-4 h-4 bg-white rounded-full"></div>
                            </div>
                        </div>
                        
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div class="flex items-center gap-3">
                                <i class="fas fa-key text-gray-600"></i>
                                <span class="text-sm text-gray-700">Autenticação em 2 fatores</span>
                            </div>
                            <button class="px-3 py-1 bg-gradient-to-r from-blue-600 to-blue-700 text-white text-xs rounded-lg hover:from-blue-700 hover:to-blue-800 transition-all duration-300">
                                Ativar
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Atividade Recente -->
    <div class="mt-8">
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
            <div class="border-b border-gray-200 px-6 py-4 bg-gradient-to-r from-gray-50 to-white">
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-gradient-to-br from-gray-600 to-gray-700 rounded-lg flex items-center justify-center">
                            <i class="fas fa-history text-white"></i>
                        </div>
                        <div>
                            <h3 class="font-bold text-gray-800">Atividade Recente</h3>
                            <p class="text-sm text-gray-600">Últimas ações no sistema</p>
                        </div>
                    </div>
                    <button class="text-gray-600 hover:text-gray-800 text-sm font-medium flex items-center gap-1">
                        <i class="fas fa-filter"></i>
                        Filtrar
                    </button>
                </div>
            </div>
            
            <div class="p-6">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="border-b border-gray-200">
                                <th class="text-left py-3 text-sm font-medium text-gray-600">Usuário</th>
                                <th class="text-left py-3 text-sm font-medium text-gray-600">Ação</th>
                                <th class="text-left py-3 text-sm font-medium text-gray-600">Módulo</th>
                                <th class="text-left py-3 text-sm font-medium text-gray-600">Data/Hora</th>
                                <th class="text-left py-3 text-sm font-medium text-gray-600">Status</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100">
                            <tr class="hover:bg-gray-50 transition-colors duration-200">
                                <td class="py-3">
                                    <div class="flex items-center gap-2">
                                        <div class="w-8 h-8 bg-gradient-to-br from-blue-500 to-blue-600 rounded-full"></div>
                                        <span class="text-sm text-gray-800">Admin Sistema</span>
                                    </div>
                                </td>
                                <td class="py-3 text-sm text-gray-600">Novo usuário criado</td>
                                <td class="py-3">
                                    <span class="px-2 py-1 bg-blue-100 text-blue-700 text-xs rounded">Configurações</span>
                                </td>
                                <td class="py-3 text-sm text-gray-600">10:30 AM</td>
                                <td class="py-3">
                                    <span class="px-2 py-1 bg-green-100 text-green-700 text-xs rounded">Sucesso</span>
                                </td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors duration-200">
                                <td class="py-3">
                                    <div class="flex items-center gap-2">
                                        <div class="w-8 h-8 bg-gradient-to-br from-emerald-500 to-emerald-600 rounded-full"></div>
                                        <span class="text-sm text-gray-800">João Silva</span>
                                    </div>
                                </td>
                                <td class="py-3 text-sm text-gray-600">Permissões atualizadas</td>
                                <td class="py-3">
                                    <span class="px-2 py-1 bg-emerald-100 text-emerald-700 text-xs rounded">Comercial</span>
                                </td>
                                <td class="py-3 text-sm text-gray-600">09:45 AM</td>
                                <td class="py-3">
                                    <span class="px-2 py-1 bg-green-100 text-green-700 text-xs rounded">Sucesso</span>
                                </td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors duration-200">
                                <td class="py-3">
                                    <div class="flex items-center gap-2">
                                        <div class="w-8 h-8 bg-gradient-to-br from-amber-500 to-amber-600 rounded-full"></div>
                                        <span class="text-sm text-gray-800">Maria Ferreira</span>
                                    </div>
                                </td>
                                <td class="py-3 text-sm text-gray-600">Tentativa de acesso negado</td>
                                <td class="py-3">
                                    <span class="px-2 py-1 bg-amber-100 text-amber-700 text-xs rounded">Financeiro</span>
                                </td>
                                <td class="py-3 text-sm text-gray-600">08:15 AM</td>
                                <td class="py-3">
                                    <span class="px-2 py-1 bg-red-100 text-red-700 text-xs rounded">Negado</span>
                                </td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors duration-200">
                                <td class="py-3">
                                    <div class="flex items-center gap-2">
                                        <div class="w-8 h-8 bg-gradient-to-br from-purple-500 to-purple-600 rounded-full"></div>
                                        <span class="text-sm text-gray-800">Carlos Santos</span>
                                    </div>
                                </td>
                                <td class="py-3 text-sm text-gray-600">Senha redefinida</td>
                                <td class="py-3">
                                    <span class="px-2 py-1 bg-purple-100 text-purple-700 text-xs rounded">Cadastros</span>
                                </td>
                                <td class="py-3 text-sm text-gray-600">Ontem, 17:30</td>
                                <td class="py-3">
                                    <span class="px-2 py-1 bg-green-100 text-green-700 text-xs rounded">Sucesso</span>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Estilos adicionais -->
<style>
    /* Animação suave para os cards */
    .hover-lift {
        transition: transform 0.2s ease, box-shadow 0.2s ease;
    }
    
    .hover-lift:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
    }
    
    /* Estilo para o toggle switch */
    .toggle-switch {
        position: relative;
        display: inline-block;
        width: 48px;
        height: 24px;
    }
    
    .toggle-switch input {
        opacity: 0;
        width: 0;
        height: 0;
    }
    
    .toggle-slider {
        position: absolute;
        cursor: pointer;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #ccc;
        transition: .4s;
        border-radius: 24px;
    }
    
    .toggle-slider:before {
        position: absolute;
        content: "";
        height: 16px;
        width: 16px;
        left: 4px;
        bottom: 4px;
        background-color: white;
        transition: .4s;
        border-radius: 50%;
    }
    
    input:checked + .toggle-slider {
        background-color: #3b82f6;
    }
    
    input:checked + .toggle-slider:before {
        transform: translateX(24px);
    }
</style>

<!-- Script para interatividade -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Adicionar efeito hover lift aos cards
        const cards = document.querySelectorAll('.bg-gradient-to-br');
        cards.forEach(card => {
            card.addEventListener('mouseenter', function() {
                this.classList.add('hover-lift');
            });
            
            card.addEventListener('mouseleave', function() {
                this.classList.remove('hover-lift');
            });
        });
        
        // Toggle switches
        const toggles = document.querySelectorAll('.toggle-switch');
        toggles.forEach(toggle => {
            toggle.addEventListener('click', function() {
                const input = this.querySelector('input');
                input.checked = !input.checked;
            });
        });
        
        // Botão de atualizar
        const refreshBtn = document.querySelector('button:contains("Atualizar")');
        if (refreshBtn) {
            refreshBtn.addEventListener('click', function() {
                this.innerHTML = '<i class="fas fa-spinner fa-spin text-sm"></i> Atualizando...';
                setTimeout(() => {
                    this.innerHTML = '<i class="fas fa-sync-alt text-sm"></i> Atualizar';
                    // Aqui você pode adicionar lógica para atualizar os dados
                }, 1000);
            });
        }
    });
</script>