<?php

namespace App\Modules\ContasBancarias\Models;

use App\Core\Orm;

class ContasBancariasModel extends Orm
{
    public function __construct()
    {
        parent::__construct();
        $this->tabela = "conta_bancaria";
        $this->chave_primaria = "conta_bancaria_id";
        $this->order_by = "conta_bancaria_id DESC";

        // Configuração dos Timestamps automáticos do ORM
        $this->created_at_column = 'conta_bancaria_criadoEm';
        $this->updated_at_column = 'conta_bancaria_alteradoEm';

        $this->colunas = [
            'conta_bancaria_id as id',
            'conta_bancaria_nome as name',
            'conta_bancaria_conta as account',
            'conta_bancaria_tipo as type',
            'conta_bancaria_titular as holder',
            'conta_bancaria_status as status',
            'conta_bancaria_observacao as observation',
            'conta_bancaria_criadoEm as created_at',
            'conta_bancaria_alteradoEm as updated_at'
        ];
    }

    /**
     * Atalho estático para iniciar uma consulta fluida
     * @return self
     */
    public static function query()
    {
        return new self();
    }

    public function getDashboardStats()
    {
        $stats = [];

        // Total de Contas
        $stats['total_conta_bancaria'] = (new self())->contar();

        // Total de Contas Ativas
        $stats['total_conta_bancaria_ativos'] = (new self())
            ->and('conta_bancaria_status', 'Ativa')
            ->contar();

        // Total de Contas Inativas
        $stats['total_conta_bancaria_inativos'] = (new self())
            ->and('conta_bancaria_status', 'Inativa')
            ->contar();

        // Total de Contas Inativas
        $stats['total_conta_corrente'] = (new self())
            ->and('conta_bancaria_tipo', 'corrente')
            ->contar();

        // Total de Contas Inativas
        $stats['total_conta_poupanca'] = (new self())
            ->and('conta_bancaria_tipo', 'poupanca')
            ->contar();

        // Total de Contas Inativas
        $stats['total_conta_salario'] = (new self())
            ->and('conta_bancaria_tipo', 'salario')
            ->contar();

        // Total de Contas Inativas
        $stats['total_conta_investimento'] = (new self())
            ->and('conta_bancaria_tipo', 'investimento')
            ->contar();


        return $stats;
    }
}
