<div id="toast"
    class="fixed top-5 right-5 p-4 rounded-xl shadow-lg z-50 hidden flex items-center transition-all duration-300 transform translate-x-full">
    <i class="fas fa-check-circle mr-2"></i>
    <span id="toast-message"></span>
</div>

<div class="h-screen bg-gradient-to-br from-gray-50 to-gray-100 p-4 md:p-6">
    <div class="mx-auto container p-4">
        <!-- Header -->
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-8 gap-4">
            <div class="flex items-center gap-3">
                <div class="p-3 bg-gradient-to-br from-purple-500 to-violet-400 rounded-xl shadow-md">
                    <i class="fas fa-university text-white text-lg"></i>
                </div>
                <div class="min-w-0">
                    <h1 class="text-2xl sm:text-3xl font-bold text-gray-800 truncate"><?= e($title) ?></h1>
                    <p class="text-gray-600 text-sm mt-1 truncate">Adicione as informações da Conta Bancária</p>
                </div>
            </div>

            <a href="<?= BASE_URL ?>/contasBancarias"
                class="flex items-center gap-2 px-4 py-2.5 bg-gray-500 text-white rounded-md hover:bg-gray-600  font-medium transition-all border border-grey-200 hover:border-grey-300 shadow-sm hover:shadow whitespace-nowrap">
                <i class="fas fa-arrow-left text-sm"></i>
                Voltar para a Lista
            </a>
        </div>

        <!-- Form Container -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-200 overflow-hidden">
            <!-- Header -->
            <div class="px-6 py-4 border-b border-gray-100 bg-purple-50">
                <div class="flex items-center justify-between">
                    <h2 class="text-lg font-semibold text-gray-800 truncate">
                        <i class="fas fa-university mr-2"></i>
                        Dados da Conta Bancária
                    </h2>

                    <?php if (isset($conta->id)): ?>
                        <div class="flex items-center gap-2">
                            <div
                                class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium
                            <?= ($conta->status === 'Ativo') ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' ?>">
                                <i
                                    class="fas <?= ($conta->status === 'Ativo') ? 'fa-check-circle' : 'fa-times-circle' ?> mr-1"></i>
                                <?= e($conta->status) ?>
                            </div>
                            <span class="text-gray-500 text-sm">ID: #<?= e($conta->id) ?></span>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Form -->
            <form id="contas-bancarias-form" class="p-4 sm:p-6">

                <input type="hidden" name="id" id="conta-bancaria-id" value="<?= e($conta->id ?? '') ?>">

                <div class="space-y-8">

                    <!-- Informações Básicas -->
                    <div>
                        <h3 class="text-sm font-semibold text-gray-700 uppercase tracking-wider mb-4 flex items-center">
                            <i class="fas fa-info-circle mr-2"></i>
                            Informações Básicas
                        </h3>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">

                            <!-- Nome da Conta -->
                            <div>
                                <label class="text-xs font-medium text-gray-700 uppercase tracking-wider">
                                    Nome da Conta <span class="text-red-500">*</span>
                                </label>
                                <input type="text" name="name" required placeholder="Ex: Conta Principal"
                                    value="<?= e($conta->name ?? '') ?>" class="mt-1 w-full px-4 py-3 border border-gray-300 rounded-lg
                                        focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-sm">
                            </div>

                            <!-- Tipo -->
                            <div>
                                <label class="text-xs font-medium text-gray-700 uppercase tracking-wider">
                                    Tipo <span class="text-red-500">*</span>
                                </label>
                                <select name="type" required class="mt-1 w-full px-4 py-3 border border-gray-300 rounded-lg
                                        focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-sm">
                                    <option value="">Selecione</option>
                                    <option value="corrente" <?= ($conta->type ?? '') === 'corrente' ? 'selected' : '' ?>>
                                        Conta Corrente</option>
                                    <option value="poupanca" <?= ($conta->type ?? '') === 'poupança' ? 'selected' : '' ?>>
                                        Poupança</option>
                                    <option value="salario" <?= ($conta->type ?? '') === 'salario' ? 'selected' : '' ?>>
                                        Conta Salário</option>
                                    <option value="investimento" <?= ($conta->type ?? '') === 'investimento' ? 'selected' : '' ?>>Conta Investimento</option>
                                </select>
                            </div>

                        </div>
                    </div>

                    <!-- Dados Bancários -->
                    <div>
                        <h3 class="text-sm font-semibold text-gray-700 uppercase tracking-wider mb-4 flex items-center">
                            <i class="fas fa-money-check-alt mr-2"></i>
                            Dados Bancários
                        </h3>

                        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">

                            <!-- Número da Conta -->
                            <div>
                                <label class="text-xs font-medium text-gray-700 uppercase tracking-wider">
                                    Número da Conta <span class="text-red-500">*</span>
                                </label>
                                <input type="text" name="account" required placeholder="00000-0"
                                    value="<?= e($conta->account ?? '') ?>" class="mt-1 w-full px-4 py-3 border border-gray-300 rounded-lg
                                        focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-sm">
                            </div>

                            <!-- Titular -->
                            <div>
                                <label class="text-xs font-medium text-gray-700 uppercase tracking-wider">
                                    Titular <span class="text-red-500">*</span>
                                </label>
                                <input type="text" name="holder" required placeholder="Nome do Titular"
                                    value="<?= e($conta->holder ?? '') ?>" class="mt-1 w-full px-4 py-3 border border-gray-300 rounded-lg
                                        focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-sm">
                            </div>

                            <!-- Status -->
                            <div>
                                <label class="text-xs font-medium text-gray-700 uppercase tracking-wider">
                                    Status <span class="text-red-500">*</span>
                                </label>
                                <select name="status" required class="mt-1 w-full px-4 py-3 border border-gray-300 rounded-lg
                                        focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-sm">
                                    <option value="">Selecione</option>
                                    <option value="Ativa" <?= ($conta->status ?? '') === 'Ativa' ? 'selected' : '' ?>>Ativo
                                    </option>
                                    <option value="Inativa" <?= ($conta->status ?? '') === 'Inativa' ? 'selected' : '' ?>>
                                        Inativo</option>
                                </select>
                            </div>

                        </div>
                    </div>

                    <!-- Observações -->
                    <div>
                        <h3 class="text-sm font-semibold text-gray-700 uppercase tracking-wider mb-4 flex items-center">
                            <i class="fas fa-sticky-note mr-2"></i>
                            Observações
                        </h3>

                        <textarea name="observation" rows="4" placeholder="Observações adicionais sobre a conta..."
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg
                                    focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-sm">
                                    <?= e($conta->observation ?? '') ?>
                    </textarea>
                    </div>

                </div>

                <!-- Actions -->
                <div
                    class="flex flex-col sm:flex-row justify-between items-center gap-4 mt-8 pt-6 border-t border-gray-200">
                    <div class="text-sm text-gray-500 w-full sm:w-auto text-center sm:text-left">
                        <p class="flex items-center justify-center sm:justify-start gap-2 flex-wrap">
                            <i class="fas fa-info-circle flex-shrink-0"></i>
                            <span>Campos marcados com <span class="text-red-500">*</span>, são obrigatórios.</span>
                        </p>
                    </div>
                    <div class="flex flex-col sm:flex-row gap-3 w-full sm:w-auto mt-4">
                        <button type="submit" id="submit-btn"
                            class="flex items-center justify-center gap-2 px-4 sm:px-5 py-2.5 bg-gradient-to-r from-blue-600 to-indigo-600 text-white rounded-xl font-medium hover:shadow-lg hover:from-blue-700 hover:to-indigo-700 transition-all shadow-md hover:scale-[1.00] whitespace-nowrap order-1 sm:order-2">
                            <i class="fas fa-save"></i>
                            <span id="submit-text">Salvar Conta</span>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script type="module" src="<?= BASE_URL ?>/assets/js/contasBancarias/contasBancariasWrapper.js"></script>