<div id="toast" class="fixed top-5 right-5 bg-green-500 text-white py-2 px-4 rounded-lg shadow-md z-50"
    style="display: none; transition: opacity 0.5s ease;"></div>

<div class="container mx-auto p-4">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold"><?= e($title) ?></h1>
        <a href="<?= BASE_URL ?>/contasBancarias/form"
            class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 shadow-sm">Nova Conta</a>
    </div>

    <!-- Stats Section -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">

        <div class="bg-white p-6 rounded-xl shadow-md border-l-4 border-blue-500 hover:shadow-lg transition-shadow">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-semibold text-gray-500 uppercase tracking-wide">Total</p>
                    <p class="text-3xl font-bold text-gray-900 mt-2" id="total-suppliers">
                        <?= e($stats['total_conta_bancaria'] ?? 0) ?></p>
                    <div class="flex items-center mt-1">
                        <span class="text-xs text-gray-500">Todas as Contas</span>
                    </div>
                </div>
                <div class="p-3 bg-blue-50 rounded-full">
                    <i class="fa-solid fa-money-bill-wave text-blue-600 text-xl"></i>

                </div>
            </div>
        </div>


        <div class="bg-white p-6 rounded-xl shadow-md border-l-4 border-green-500 hover:shadow-lg transition-shadow">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-semibold text-gray-500 uppercase tracking-wide">Ativas</p>
                    <p class="text-3xl font-bold text-green-600 mt-2" id="active-suppliers">
                        <?= e($stats['total_conta_bancaria_ativos'] ?? 0) ?></p>
                    <div class="flex items-center mt-1">
                        <span class="text-xs text-green-500">
                            <i class="fa-solid fa-arrow-up mr-1"></i>
                            <span id="active-percentage">0%</span> do total
                        </span>
                    </div>
                </div>
                <div class="p-3 bg-green-50 rounded-full">
                    <i class="fa-solid fa-check-circle text-green-600 text-xl"></i>
                </div>
            </div>
        </div>


        <div class="bg-white p-6 rounded-xl shadow-md border-l-4 border-red-500 hover:shadow-lg transition-shadow">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-semibold text-gray-500 uppercase tracking-wide">Inativas</p>
                    <p class="text-3xl font-bold text-gray-600 mt-2" id="inactive-suppliers">
                        <?= e($stats['total_conta_bancaria_inativos'] ?? 0) ?></p>
                    <div class="flex items-center mt-1">
                        <span class="text-xs text-gray-500">
                            <span id="inactive-percentage">0%</span> do total
                        </span>
                    </div>
                </div>
                <div class="p-3 bg-gray-100 rounded-full">
                    <i class="fa-solid fa-pause-circle text-gray-600 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white p-6 rounded-xl shadow-md border-l-4 border-purple-400 hover:shadow-lg transition-shadow">
            <p class="text-sm font-semibold text-gray-500 uppercase tracking-wide mb-2">
                Tipos de Contas
            </p>
            <!-- Tipos -->
            <div class="grid grid-cols-2 gap-3 mb-4">
                <!-- Corrente -->
                <span class="inline-flex items-center justify-between px-3 py-1.5 rounded-full
                            bg-blue-50 text-blue-700 text-xs font-medium">
                    <span class="inline-flex items-center gap-2">
                        <i class="fas fa-university text-xs"></i>
                        Corrente
                    </span>

                    <span class="flex items-center justify-center w-5 h-5 rounded-full
                                bg-blue-600 text-white text-[10px] font-semibold">
                        <?= e($stats['total_conta_corrente'] ?? 0) ?>
                    </span>
                </span>
                <!-- Poupança -->
                <span class="inline-flex items-center justify-between px-3 py-1.5 rounded-full
                            bg-emerald-50 text-emerald-700 text-xs font-medium">
                    <span class="inline-flex items-center gap-2">
                        <i class="fas fa-piggy-bank text-xs"></i>
                        Poupança
                    </span>

                    <span class="flex items-center justify-center w-5 h-5 rounded-full
                                bg-emerald-600 text-white text-[10px] font-semibold">
                        <?= e($stats['total_conta_poupanca'] ?? 0) ?>
                    </span>
                </span>
                <!-- Salário -->
                <span class="inline-flex items-center justify-between px-3 py-1.5 rounded-full
                            bg-amber-50 text-amber-700 text-xs font-medium">
                    <span class="inline-flex items-center gap-2">
                        <i class="fas fa-money-check-alt text-xs"></i>
                        Salário
                    </span>
                    <span class="flex items-center justify-center w-5 h-5 rounded-full
                                bg-amber-600 text-white text-[10px] font-semibold">
                        <?= e($stats['total_conta_salario'] ?? 0) ?>
                    </span>
                </span>
                <!-- Outros -->
                <span class="inline-flex items-center justify-between px-3 py-1.5 rounded-full
                            bg-gray-100 text-gray-700 text-xs font-medium">
                    <span class="inline-flex items-center gap-2">
                        <i class="fas fa-ellipsis-h text-xs"></i>
                        Invest.
                    </span>
                    <span class="flex items-center justify-center w-5 h-5 rounded-full
                                bg-gray-600 text-white text-[10px] font-semibold">
                        <?= e($stats['total_conta_investimento'] ?? 0) ?>
                    </span>
                </span>
            </div>
        </div>
    </div>

    <!-- End Stats Section -->
    <div class="bg-white p-6 rounded-lg shadow-md">
        <h2 class="text-xl font-bold mb-4">Lista de Contas Bancárias</h2>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nome
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Conta
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tipo
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Titular</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Status</th>
                        <!-- <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Obs.</th> -->
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Ações</th>
                    </tr>
                </thead>
                <tbody id="contas-bancarias-list" class="bg-white divide-y divide-gray-200">
                    <!-- As linhas serão inseridas aqui via JavaScript -->
                </tbody>
            </table>
        </div>
        <!-- Pagination Controls -->
        <div id="pagination-controls" class="mt-4 flex justify-center items-center space-x-2">
            <!-- Os botões da paginação serão inseridos aqui pelo JavaScript -->
        </div>
    </div>
</div>

<script type="module" src="<?= BASE_URL ?>/assets/js/contasBancarias/contasBancariasWrapper.js"></script>