<div id="toast" class="fixed top-5 right-5 bg-green-500 text-white py-2 px-4 rounded-lg shadow-md z-50"
    style="display: none; transition: opacity 0.5s ease;"></div>

<div class="h-screen bg-gradient-to-br from-gray-50 to-gray-100 p-4 md:p-6">
    <div class="mx-auto container p-4">
        <!-- Header -->
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-8 gap-4">
            <div class="flex items-center gap-3">
                <div class="p-3 bg-gradient-to-r from-blue-500 to-cyan-400 rounded-xl shadow-md">
                    <i class="fas fa-users text-white text-lg"></i>
                </div>
                <div class="min-w-0">
                    <h1 class="text-2xl sm:text-3xl font-bold text-gray-800 truncate"><?= e($title) ?></h1>
                    <p class="text-gray-600 text-sm mt-1 truncate">Adicione as informações do cliente</p>
                </div>
            </div>

            <a href="<?= BASE_URL ?>/customer"
                class="flex items-center gap-2 px-4 py-2.5 bg-gray-500 text-white rounded-md hover:bg-gray-600  font-medium transition-all border border-grey-200 hover:border-grey-300 shadow-sm hover:shadow whitespace-nowrap">
                <i class="fas fa-arrow-left text-sm"></i>
                Voltar para a Lista
            </a>
        </div>

        <!-- Form Container -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-200 overflow-hidden">
            <!-- Form Header -->
            <div class="px-6 py-4 border-b border-gray-100 bg-blue-50">
                <div class="flex items-center justify-between">
                    <h2 class="text-lg font-semibold text-gray-800 truncate">
                        <i class="fas fa-edit mr-2"></i>
                        Dados do Cliente
                    </h2>
                </div>
            </div>

            <!-- Form -->
            <form id="customer-form" class="p-4 sm:p-6">
                <!-- Hidden fields -->
                <input type="hidden" name="id" id="customer-id" value="<?= e($customer->id ?? '') ?>">

                <div class="space-y-6 sm:space-y-8">
                    <!-- Informações Básicas -->
                    <div>
                        <h3 class="text-sm font-semibold text-gray-700 uppercase tracking-wider mb-4 flex items-center">
                            <i class="fas fa-user mr-2 flex-shrink-0"></i>
                            <span class="truncate">Informações Básicas</span>
                        </h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 sm:gap-6">
                            <!-- Nome -->
                            <div class="w-full">
                                <div class="flex items-center justify-between mb-1">
                                    <label for="name"
                                        class="text-xs font-medium text-gray-700 uppercase tracking-wider">
                                        NOME <span class="text-red-500 ml-1">*</span>
                                    </label>
                                </div>
                                <div class="relative">
                                    <input type="text" id="name" name="name" required placeholder="Nome do Cliente"
                                        class="w-full px-4 pr-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200 text-sm"
                                        value="<?= e($customer->name ?? '') ?>">
                                </div>
                            </div>

                            <div class="w-full">
                                <div class="flex items-center justify-between mb-1">
                                    <label for="cpf" class="text-xs font-medium text-gray-700 uppercase tracking-wider">
                                        CPF
                                    </label>
                                </div>
                                <div class="relative">
                                    <input type="text" id="cpf" name="cpf" placeholder="123.456.789-00"
                                        class="w-full px-4 pr-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200 text-sm"
                                        value="<?= e($customer->cpf ?? '') ?>" <?= isset($customer->id) ? 'disabled' : '' ?>>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Contato -->
                    <div>
                        <h3
                            class="text-sm font-semibold text-gray-700 uppercase tracking-wider mb-4 flex items-center mt-4">
                            <i class="fas fa-envelope mr-2 flex-shrink-0"></i>
                            <span class="truncate">Contato</span>
                        </h3>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 sm:gap-6">
                            <!-- Telefone -->
                            <div class="w-full">
                                <div class="flex items-center justify-between mb-1">
                                    <label for="phone"
                                        class="text-xs font-medium text-gray-700 uppercase tracking-wider">
                                        Telefone
                                    </label>
                                </div>
                                <div class="relative">
                                    <input type="text" id="phone" name="phone" placeholder="(99) 99999-9999"
                                        class="w-full px-4 pr-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200 text-sm"
                                        value="<?= e($customer->phone ?? '') ?>">
                                </div>
                            </div>

                            <div class="w-full">
                                <div class="flex items-center justify-between mb-1">
                                    <label for="address"
                                        class="text-xs font-medium text-gray-700 uppercase tracking-wider">
                                        Endereço <span class="text-red-500 ml-1">*</span>
                                    </label>
                                </div>
                                <input type="text" id="address" name="address" placeholder="Av.nome n. 851"
                                    class="w-full px-4 pr-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200 text-sm"
                                    value="<?= e($customer->address ?? '') ?>">
                            </div>
                            <!-- Limite de Crédito -->
                            <div class="w-full">
                                <div class="flex items-center justify-between mb-1">
                                    <label for="credit_limit"
                                        class="text-xs font-medium text-gray-700 uppercase tracking-wider">
                                        Limite de Crédito
                                    </label>
                                </div>
                                <div class="relative">
                                    <input type="text" id="credit_limit" name="credit_limit" step="0.01"
                                        class="w-full px-4 pr-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200 text-sm"
                                        value="<?= e($customer->credit_limit ?? '') ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Form Actions -->
                <div
                    class="flex flex-col sm:flex-row justify-between items-center gap-4 mt-8 sm:mt-8 pt-6 border-t border-gray-200">
                    <div class="text-sm text-gray-500 w-full sm:w-auto text-center sm:text-left">
                        <p class="flex items-center justify-center sm:justify-start gap-2 flex-wrap">
                            <i class="fas fa-info-circle flex-shrink-0"></i>
                            <span>Campos marcados com <span class="text-red-500">*</span>, são obrigatórios.</span>
                        </p>
                    </div>

                    <div class="flex flex-col sm:flex-row gap-3 w-full sm:w-auto mt-4">
                        <button type="submit" id="submit-btn"
                            class="flex items-center justify-center gap-2 px-4 sm:px-5 py-2.5 bg-gradient-to-r from-blue-600 to-indigo-600 text-white rounded-xl font-medium hover:shadow-lg hover:from-blue-700 hover:to-indigo-700 transition-all shadow-md hover:scale-[1.00] whitespace-nowrap order-1 sm:order-2">
                            <i class="fas fa-save"></i>
                            <span id="submit-text">Salvar Cliente</span>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<script type="module" src="<?= BASE_URL ?>/assets/js/customer/customerWrapper.js"></script>