<?php

namespace App\Modules\Estoque\CategoriaProduto\Models;

use App\Core\Orm;

class CategoriaProdutoModel extends Orm
{
    public function __construct()
    {
        parent::__construct();
        $this->tabela = "produto_categoria";
        $this->chave_primaria = "produto_categoria_id";
        $this->order_by = "produto_categoria_id DESC";

        $this->created_at_column = 'produto_categoria_criadoEm';
        $this->updated_at_column = 'produto_categoria_alteradoEm';

        $this->colunas = [
            'produto_categoria_id',
            'produto_categoria_nome',
            'produto_categoria_criadoEm',
            'produto_categoria_alteradoEm'
        ];
    }

    public static function query()
    {
        return new self();
    }

    public function getDashboardStats()
    {
        $stats = [];
        $stats['total_categorias'] = (new self())->contar();
        return $stats;
    }
}
