<?php

namespace App\Modules\Estoque\UnidadeMedida\Models;

use App\Core\Orm;

class UnidadeMedidaModel extends Orm
{
    public function __construct()
    {
        parent::__construct();
        $this->tabela = "unidade_medida";
        $this->chave_primaria = "unidade_medida_id";
        $this->order_by = "unidade_medida_id DESC";

        $this->created_at_column = 'unidade_medida_criadoEm';
        $this->updated_at_column = 'unidade_medida_alteradoEm';

        $this->colunas = [
            'unidade_medida_id',
            'unidade_medida_nome',
            'unidade_medida_criadoEm',
            'unidade_medida_alteradoEm'
        ];
    }

    public static function query()
    {
        return new self();
    }

    public function getDashboardStats()
    {
        $stats = [];
        $stats['total_unidades'] = (new self())->contar();
        return $stats;
    }
}
