<!-- Main Content -->
<div class="mb-8 md:mb-12">
    <!-- Header -->
    <div class="mb-8 md:mb-10">
        <div class="flex flex-col sm:flex-row sm:items-center justify-between gap-4">
            <div class="flex-1 min-w-0">
                <div class="flex items-center gap-3 mb-2">
                    <div
                        class="w-10 h-10 md:w-12 md:h-12 rounded-xl bg-gradient-to-br from-blue-500 to-blue-600 flex items-center justify-center shadow-md">
                        <i class="fas fa-warehouse text-white text-lg md:text-xl"></i>
                    </div>
                    <h1 class="text-2xl sm:text-3xl lg:text-4xl font-bold text-gray-800">
                        Módulo Estoque
                    </h1>
                </div>
                <p class="text-gray-600 text-sm md:text-base max-w-2xl">
                    Controle completo de produtos, categorias e movimentações.
                    <span class="text-blue-600 font-medium">Atualizado em tempo real</span>
                </p>
            </div>

            <div class="flex items-center gap-3">
                <button
                    class="px-4 py-2 bg-gradient-to-r from-blue-500 to-blue-600 hover:from-blue-600 hover:to-blue-700 text-white rounded-lg font-medium text-sm transition-all duration-200 shadow-md hover:shadow-lg flex items-center gap-2">
                    <i class="fas fa-plus"></i>
                    Nova Movimentação
                </button>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="grid grid-cols-1 xs:grid-cols-2 lg:grid-cols-4 gap-5 md:gap-6 mb-8 md:mb-10">
        <!-- Total de Produtos -->
        <div
            class="group bg-white rounded-2xl p-5 border border-gray-200 shadow-sm hover:shadow-md transition-all duration-300 hover:border-blue-200 hover:scale-[1.00] relative overflow-hidden">
            <div
                class="absolute top-0 right-0 w-24 h-24 bg-gradient-to-br from-blue-100 to-transparent opacity-60 rounded-full -translate-y-8 translate-x-8">
            </div>
            <div class="relative z-10">
                <div class="flex items-start justify-between mb-4">
                    <div>
                        <div class="text-2xl md:text-3xl font-bold text-gray-800 mb-1">320</div>
                        <div class="text-gray-600 text-sm">Produtos Cadastrados</div>
                    </div>
                    <div
                        class="w-12 h-12 rounded-xl bg-gradient-to-br from-blue-500 to-blue-600 flex items-center justify-center shadow-md group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-boxes text-white text-lg"></i>
                    </div>
                </div>
                <div class="pt-4 border-t border-gray-100">
                    <div class="flex items-center text-sm text-blue-600 font-medium">
                        <i class="fas fa-arrow-up text-xs mr-1"></i>
                        <span>+12% este mês</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Categorias -->
        <div
            class="group bg-white rounded-2xl p-5 border border-gray-200 shadow-sm hover:shadow-md transition-all duration-300 hover:border-emerald-200 hover:scale-[1.00] relative overflow-hidden">
            <div
                class="absolute top-0 right-0 w-24 h-24 bg-gradient-to-br from-emerald-100 to-transparent opacity-60 rounded-full -translate-y-8 translate-x-8">
            </div>
            <div class="relative z-10">
                <div class="flex items-start justify-between mb-4">
                    <div>
                        <div class="text-2xl md:text-3xl font-bold text-gray-800 mb-1">12</div>
                        <div class="text-gray-600 text-sm">Categorias Ativas</div>
                    </div>
                    <div
                        class="w-12 h-12 rounded-xl bg-gradient-to-br from-emerald-500 to-emerald-600 flex items-center justify-center shadow-md group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-tags text-white text-lg"></i>
                    </div>
                </div>
                <div class="pt-4 border-t border-gray-100">
                    <div class="flex items-center text-sm text-emerald-600 font-medium">
                        <i class="fas fa-layer-group text-xs mr-1"></i>
                        <span>3 categorias principais</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Estoque Baixo -->
        <div
            class="group bg-white rounded-2xl p-5 border border-gray-200 shadow-sm hover:shadow-md transition-all duration-300 hover:border-amber-200 hover:scale-[1.00] relative overflow-hidden">
            <div
                class="absolute top-0 right-0 w-24 h-24 bg-gradient-to-br from-amber-100 to-transparent opacity-60 rounded-full -translate-y-8 translate-x-8">
            </div>
            <div class="relative z-10">
                <div class="flex items-start justify-between mb-4">
                    <div>
                        <div class="text-2xl md:text-3xl font-bold text-gray-800 mb-1">7</div>
                        <div class="text-gray-600 text-sm">Estoque Baixo</div>
                    </div>
                    <div
                        class="w-12 h-12 rounded-xl bg-gradient-to-br from-amber-500 to-amber-600 flex items-center justify-center shadow-md group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-exclamation-triangle text-white text-lg"></i>
                    </div>
                </div>
                <div class="pt-4 border-t border-gray-100">
                    <div class="flex items-center text-sm text-amber-600 font-medium">
                        <i class="fas fa-clock text-xs mr-1"></i>
                        <span>Reabastecer urgente</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Valor em Estoque -->
        <div
            class="group bg-white rounded-2xl p-5 border border-gray-200 shadow-sm hover:shadow-md transition-all duration-300 hover:border-purple-200 hover:scale-[1.00] relative overflow-hidden">
            <div
                class="absolute top-0 right-0 w-24 h-24 bg-gradient-to-br from-purple-100 to-transparent opacity-60 rounded-full -translate-y-8 translate-x-8">
            </div>
            <div class="relative z-10">
                <div class="flex items-start justify-between mb-4">
                    <div>
                        <div class="text-2xl md:text-3xl font-bold text-gray-800 mb-1">R$ 98.450</div>
                        <div class="text-gray-600 text-sm">Valor Total em Estoque</div>
                    </div>
                    <div
                        class="w-12 h-12 rounded-xl bg-gradient-to-br from-purple-500 to-purple-600 flex items-center justify-center shadow-md group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-dollar-sign text-white text-lg"></i>
                    </div>
                </div>
                <div class="pt-4 border-t border-gray-100">
                    <div class="flex items-center text-sm text-purple-600 font-medium">
                        <i class="fas fa-chart-line text-xs mr-1"></i>
                        <span>+8.5% vs mês anterior</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Grid de Conteúdo -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 md:gap-8">
        <!-- Movimentações Recentes -->
        <div class="lg:col-span-2 bg-white rounded-2xl border border-gray-200 p-6 shadow-sm">
            <div class="flex items-center justify-between mb-6">
                <div>
                    <h3 class="text-lg md:text-xl font-bold text-gray-800 flex items-center gap-3">
                        <div
                            class="w-10 h-10 rounded-lg bg-gradient-to-br from-blue-500 to-blue-600 flex items-center justify-center">
                            <i class="fas fa-exchange-alt text-white"></i>
                        </div>
                        Movimentações Recentes
                    </h3>
                    <p class="text-gray-500 text-sm mt-1">Últimas transações do estoque</p>
                </div>
                <a href="#"
                    class="text-blue-600 hover:text-blue-800 text-sm font-medium flex items-center gap-1 transition-colors">
                    Ver todas
                    <i class="fas fa-chevron-right text-xs"></i>
                </a>
            </div>

            <div class="space-y-4">
                <!-- Entrada -->
                <div
                    class="group flex items-center justify-between p-4 rounded-xl border border-gray-100 hover:border-emerald-200 hover:bg-emerald-50/50 transition-all duration-200 cursor-pointer">
                    <div class="flex items-center gap-4">
                        <div class="relative">
                            <div
                                class="w-12 h-12 rounded-xl bg-gradient-to-br from-emerald-100 to-emerald-50 flex items-center justify-center">
                                <i class="fas fa-arrow-down text-emerald-600 text-lg"></i>
                            </div>
                            <div
                                class="absolute -bottom-1 -right-1 w-5 h-5 rounded-full bg-emerald-500 flex items-center justify-center">
                                <i class="fas fa-plus text-white text-xs"></i>
                            </div>
                        </div>
                        <div>
                            <div class="font-semibold text-gray-800 group-hover:text-emerald-700">Entrada de Produto
                            </div>
                            <div class="text-sm text-gray-500 flex items-center gap-2 mt-1">
                                <span
                                    class="px-2 py-0.5 bg-emerald-100 text-emerald-700 rounded-full text-xs font-medium">Cimento
                                    CP-II</span>
                                <span>50 unidades • R$ 2.450,00</span>
                            </div>
                        </div>
                    </div>
                    <div class="text-right">
                        <div class="text-sm font-medium text-gray-800">Hoje, 10:15</div>
                        <div class="text-xs text-emerald-600 font-medium mt-1">+50 unidades</div>
                    </div>
                </div>

                <!-- Saída -->
                <div
                    class="group flex items-center justify-between p-4 rounded-xl border border-gray-100 hover:border-red-200 hover:bg-red-50/50 transition-all duration-200 cursor-pointer">
                    <div class="flex items-center gap-4">
                        <div class="relative">
                            <div
                                class="w-12 h-12 rounded-xl bg-gradient-to-br from-red-100 to-red-50 flex items-center justify-center">
                                <i class="fas fa-arrow-up text-red-600 text-lg"></i>
                            </div>
                            <div
                                class="absolute -bottom-1 -right-1 w-5 h-5 rounded-full bg-red-500 flex items-center justify-center">
                                <i class="fas fa-minus text-white text-xs"></i>
                            </div>
                        </div>
                        <div>
                            <div class="font-semibold text-gray-800 group-hover:text-red-700">Saída de Produto</div>
                            <div class="text-sm text-gray-500 flex items-center gap-2 mt-1">
                                <span class="px-2 py-0.5 bg-red-100 text-red-700 rounded-full text-xs font-medium">Areia
                                    Média</span>
                                <span>30 unidades • R$ 1.200,00</span>
                            </div>
                        </div>
                    </div>
                    <div class="text-right">
                        <div class="text-sm font-medium text-gray-800">Ontem, 17:40</div>
                        <div class="text-xs text-red-600 font-medium mt-1">-30 unidades</div>
                    </div>
                </div>

                <!-- Ajuste -->
                <div
                    class="group flex items-center justify-between p-4 rounded-xl border border-gray-100 hover:border-blue-200 hover:bg-blue-50/50 transition-all duration-200 cursor-pointer">
                    <div class="flex items-center gap-4">
                        <div class="relative">
                            <div
                                class="w-12 h-12 rounded-xl bg-gradient-to-br from-blue-100 to-blue-50 flex items-center justify-center">
                                <i class="fas fa-sync-alt text-blue-600 text-lg"></i>
                            </div>
                            <div
                                class="absolute -bottom-1 -right-1 w-5 h-5 rounded-full bg-blue-500 flex items-center justify-center">
                                <i class="fas fa-equals text-white text-xs"></i>
                            </div>
                        </div>
                        <div>
                            <div class="font-semibold text-gray-800 group-hover:text-blue-700">Ajuste de Estoque</div>
                            <div class="text-sm text-gray-500 flex items-center gap-2 mt-1">
                                <span
                                    class="px-2 py-0.5 bg-blue-100 text-blue-700 rounded-full text-xs font-medium">Tijolo
                                    8 furos</span>
                                <span>Inventário físico • +15 unidades</span>
                            </div>
                        </div>
                    </div>
                    <div class="text-right">
                        <div class="text-sm font-medium text-gray-800">22/12/2025</div>
                        <div class="text-xs text-blue-600 font-medium mt-1">Ajustado</div>
                    </div>
                </div>
            </div>

            <!-- Botão de ação -->
            <div class="mt-6 pt-6 border-t border-gray-100">
                <button
                    class="w-full py-3 border border-dashed border-gray-300 hover:border-blue-400 hover:bg-blue-50/30 rounded-xl text-gray-600 hover:text-blue-600 font-medium transition-all duration-200 flex items-center justify-center gap-2 group">
                    <i class="fas fa-plus-circle group-hover:scale-110 transition-transform"></i>
                    Adicionar Nova Movimentação
                </button>
            </div>
        </div>

        <!-- Quick Actions & Alertas -->
        <div class="space-y-6 md:space-y-8">
            <!-- Ações Rápidas -->
            <div class="bg-white rounded-2xl border border-gray-200 p-6 shadow-sm">
                <h4 class="text-lg font-bold text-gray-800 mb-4 flex items-center gap-2">
                    <i class="fas fa-bolt text-amber-500"></i>
                    Ações Rápidas
                </h4>
                <div class="grid grid-cols-2 gap-3">
                    <a href="#"
                        class="p-4 rounded-xl border border-gray-200 hover:border-blue-300 hover:bg-blue-50/50 transition-all duration-200 group text-center">
                        <div
                            class="w-10 h-10 rounded-lg bg-gradient-to-br from-blue-100 to-blue-50 flex items-center justify-center mx-auto mb-2 group-hover:scale-110 transition-transform">
                            <i class="fas fa-box text-blue-600"></i>
                        </div>
                        <div class="font-medium text-gray-800 text-sm">Novo Produto</div>
                    </a>
                    <a href="#"
                        class="p-4 rounded-xl border border-gray-200 hover:border-emerald-300 hover:bg-emerald-50/50 transition-all duration-200 group text-center">
                        <div
                            class="w-10 h-10 rounded-lg bg-gradient-to-br from-emerald-100 to-emerald-50 flex items-center justify-center mx-auto mb-2 group-hover:scale-110 transition-transform">
                            <i class="fas fa-tag text-emerald-600"></i>
                        </div>
                        <div class="font-medium text-gray-800 text-sm">Nova Categoria</div>
                    </a>
                    <a href="#"
                        class="p-4 rounded-xl border border-gray-200 hover:border-amber-300 hover:bg-amber-50/50 transition-all duration-200 group text-center">
                        <div
                            class="w-10 h-10 rounded-lg bg-gradient-to-br from-amber-100 to-amber-50 flex items-center justify-center mx-auto mb-2 group-hover:scale-110 transition-transform">
                            <i class="fas fa-file-export text-amber-600"></i>
                        </div>
                        <div class="font-medium text-gray-800 text-sm">Relatório</div>
                    </a>
                    <a href="#"
                        class="p-4 rounded-xl border border-gray-200 hover:border-purple-300 hover:bg-purple-50/50 transition-all duration-200 group text-center">
                        <div
                            class="w-10 h-10 rounded-lg bg-gradient-to-br from-purple-100 to-purple-50 flex items-center justify-center mx-auto mb-2 group-hover:scale-110 transition-transform">
                            <i class="fas fa-bell text-purple-600"></i>
                        </div>
                        <div class="font-medium text-gray-800 text-sm">Alertas</div>
                    </a>
                </div>
            </div>

            <!-- Alertas de Estoque Baixo -->
            <div class="bg-gradient-to-br from-amber-50 to-amber-25 border border-amber-200 rounded-2xl p-6 shadow-sm">
                <div class="flex items-start justify-between mb-4">
                    <div class="flex items-center gap-3">
                        <div
                            class="w-10 h-10 rounded-lg bg-gradient-to-br from-amber-500 to-amber-600 flex items-center justify-center">
                            <i class="fas fa-exclamation text-white"></i>
                        </div>
                        <div>
                            <h4 class="font-bold text-gray-800">Estoque Baixo</h4>
                            <p class="text-amber-700 text-sm">Produtos precisando de atenção</p>
                        </div>
                    </div>
                    <span class="px-3 py-1 bg-amber-500 text-white rounded-full text-xs font-bold">7</span>
                </div>

                <div class="space-y-3">
                    <div class="flex items-center justify-between p-3 bg-white/80 rounded-lg border border-amber-100">
                        <div class="font-medium text-gray-800 text-sm">Cimento CP-II</div>
                        <div class="text-amber-600 text-xs font-bold">8 unidades</div>
                    </div>
                    <div class="flex items-center justify-between p-3 bg-white/80 rounded-lg border border-amber-100">
                        <div class="font-medium text-gray-800 text-sm">Areia Fina</div>
                        <div class="text-amber-600 text-xs font-bold">15 unidades</div>
                    </div>
                    <div class="flex items-center justify-between p-3 bg-white/80 rounded-lg border border-amber-100">
                        <div class="font-medium text-gray-800 text-sm">Tinta Branca</div>
                        <div class="text-amber-600 text-xs font-bold">5 latas</div>
                    </div>
                </div>

                <button
                    class="w-full mt-4 py-2.5 bg-gradient-to-r from-amber-500 to-amber-600 hover:from-amber-600 hover:to-amber-700 text-white rounded-lg font-medium text-sm transition-all duration-200 shadow hover:shadow-md flex items-center justify-center gap-2">
                    <i class="fas fa-shopping-cart"></i>
                    Solicitar Compra
                </button>
            </div>
        </div>
    </div>
</div>


<script>
    window.stockDashboardConfig = {
        apiUrl: '<?= BASE_URL ?>/estoque',
        csrfToken: '<?= \App\Core\Security::generateCSRF() ?>'
    };
</script>

<script src="<?= BASE_URL ?>/assets/js/estoque/dashboard.js"></script>