<?php

namespace App\Modules\Estoque\Produtos\Models;

use App\Core\Orm;

class ProdutosModel extends Orm
{
    public function __construct()
    {
        parent::__construct();
        $this->tabela = 'produto';
        $this->chave_primaria = 'produto_id';
        $this->created_at_column = 'produto_criadoEm';
        $this->updated_at_column = 'produto_alteradoEm';

        $this->colunas = [
            'produto_id',
            'produto_descricao',
            'produto_quantidade',
            'produto_valor',
            'produto_categoria',
            'produto_infoAdcional',
            'produto_criadoEm',
            'produto_alteradoEm',
            'produto_aplicacao',
            'produto_estoqueAtual',
            'produto_ncm',
            'produto_valorVenda',
            'produto_csosn',
            'produto_margemLucro',
            'produto_unidade_medida'
        ];
    }

    public function getDashboardStats()
    {
        $total = $this->contar();

        // Use reflection to access the private static connection
        $reflection = new \ReflectionClass('App\Core\Orm');
        $property = $reflection->getProperty('conexaoORM');
        $property->setAccessible(true);
        $db = $property->getValue();

        $sqlCritico = "SELECT COUNT(*) as total FROM {$this->tabela} WHERE produto_estoqueAtual < 10";
        $stmtCritico = $db->prepare($sqlCritico);
        $stmtCritico->execute();
        $critico = $stmtCritico->fetch(\PDO::FETCH_ASSOC)['total'];

        $sqlNovos = "SELECT COUNT(*) as total FROM {$this->tabela} WHERE produto_criadoEm >= DATE_SUB(NOW(), INTERVAL 30 DAY)";
        $stmtNovos = $db->prepare($sqlNovos);
        $stmtNovos->execute();
        $novos = $stmtNovos->fetch(\PDO::FETCH_ASSOC)['total'];

        $sqlAlterados = "SELECT COUNT(*) as total FROM {$this->tabela} WHERE produto_alteradoEm >= DATE_SUB(NOW(), INTERVAL 30 DAY)";
        $stmtAlterados = $db->prepare($sqlAlterados);
        $stmtAlterados->execute();
        $alterados = $stmtAlterados->fetch(\PDO::FETCH_ASSOC)['total'];

        return [
            'total_produtos' => $total,
            'produtos_novos' => $novos,
            'produtos_alterados' => $alterados,
            'estoque_critico' => $critico
        ];
    }
}
