<div id="toast" class="fixed top-5 right-5 bg-green-500 text-white py-2 px-4 rounded-lg shadow-md z-50"
    style="display: none; transition: opacity 0.5s ease;"></div>

<div class="h-screen bg-gradient-to-br from-gray-50 to-gray-100 p-4 md:p-6">
    <div class="mx-auto container p-4 w-full">
        <!-- Header -->
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-8 gap-4">
            <div class="flex items-center gap-3">
                <div class="p-3 bg-gradient-to-r from-blue-500 to-cyan-400 rounded-xl shadow-md">
                    <i class="fas fa-box text-white text-lg"></i>
                </div>
                <div class="min-w-0">
                    <h1 class="text-2xl sm:text-3xl font-bold text-gray-800 truncate"><?= e($title) ?></h1>
                    <p class="text-gray-600 text-sm mt-1 truncate">Gerenciar informações do produto</p>
                </div>
            </div>

            <a href="<?= BASE_URL ?>/estoque/produtos"
                class="flex items-center gap-2 px-4 py-2.5 bg-gray-500 text-white rounded-md hover:bg-gray-600  font-medium transition-all border border-grey-200 hover:border-grey-300 shadow-sm hover:shadow whitespace-nowrap">
                <i class="fas fa-arrow-left text-sm"></i>
                Voltar para a Lista
            </a>
        </div>

        <!-- Form Container -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-200 overflow-hidden">
            <!-- Form Header -->
            <div class="px-6 py-4 border-b border-gray-100 bg-blue-50">
                <div class="flex items-center justify-between">
                    <h2 class="text-lg font-semibold text-gray-800 truncate">
                        <i class="fas fa-edit mr-2"></i>
                        Dados do Produto
                    </h2>
                </div>
            </div>

            <!-- Form -->
            <form id="produto-form" class="p-4 sm:p-6">
                <!-- Hidden fields -->
                <input type="hidden" name="produto_id" id="produto_id" value="<?= e($produto->produto_id ?? '') ?>">
                <input type="hidden" id="current_categoria_id" value="<?= e($produto->produto_categoria ?? '') ?>">
                <input type="hidden" id="current_unidade_id" value="<?= e($produto->produto_unidade_medida ?? '') ?>">

                <div class="space-y-6 sm:space-y-8">
                    
                    <!-- Informações Básicas -->
                    <div>
                        <div class="mt-2 mb-4">
                             <h3 class="text-sm font-semibold text-gray-700 uppercase tracking-wider mb-4 flex items-center">
                                <i class="fas fa-info-circle mr-2 flex-shrink-0"></i>
                                <span class="truncate">Informações Básicas</span>
                            </h3>
                            <div class="border-b border-gray-200 mt-2"></div>
                        </div>

                        <!-- Row 1: Descricao (4/5) + Aplicacao (1/5) -->
                        <div class="grid grid-cols-1 md:grid-cols-5 gap-4 sm:gap-6">
                            <div class="md:col-span-4">
                                <label for="produto_descricao" class="block text-xs font-medium text-gray-700 uppercase tracking-wider mb-1">
                                    Descrição <span class="text-red-500">*</span>
                                </label>
                                <input type="text" id="produto_descricao" name="produto_descricao" required
                                    class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                                    value="<?= e($produto->produto_descricao ?? '') ?>">
                            </div>
                            <div class="md:col-span-1">
                                <label for="produto_aplicacao" class="block text-xs font-medium text-gray-700 uppercase tracking-wider mb-1">
                                    Aplicação
                                </label>
                                <input type="text" id="produto_aplicacao" name="produto_aplicacao"
                                    class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                                    value="<?= e($produto->produto_aplicacao ?? '') ?>">
                            </div>
                        </div>
                        
                         <!-- Categoria & Unidade (Searchable) - Row 2 -->
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 sm:gap-6 mt-4">
                             <!-- Categoria -->
                             <div class="w-full relative group">
                                <label for="produto_categoria_search" class="block text-xs font-medium text-gray-700 uppercase tracking-wider mb-1">
                                    Categoria <span class="text-red-500">*</span>
                                </label>
                                <input type="text" id="produto_categoria_search" placeholder="Pesquisar categoria..."
                                    class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" autocomplete="off">
                                <input type="hidden" name="produto_categoria" id="produto_categoria">
                                <div id="categoria-dropdown" class="absolute z-10 w-full bg-white border border-gray-200 rounded-lg shadow-lg mt-1 max-h-48 overflow-y-auto hidden">
                                </div>
                            </div>
                            
                            <!-- Unidade -->
                             <div class="w-full relative group">
                                <label for="produto_unidade_search" class="block text-xs font-medium text-gray-700 uppercase tracking-wider mb-1">
                                    Unidade de Medida <span class="text-red-500">*</span>
                                </label>
                                <input type="text" id="produto_unidade_search" placeholder="Pesquisar unidade..."
                                    class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" autocomplete="off">
                                <input type="hidden" name="produto_unidade_medida" id="produto_unidade_medida">
                                <div id="unidade-dropdown" class="absolute z-10 w-full bg-white border border-gray-200 rounded-lg shadow-lg mt-1 max-h-48 overflow-y-auto hidden">
                                </div>
                            </div>
                        </div>
                    </div>


                    <!-- Fiscal -->
                    <div>
                         <div class="mt-6 mb-4">
                             <h3 class="text-sm font-semibold text-gray-700 uppercase tracking-wider mb-4 flex items-center">
                                <i class="fas fa-file-invoice mr-2 flex-shrink-0"></i>
                                <span class="truncate">Fiscal</span>
                            </h3>
                            <div class="border-b border-gray-200 mt-2"></div>
                        </div>

                         <div class="grid grid-cols-1 sm:grid-cols-4 gap-4 sm:gap-6">
                            <!-- NCM -->
                            <div class="sm:col-span-1">
                                <label for="produto_ncm" class="block text-xs font-medium text-gray-700 uppercase tracking-wider mb-1">
                                    NCM
                                </label>
                                <input type="text" id="produto_ncm" name="produto_ncm"
                                    class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                                    value="<?= e($produto->produto_ncm ?? '') ?>">
                            </div>

                            <!-- CSOSN -->
                            <div class="sm:col-span-1">
                                <label for="produto_csosn" class="block text-xs font-medium text-gray-700 uppercase tracking-wider mb-1">
                                    CSOSN
                                </label>
                                <input type="text" id="produto_csosn" name="produto_csosn"
                                    class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                                    value="<?= e($produto->produto_csosn ?? '') ?>">
                            </div>
                        </div>
                    </div>

                    <!-- Valores e Estoque -->
                    <div>
                        <div class="mt-6 mb-4">
                             <h3 class="text-sm font-semibold text-gray-700 uppercase tracking-wider mb-4 flex items-center">
                                <i class="fas fa-dollar-sign mr-2 flex-shrink-0"></i>
                                <span class="truncate">Valores e Estoque</span>
                            </h3>
                            <div class="border-b border-gray-200 mt-2"></div>
                        </div>

                        <div class="grid grid-cols-1 sm:grid-cols-4 gap-4 sm:gap-6">
                            <!-- Valor Custo/Compra -->
                            <div>
                                <label for="produto_valor" class="block text-xs font-medium text-gray-700 uppercase tracking-wider mb-1">
                                    Valor Custo
                                </label>
                                <input type="number" step="0.01" id="produto_valor" name="produto_valor"
                                    class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                                    value="<?= e($produto->produto_valor ?? '') ?>">
                            </div>

                            <!-- Margem Lucro -->
                            <div>
                                <label for="produto_margemLucro" class="block text-xs font-medium text-gray-700 uppercase tracking-wider mb-1">
                                    Margem (%)
                                </label>
                                <input type="number" step="0.01" id="produto_margemLucro" name="produto_margemLucro"
                                    class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                                    value="<?= e($produto->produto_margemLucro ?? '') ?>">
                            </div>
                            
                            <!-- Valor Venda -->
                            <div>
                                <label for="produto_valorVenda" class="block text-xs font-medium text-gray-700 uppercase tracking-wider mb-1">
                                    Valor Venda
                                </label>
                                <input type="number" step="0.01" id="produto_valorVenda" name="produto_valorVenda"
                                    class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                                    value="<?= e($produto->produto_valorVenda ?? '') ?>">
                            </div>

                             <!-- Estoque Atual -->
                             <div>
                                <label for="produto_estoqueAtual" class="block text-xs font-medium text-gray-700 uppercase tracking-wider mb-1">
                                    Estoque Atual
                                </label>
                                <input type="number" step="0.01" id="produto_estoqueAtual" name="produto_estoqueAtual"
                                    class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                                    value="<?= e($produto->produto_estoqueAtual ?? '') ?>">
                            </div>
                        </div>

                         <div class="grid grid-cols-1 sm:grid-cols-4 gap-4 sm:gap-6 mt-4">
                             <!-- Qtd. Embalagem -->
                             <div class="sm:col-span-1">
                                <label for="produto_quantidade" class="block text-xs font-medium text-gray-700 uppercase tracking-wider mb-1">
                                    Qtd. Embalagem
                                </label>
                                <input type="text" id="produto_quantidade" name="produto_quantidade"
                                    class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                                    value="<?= e($produto->produto_quantidade ?? '') ?>">
                            </div>

                            <div class="sm:col-span-3">
                                <label for="produto_infoAdcional" class="block text-xs font-medium text-gray-700 uppercase tracking-wider mb-1">
                                    Informações Adicionais
                                </label>
                                <textarea id="produto_infoAdcional" name="produto_infoAdcional" rows="1"
                                    class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"><?= e($produto->produto_infoAdcional ?? '') ?></textarea>
                            </div>
                        </div>
                    </div>

                </div>

                <!-- Form Actions -->
                <div class="flex flex-col sm:flex-row justify-between items-center gap-4 mt-8 sm:mt-8 pt-6 border-t border-gray-200">
                    <div class="text-sm text-gray-500 w-full sm:w-auto text-center sm:text-left">
                        <p class="flex items-center justify-center sm:justify-start gap-2 flex-wrap">
                            <i class="fas fa-info-circle flex-shrink-0"></i>
                            <span>Campos marcados com <span class="text-red-500">*</span>, são obrigatórios.</span>
                        </p>
                    </div>

                    <div class="flex flex-col sm:flex-row gap-3 w-full sm:w-auto mt-4">
                        <button type="submit" id="submit-btn"
                            class="flex items-center justify-center gap-2 px-4 sm:px-5 py-2.5 bg-gradient-to-r from-blue-600 to-indigo-600 text-white rounded-xl font-medium hover:shadow-lg hover:from-blue-700 hover:to-indigo-700 transition-all shadow-md hover:scale-[1.00] whitespace-nowrap order-1 sm:order-2">
                            <i class="fas fa-save"></i>
                            <span id="submit-text">Salvar Produto</span>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<script type="module" src="<?= BASE_URL ?>/assets/js/estoque/produtos/produtoWrapper.js"></script>
