<div id="toast" class="fixed top-5 right-5 bg-green-500 text-white py-2 px-4 rounded-lg shadow-md z-50"
    style="display: none; transition: opacity 0.5s ease;"></div>

<div class="container mx-auto p-4">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold"><?= e($title) ?></h1>
        <a href="<?= BASE_URL ?>/estoque/produtos/form"
            class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 shadow-sm">Novo Produto</a>
    </div>

    <!-- Stats Section -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
        <!-- Total -->
        <div class="bg-white p-6 rounded-xl shadow-md border-l-4 border-blue-500 hover:shadow-lg transition-shadow">
            <div class="flex items-center">
                <div class="p-3 bg-blue-100 rounded-full">
                    <i class="fa-solid fa-box-open text-blue-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500 uppercase tracking-wider">Total</p>
                    <p class="text-2xl font-bold text-gray-800"><?= e($stats['total_produtos'] ?? 0) ?></p>
                </div>
            </div>
        </div>

        <!-- Novos -->
        <div class="bg-white p-6 rounded-xl shadow-md border-l-4 border-emerald-500 hover:shadow-lg transition-shadow">
            <div class="flex items-center">
                <div class="p-3 bg-emerald-100 rounded-full">
                    <i class="fa-solid fa-plus text-emerald-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500 uppercase tracking-wider">Novos</p>
                    <p class="text-2xl font-bold text-gray-800"><?= e($stats['produtos_novos'] ?? 0) ?></p>
                </div>
            </div>
        </div>

        <!-- Alterados -->
        <div class="bg-white p-6 rounded-xl shadow-md border-l-4 border-orange-500 hover:shadow-lg transition-shadow">
            <div class="flex items-center">
                <div class="p-3 bg-orange-100 rounded-full">
                    <i class="fa-solid fa-pen-to-square text-orange-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500 uppercase tracking-wider">Alterados</p>
                    <p class="text-2xl font-bold text-gray-800"><?= e($stats['produtos_alterados'] ?? 0) ?></p>
                </div>
            </div>
        </div>

        <!-- Crítico -->
        <div class="bg-white p-6 rounded-xl shadow-md border-l-4 border-red-500 hover:shadow-lg transition-shadow">
            <div class="flex items-center">
                <div class="p-3 bg-red-100 rounded-full">
                    <i class="fa-solid fa-triangle-exclamation text-red-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500 uppercase tracking-wider">Estoque Crítico</p>
                    <p class="text-2xl font-bold text-gray-800"><?= e($stats['estoque_critico'] ?? 0) ?></p>
                </div>
            </div>
        </div>
    </div>
    <!-- End Stats Section -->

    <div class="bg-white p-6 rounded-lg shadow-md">
        <h2 class="text-xl font-bold mb-4">Lista de Produtos</h2>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Descrição</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Estoque</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Venda</th>
                        <!-- <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Categoria</th> -->
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Ações</th>
                    </tr>
                </thead>
                <tbody id="produto-list">
                    <tr>
                        <td colspan="5" class="text-center py-6 text-gray-400">
                            Carregando produtos...
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <!-- Pagination Controls -->
        <div id="pagination-controls" class="mt-4 flex justify-center items-center space-x-2">
            <!-- Os botões da paginação serão inseridos aqui pelo JavaScript -->
        </div>
    </div>
</div>
<script type="module" src="<?= BASE_URL ?>/assets/js/estoque/produtos/produtoWrapper.js"></script>
