<?php

namespace App\Modules\Financeiro\ContasPagar\Models;

use App\Core\Orm;

class ContaPagarModel extends Orm
{
    public function __construct()
    {
        parent::__construct();
        $this->tabela = "conta_pagar";
        $this->chave_primaria = "conta_pagar_id";
        $this->order_by = "conta_pagar_vencimento DESC";

        $this->created_at_column = 'conta_pagar_criadoEm';
        $this->updated_at_column = 'conta_pagar_atualizadoEm';

        $this->join = [
            [
                'tabela' => 'plano_conta',
                'fk' => 'conta_pagar_plano_contas',
                'pk' => 'plano_conta_id'
            ],
            [
                'tabela' => 'fornecedor',
                'fk' => 'conta_pagar_fornecedor',
                'pk' => 'fornecedor_id'
            ]
        ];

        $this->colunas = [
            'conta_pagar.conta_pagar_id',
            'conta_pagar.conta_pagar_valor',
            'conta_pagar.conta_pagar_vencimento',
            'conta_pagar.conta_pagar_plano_contas',
            'conta_pagar.conta_pagar_descricao',
            'conta_pagar.conta_pagar_status',
            'conta_pagar.conta_pagar_data_pagamento',
            'conta_pagar.conta_pagar_fornecedor',
            'conta_pagar.conta_pagar_criadoEm',
            'conta_pagar.conta_pagar_atualizadoEm',
            'plano_conta.plano_conta_descricao',
            'fornecedor.fornecedor_nome'
        ];
    }

    /**
     * Atalho estático para iniciar uma consulta fluida
     * @return self
     */
    public static function query()
    {
        return new self();
    }
}
