<div id="toast" class="fixed top-5 right-5 bg-green-500 text-white py-2 px-4 rounded-lg shadow-md z-50"
    style="display: none; transition: opacity 0.5s ease;"></div>

<div class="h-screen bg-gradient-to-br from-gray-50 to-gray-100 p-4 md:p-6">
    <div class="mx-auto container p-4 w-full">
        <!-- Header -->
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-8 gap-4">
            <div class="flex items-center gap-3">
                <div class="p-3 bg-gradient-to-r from-blue-500 to-cyan-400 rounded-xl shadow-md">
                    <i class="fas fa-file-invoice-dollar text-white text-lg"></i>
                </div>
                <div class="min-w-0">
                    <h1 class="text-2xl sm:text-3xl font-bold text-gray-800 truncate"><?= e($title) ?></h1>
                    <p class="text-gray-600 text-sm mt-1 truncate">Adicione as informações da conta a pagar</p>
                </div>
            </div>

            <a href="<?= BASE_URL ?>/financeiro/contasPagar"
                class="flex items-center gap-2 px-4 py-2.5 bg-gray-500 text-white rounded-md hover:bg-gray-600  font-medium transition-all border border-grey-200 hover:border-grey-300 shadow-sm hover:shadow whitespace-nowrap">
                <i class="fas fa-arrow-left text-sm"></i>
                Voltar para a Lista
            </a>
        </div>

        <!-- Form Container -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-200 overflow-hidden">
            <form id="contas-pagar-form" class="p-4 sm:p-6">
                <input type="hidden" name="conta_pagar_id" id="conta_pagar_id" value="<?= e($data->conta_pagar_id ?? '') ?>">

                <div class="space-y-6 sm:space-y-8">
                    <div>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 sm:gap-6">
                            <!-- Descrição -->
                            <div class="w-full md:col-span-3">
                                <label for="conta_pagar_descricao" class="text-xs font-medium text-gray-700 uppercase tracking-wider">Descrição <span class="text-red-500 ml-1">*</span></label>
                                <input type="text" id="conta_pagar_descricao" name="conta_pagar_descricao" required placeholder="Descrição da conta" class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500" value="<?= e($data->conta_pagar_descricao ?? '') ?>">
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 sm:gap-6">
                            <!-- Valor -->
                            <div class="w-full">
                                <label for="conta_pagar_valor" class="text-xs font-medium text-gray-700 uppercase tracking-wider">Valor <span class="text-red-500 ml-1">*</span></label>
                                <input type="text" id="conta_pagar_valor" name="conta_pagar_valor" required placeholder="R$ 0,00" data-mask="money" class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500" value="<?= e($data->conta_pagar_valor ?? '') ?>">
                            </div>
                            <!-- Vencimento -->
                            <div class="w-full">
                                <label for="conta_pagar_vencimento" class="text-xs font-medium text-gray-700 uppercase tracking-wider">Vencimento <span class="text-red-500 ml-1">*</span></label>
                                <input type="date" id="conta_pagar_vencimento" name="conta_pagar_vencimento" required class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500" value="<?= e($data->conta_pagar_vencimento ?? '') ?>">
                            </div>
                             <!-- Data Pagamento -->
                             <div class="w-full">
                                <label for="conta_pagar_data_pagamento" class="text-xs font-medium text-gray-700 uppercase tracking-wider">Data Pagamento</label>
                                <input type="date" id="conta_pagar_data_pagamento" name="conta_pagar_data_pagamento" class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500" value="<?= e($data->conta_pagar_data_pagamento ?? '') ?>">
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 sm:gap-6">
                            <!-- Plano de Contas -->
                            <div class="w-full">
                                <label for="conta_pagar_plano_contas" class="text-xs font-medium text-gray-700 uppercase tracking-wider">Plano de Contas <span class="text-red-500 ml-1">*</span></label>
                                <select id="conta_pagar_plano_contas" name="conta_pagar_plano_contas" required class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500">
                                    <option value="">Selecione</option>
                                    <?php foreach ($planos_de_contas as $plano) : ?>
                                        <option value="<?= e($plano->plano_conta_id) ?>" <?= (isset($data->conta_pagar_plano_contas) && $data->conta_pagar_plano_contas == $plano->plano_conta_id) ? 'selected' : '' ?>>
                                            <?= e($plano->plano_conta_descricao) ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <!-- Fornecedor -->
                            <div class="w-full">
                                <label for="conta_pagar_fornecedor" class="text-xs font-medium text-gray-700 uppercase tracking-wider">Fornecedor</label>
                                <select id="conta_pagar_fornecedor" name="conta_pagar_fornecedor" class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500">
                                    <option value="">Selecione</option>
                                    <?php foreach ($fornecedores as $fornecedor) : ?>
                                        <option value="<?= e($fornecedor->fornecedor_id) ?>" <?= (isset($data->conta_pagar_fornecedor) && $data->conta_pagar_fornecedor == $fornecedor->fornecedor_id) ? 'selected' : '' ?>>
                                            <?= e($fornecedor->fornecedor_nome) ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <!-- Status -->
                            <div class="w-full">
                                <label for="conta_pagar_status" class="text-xs font-medium text-gray-700 uppercase tracking-wider">Status</label>
                                <select id="conta_pagar_status" name="conta_pagar_status" class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500">
                                    <option value="pendente" <?= (isset($data->conta_pagar_status) && $data->conta_pagar_status == 'pendente') ? 'selected' : '' ?>>Pendente</option>
                                    <option value="pago" <?= (isset($data->conta_pagar_status) && $data->conta_pagar_status == 'pago') ? 'selected' : '' ?>>Pago</option>
                                    <option value="atrasado" <?= (isset($data->conta_pagar_status) && $data->conta_pagar_status == 'atrasado') ? 'selected' : '' ?>>Atrasado</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Form Actions -->
                <div class="flex flex-col sm:flex-row justify-between items-center gap-4 mt-8 sm:mt-8 pt-6 border-t border-gray-200">
                    <div class="text-sm text-gray-500 w-full sm:w-auto text-center sm:text-left">
                        <p class="flex items-center justify-center sm:justify-start gap-2 flex-wrap">
                            <i class="fas fa-info-circle flex-shrink-0"></i>
                            <span>Campos marcados com <span class="text-red-500">*</span>, são obrigatórios.</span>
                        </p>
                    </div>

                    <div class="flex flex-col sm:flex-row gap-3 w-full sm:w-auto mt-4">
                        <button type="submit" id="submit-btn" class="flex items-center justify-center gap-2 px-4 sm:px-5 py-2.5 bg-gradient-to-r from-blue-600 to-indigo-600 text-white rounded-xl font-medium hover:shadow-lg hover:from-blue-700 hover:to-indigo-700 transition-all shadow-md hover:scale-[1.00] whitespace-nowrap order-1 sm:order-2">
                            <i class="fas fa-save"></i>
                            <span id="submit-text">Salvar</span>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<script type="module" src="<?= BASE_URL ?>/assets/js/contasPagar/contasPagarWrapper.js"></script>
