<?php

namespace App\Modules\Financeiro\ContasReceber\Models;

use App\Core\Orm;

class ContaReceberModel extends Orm
{
    public function __construct()
    {
        parent::__construct();
        $this->tabela = "conta_receber";
        $this->chave_primaria = "conta_receber_id";
        $this->order_by = "conta_receber_vencimento DESC";

        $this->created_at_column = 'conta_receber_criadoEm';
        $this->updated_at_column = 'conta_receber_atualizadoEm';

        $this->colunas = [
            'conta_receber_id',
            'conta_receber_valor',
            'conta_receber_vencimento',
            'conta_receber_plano_contas',
            'conta_receber_descricao',
            'conta_receber_status',
            'conta_receber_data_pagamento',
            'conta_receber_cliente',
            'conta_receber_criadoEm',
            'conta_receber_atualizadoEm'
        ];
    }

    /**
     * Atalho estático para iniciar uma consulta fluida
     * @return self
     */
    public static function query()
    {
        return new self();
    }
}
