<?php

namespace App\Modules\Financeiro\Planodecontas\Models;

use App\Core\Orm;

class PlanodecontasModel extends Orm
{
    public function __construct()
    {
        parent::__construct();
        $this->tabela = "plano_conta";
        $this->chave_primaria = "plano_conta_id";
        $this->order_by = "plano_conta_id DESC";

        // Configuração dos Timestamps automáticos do ORM
        $this->created_at_column = 'plano_conta_criadoEm';
        $this->updated_at_column = 'plano_conta_alteradoEm';

        $this->colunas = [
            'plano_conta_id as id',
            'plano_conta_nome as name',
            'plano_conta_status as status',
            'plano_conta_criadoEm as created_at',
            'plano_conta_alteradoEm as updated_at'
        ];
    }

    /**
     * Atalho estático para iniciar uma consulta fluida
     * @return self
     */
    public static function query()
    {
        return new self();
    }

    public function getDashboardStats()
    {
        $stats = [];

        // Total de Planos de Contas
        $stats['total_plano_de_contas'] = (new self())->contar();


        // Total de Planos de Contas Ativos
        $stats['total_plano_de_contas_ativos'] = (new self())
            ->and('plano_conta_status', 'Ativo')
            ->contar();


        // Total de Planos de Contas Inativos
        $stats['total_plano_de_contas_inativos'] = (new self())
            ->and('plano_conta_status', 'Inativo')
            ->contar();

        return $stats;
    }
}