<div id="toast" class="fixed top-5 right-5 bg-green-500 text-white py-2 px-4 rounded-lg shadow-md z-50"
    style="display: none; transition: opacity 0.5s ease;"></div>

<div class="container mx-auto p-4">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold"><?= e($title) ?></h1>
        <a href="<?= BASE_URL ?>/financeiro/planodecontas/form"
            class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 shadow-sm">Novo Plano de Conta</a>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">

        <!-- TOTAL DE CONTAS -->
        <div class="bg-white p-6 rounded-xl shadow-md border-l-4 border-blue-500 hover:shadow-lg transition-shadow">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-semibold text-gray-500 uppercase tracking-wide">Total de Contas</p>
                    <p class="text-3xl font-bold text-gray-900 mt-2" id="total-contas">
                        <?= e($stats['total_contas'] ?? 0) ?>
                    </p>
                    <span class="text-xs text-gray-500">Plano de contas cadastrado</span>
                </div>
                <div class="p-3 bg-blue-50 rounded-full">
                    <i class="fa-solid fa-list text-blue-600 text-xl"></i>
                </div>
            </div>
        </div>

        <!-- RECEITAS -->
        <div class="bg-white p-6 rounded-xl shadow-md border-l-4 border-green-500 hover:shadow-lg transition-shadow">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-semibold text-gray-500 uppercase tracking-wide">Receitas</p>
                    <p class="text-3xl font-bold text-green-600 mt-2" id="total-receitas">
                        <?= e($stats['total_receitas'] ?? 0) ?>
                    </p>
                    <span class="text-xs text-green-500">
                        Contas de entrada
                    </span>
                </div>
                <div class="p-3 bg-green-50 rounded-full">
                    <i class="fa-solid fa-arrow-trend-up text-green-600 text-xl"></i>
                </div>
            </div>
        </div>

        <!-- DESPESAS -->
        <div class="bg-white p-6 rounded-xl shadow-md border-l-4 border-red-500 hover:shadow-lg transition-shadow">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-semibold text-gray-500 uppercase tracking-wide">Despesas</p>
                    <p class="text-3xl font-bold text-red-600 mt-2" id="total-despesas">
                        <?= e($stats['total_despesas'] ?? 0) ?>
                    </p>
                    <span class="text-xs text-gray-500">
                        Contas de saída
                    </span>
                </div>
                <div class="p-3 bg-red-50 rounded-full">
                    <i class="fa-solid fa-arrow-trend-down text-red-600 text-xl"></i>
                </div>
            </div>
        </div>

        <!-- TIPOS DE CONTA -->
        <div class="bg-gradient-to-br from-blue-50 to-indigo-50 p-6 rounded-xl shadow-sm border border-blue-100">
            <p class="text-sm font-semibold text-blue-700 uppercase tracking-wide mb-4">
                Tipos de Conta
            </p>
            <div class="grid grid-cols-2 gap-4">
                <!-- ATIVO -->
                <div class="flex items-center gap-3 px-4 py-2 rounded-full bg-blue-100 text-blue-700 font-semibold text-sm">
                    <div class="w-8 h-8 flex items-center justify-center rounded-full bg-blue-600 text-white text-xs font-bold">
                        A
                    </div>
                    Ativo
                </div>
                <!-- PASSIVO -->
                <div class="flex items-center gap-3 px-4 py-2 rounded-full bg-orange-100 text-orange-700 font-semibold text-sm">
                    <div class="w-8 h-8 flex items-center justify-center rounded-full bg-orange-600 text-white text-xs font-bold">
                        P
                    </div>
                    Passivo
                </div>
                <!-- RECEITA -->
                <div class="flex items-center gap-3 px-4 py-2 rounded-full bg-green-100 text-green-700 font-semibold text-sm">
                    <div class="w-8 h-8 flex items-center justify-center rounded-full bg-green-600 text-white text-xs font-bold">
                        R
                    </div>
                    Receita
                </div>
                <!-- DESPESA -->
                <div class="flex items-center gap-3 px-4 py-2 rounded-full bg-red-100 text-red-700 font-semibold text-sm">
                    <div class="w-8 h-8 flex items-center justify-center rounded-full bg-red-600 text-white text-xs font-bold">
                        D
                    </div>
                    Despesa
                </div>
                <!-- PATRIMÔNIO LÍQUIDO (ocupa 2 colunas e NÃO quebra texto) -->
                <div
                    class="col-span-2 flex items-center justify-center gap-3 px-4 py-2 rounded-full bg-purple-100 text-purple-700 font-semibold text-sm whitespace-nowrap">
                    <div class="w-8 h-8 flex items-center justify-center rounded-full bg-purple-600 text-white text-xs font-bold">
                        PL
                    </div>
                    Patrimônio Líquido
                </div>
            </div>
        </div>
    </div>

    <div class="bg-white p-6 rounded-lg shadow-md">
        <h2 class="text-xl font-bold mb-4">Lista de Planos de Contas</h2>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nome
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Status</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Ações</th>
                    </tr>
                </thead>
                <tbody id="plano-de-contas-list" class="bg-white divide-y divide-gray-200">

                </tbody>
            </table>
        </div>

        <div id="pagination-controls" class="mt-4 flex justify-center items-center space-x-2">

        </div>
    </div>
</div>
<script type="module" src="<?= BASE_URL ?>/assets/js/planodecontas/planodecontasWrapper.js"></script>