<!-- Main Content -->
<div class="mb-8 md:mb-12">
    <!-- Header -->
    <div class="mb-8 md:mb-10">
        <div class="flex flex-col sm:flex-row sm:items-center justify-between gap-4">
            <div class="flex-1 min-w-0">
                <div class="flex items-center gap-3 mb-2">
                    <div
                        class="w-10 h-10 md:w-12 md:h-12 rounded-xl bg-gradient-to-br from-green-500 to-green-600 flex items-center justify-center shadow-md">
                        <i class="fas fa-dollar-sign text-white text-lg md:text-xl"></i>
                    </div>
                    <h1 class="text-2xl sm:text-3xl lg:text-4xl font-bold text-gray-800">
                        Módulo Financeiro
                    </h1>
                </div>
                <p class="text-gray-600 text-sm md:text-base max-w-2xl">
                    Visão geral das suas finanças, contas a pagar e a receber.
                </p>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="grid grid-cols-1 xs:grid-cols-2 lg:grid-cols-4 gap-5 md:gap-6 mb-8 md:mb-10">
        <!-- Contas a Pagar -->
        <div
            class="group bg-white rounded-2xl p-5 border border-gray-200 shadow-sm hover:shadow-md transition-all duration-300 hover:border-red-200 hover:scale-[1.00] relative overflow-hidden">
            <div
                class="absolute top-0 right-0 w-24 h-24 bg-gradient-to-br from-red-100 to-transparent opacity-60 rounded-full -translate-y-8 translate-x-8">
            </div>
            <div class="relative z-10">
                <div class="flex items-start justify-between mb-4">
                    <div>
                        <div class="text-2xl md:text-3xl font-bold text-gray-800 mb-1">R$ 1.250,00</div>
                        <div class="text-gray-600 text-sm">Contas a Pagar (Mês)</div>
                    </div>
                    <div
                        class="w-12 h-12 rounded-xl bg-gradient-to-br from-red-500 to-red-600 flex items-center justify-center shadow-md group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-arrow-down text-white text-lg"></i>
                    </div>
                </div>
                <div class="pt-4 border-t border-gray-100">
                    <div class="flex items-center text-sm text-red-600 font-medium">
                        <i class="fas fa-exclamation-triangle text-xs mr-1"></i>
                        <span>3 contas vencem hoje</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Contas a Receber -->
        <div
            class="group bg-white rounded-2xl p-5 border border-gray-200 shadow-sm hover:shadow-md transition-all duration-300 hover:border-green-200 hover:scale-[1.00] relative overflow-hidden">
            <div
                class="absolute top-0 right-0 w-24 h-24 bg-gradient-to-br from-green-100 to-transparent opacity-60 rounded-full -translate-y-8 translate-x-8">
            </div>
            <div class="relative z-10">
                <div class="flex items-start justify-between mb-4">
                    <div>
                        <div class="text-2xl md:text-3xl font-bold text-gray-800 mb-1">R$ 3.800,00</div>
                        <div class="text-gray-600 text-sm">Contas a Receber (Mês)</div>
                    </div>
                    <div
                        class="w-12 h-12 rounded-xl bg-gradient-to-br from-green-500 to-green-600 flex items-center justify-center shadow-md group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-arrow-up text-white text-lg"></i>
                    </div>
                </div>
                <div class="pt-4 border-t border-gray-100">
                    <div class="flex items-center text-sm text-green-600 font-medium">
                        <i class="fas fa-check-circle text-xs mr-1"></i>
                        <span>5 recebimentos hoje</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Balanço Mensal -->
        <div
            class="group bg-white rounded-2xl p-5 border border-gray-200 shadow-sm hover:shadow-md transition-all duration-300 hover:border-blue-200 hover:scale-[1.00] relative overflow-hidden">
            <div
                class="absolute top-0 right-0 w-24 h-24 bg-gradient-to-br from-blue-100 to-transparent opacity-60 rounded-full -translate-y-8 translate-x-8">
            </div>
            <div class="relative z-10">
                <div class="flex items-start justify-between mb-4">
                    <div>
                        <div class="text-2xl md:text-3xl font-bold text-blue-600 mb-1">R$ 2.550,00</div>
                        <div class="text-gray-600 text-sm">Balanço do Mês</div>
                    </div>
                    <div
                        class="w-12 h-12 rounded-xl bg-gradient-to-br from-blue-500 to-blue-600 flex items-center justify-center shadow-md group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-balance-scale text-white text-lg"></i>
                    </div>
                </div>
                <div class="pt-4 border-t border-gray-100">
                    <div class="flex items-center text-sm text-blue-600 font-medium">
                        <i class="fas fa-chart-line text-xs mr-1"></i>
                        <span>Positivo</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Plano de Contas -->
        <div
            class="group bg-white rounded-2xl p-5 border border-gray-200 shadow-sm hover:shadow-md transition-all duration-300 hover:border-purple-200 hover:scale-[1.00] relative overflow-hidden">
            <div
                class="absolute top-0 right-0 w-24 h-24 bg-gradient-to-br from-purple-100 to-transparent opacity-60 rounded-full -translate-y-8 translate-x-8">
            </div>
            <div class="relative z-10">
                <div class="flex items-start justify-between mb-4">
                    <div>
                        <div class="text-2xl md:text-3xl font-bold text-gray-800 mb-1">42</div>
                        <div class="text-gray-600 text-sm">Planos de Contas</div>
                    </div>
                    <div
                        class="w-12 h-12 rounded-xl bg-gradient-to-br from-purple-500 to-purple-600 flex items-center justify-center shadow-md group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-book text-white text-lg"></i>
                    </div>
                </div>
                <div class="pt-4 border-t border-gray-100">
                    <div class="flex items-center text-sm text-purple-600 font-medium">
                        <i class="fas fa-stream text-xs mr-1"></i>
                        <span>25 Despesas, 17 Receitas</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Grid de Conteúdo -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 md:gap-8">
        <!-- Ações Rápidas -->
        <div class="lg:col-span-1 space-y-6 md:space-y-8">
            <div class="bg-white rounded-2xl border border-gray-200 p-6 shadow-sm">
                <h4 class="text-lg font-bold text-gray-800 mb-4 flex items-center gap-2">
                    <i class="fas fa-bolt text-amber-500"></i>
                    Ações Rápidas
                </h4>
                <div class="grid grid-cols-2 gap-3">
                    <a href="<?= url('/financeiro/contaspagar/form') ?>"
                        class="p-4 rounded-xl border border-gray-200 hover:border-red-300 hover:bg-red-50/50 transition-all duration-200 group text-center">
                        <div
                            class="w-10 h-10 rounded-lg bg-gradient-to-br from-red-100 to-red-50 flex items-center justify-center mx-auto mb-2 group-hover:scale-110 transition-transform">
                            <i class="fas fa-file-invoice-dollar text-red-600"></i>
                        </div>
                        <div class="font-medium text-gray-800 text-sm">Nova Despesa</div>
                    </a>
                    <a href="<?= url('/financeiro/contasreceber/form') ?>"
                        class="p-4 rounded-xl border border-gray-200 hover:border-green-300 hover:bg-green-50/50 transition-all duration-200 group text-center">
                        <div
                            class="w-10 h-10 rounded-lg bg-gradient-to-br from-green-100 to-green-50 flex items-center justify-center mx-auto mb-2 group-hover:scale-110 transition-transform">
                            <i class="fas fa-hand-holding-usd text-green-600"></i>
                        </div>
                        <div class="font-medium text-gray-800 text-sm">Nova Receita</div>
                    </a>
                    <a href="<?= url('/financeiro/planodecontas') ?>"
                        class="p-4 rounded-xl border border-gray-200 hover:border-purple-300 hover:bg-purple-50/50 transition-all duration-200 group text-center">
                        <div
                            class="w-10 h-10 rounded-lg bg-gradient-to-br from-purple-100 to-purple-50 flex items-center justify-center mx-auto mb-2 group-hover:scale-110 transition-transform">
                            <i class="fas fa-book text-purple-600"></i>
                        </div>
                        <div class="font-medium text-gray-800 text-sm">Plano de Contas</div>
                    </a>
                    <a href="<?= url('/contasBancarias') ?>"
                        class="p-4 rounded-xl border border-gray-200 hover:border-blue-300 hover:bg-blue-50/50 transition-all duration-200 group text-center">
                        <div
                            class="w-10 h-10 rounded-lg bg-gradient-to-br from-blue-100 to-blue-50 flex items-center justify-center mx-auto mb-2 group-hover:scale-110 transition-transform">
                            <i class="fas fa-university text-blue-600"></i>
                        </div>
                        <div class="font-medium text-gray-800 text-sm">Contas Bancárias</div>
                    </a>
                </div>
            </div>
        </div>

        <!-- Gráfico -->
        <div class="lg:col-span-2 bg-white rounded-2xl border border-gray-200 p-6 shadow-sm">
            <h3 class="text-lg md:text-xl font-bold text-gray-800 flex items-center gap-3 mb-4">
                <div
                    class="w-10 h-10 rounded-lg bg-gradient-to-br from-blue-500 to-blue-600 flex items-center justify-center">
                    <i class="fas fa-chart-bar text-white"></i>
                </div>
                Balanço (Últimos 6 meses)
            </h3>
            <!-- Placeholder for chart -->
            <div class="h-64 bg-gray-100 rounded-lg flex items-center justify-center">
                <p class="text-gray-500">Gráfico em breve</p>
            </div>
        </div>

    </div>
</div>