<?php

namespace App\Modules\Fornecedor\Models;

use App\Core\Orm;

class FornecedorModel extends Orm
{
    public function __construct()
    {
        parent::__construct();
        $this->tabela = "fornecedor";
        $this->chave_primaria = "fornecedor_id";
        $this->order_by = "fornecedor_id DESC";

        // Configuração dos Timestamps automáticos do ORM
        $this->created_at_column = 'fornecedor_criadoEm';
        $this->updated_at_column = 'fornecedor_alteradoEm';

        $this->colunas = [
            'fornecedor_id as id',
            'fornecedor_nome as name',
            'fornecedor_cnpj as cnpj',
            'fornecedor_email as email',
            'fornecedor_telefone as phone',
            'fornecedor_status as status',
            'fornecedor_criadoEm as created_at',
            'fornecedor_alteradoEm as updated_at'
        ];
    }

    /**
     * Atalho estático para iniciar uma consulta fluida
     * @return self
     */
    public static function query()
    {
        return new self();
    }

    public function getDashboardStats()
    {
        $stats = [];

        // Total de Fornecedores
        $stats['total_fornecedores'] = (new self())->contar();


        // Total de Fornecedores Ativos
        $stats['total_fornecedores_ativos'] = (new self())
            ->and('fornecedor_status', 'Ativo')
            ->contar();


        // Total de Fornecedores Inativos
        $stats['total_fornecedores_inativos'] = (new self())
            ->and('fornecedor_status', 'Inativo')
            ->contar();

        $stats['new_customers_30_days'] = (new self())
            ->whereRaw('fornecedor_criadoEm >= DATE_SUB(NOW(), INTERVAL 30 DAY)')
            ->contar();

        // Clientes Atualizados (últimos 30 dias)
        $stats['updated_customers_30_days'] = (new self())
            ->whereRaw('fornecedor_alteradoEm >= DATE_SUB(NOW(), INTERVAL 30 DAY)')
            ->whereRaw('fornecedor_alteradoEm > fornecedor_criadoEm')
            ->contar();

        // Inadimplentes (placeholder, lógica a ser definida)
        $stats['overdue_customers'] = 0;

        return $stats;
    }
}
