<div id="toast" class="fixed top-5 right-5 bg-green-500 text-white py-2 px-4 rounded-lg shadow-md z-50"
    style="display: none; transition: opacity 0.5s ease;"></div>

<div class="container mx-auto p-4">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold"><?= e($title) ?></h1>
        <a href="<?= BASE_URL ?>/fornecedor/form"
            class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 shadow-sm">Novo Fornecedor</a>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">

        <div class="bg-white p-6 rounded-xl shadow-md border-l-4 border-blue-500 hover:shadow-lg transition-shadow">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-semibold text-gray-500 uppercase tracking-wide">Total</p>
                    <p class="text-3xl font-bold text-gray-900 mt-2" id="total-suppliers">
                        <?= e($stats['total_fornecedores'] ?? 0) ?>
                    </p>
                    <div class="flex items-center mt-1">
                        <span class="text-xs text-gray-500">Todos os fornecedores</span>
                    </div>
                </div>
                <div class="p-3 bg-blue-50 rounded-full">
                    <i class="fa-solid fa-building text-blue-600 text-xl"></i>
                </div>
            </div>
        </div>


        <div class="bg-white p-6 rounded-xl shadow-md border-l-4 border-green-500 hover:shadow-lg transition-shadow">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-semibold text-gray-500 uppercase tracking-wide">Ativos</p>
                    <p class="text-3xl font-bold text-green-600 mt-2" id="active-suppliers">
                        <?= e($stats['total_fornecedores_ativos'] ?? 0) ?>
                    </p>
                    <div class="flex items-center mt-1">
                        <span class="text-xs text-green-500">
                            <i class="fa-solid fa-arrow-up mr-1"></i>
                            <span id="active-percentage">0%</span> do total
                        </span>
                    </div>
                </div>
                <div class="p-3 bg-green-50 rounded-full">
                    <i class="fa-solid fa-check-circle text-green-600 text-xl"></i>
                </div>
            </div>
        </div>


        <div class="bg-white p-6 rounded-xl shadow-md border-l-4 border-red-500 hover:shadow-lg transition-shadow">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-semibold text-gray-500 uppercase tracking-wide">Inativos</p>
                    <p class="text-3xl font-bold text-gray-600 mt-2" id="inactive-suppliers">
                        <?= e($stats['total_fornecedores_inativos'] ?? 0) ?>
                    </p>
                    <div class="flex items-center mt-1">
                        <span class="text-xs text-gray-500">
                            <span id="inactive-percentage">0%</span> do total
                        </span>
                    </div>
                </div>
                <div class="p-3 bg-gray-100 rounded-full">
                    <i class="fa-solid fa-pause-circle text-gray-600 text-xl"></i>
                </div>
            </div>
        </div>


        <div class="bg-gradient-to-br from-blue-50 to-indigo-50 p-6 rounded-xl shadow-sm border border-blue-100">
            <p class="text-sm font-semibold text-blue-700 uppercase tracking-wide mb-4">Ações Rápidas</p>
            <div class="space-y-3">
                <button onclick="importSuppliers()"
                    class="w-full px-3 py-2 bg-white border border-blue-200 text-blue-700 rounded-lg hover:bg-blue-50 transition-colors text-sm flex items-center justify-center gap-2">
                    <i class="fa-solid fa-upload"></i>
                    Importar Lista
                </button>
                <button onclick="sendBulkNotification()"
                    class="w-full px-3 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors text-sm flex items-center justify-center gap-2">
                    <i class="fa-solid fa-bell"></i>
                    Notificar Todos
                </button>
            </div>
        </div>
    </div>

    <div class="bg-white p-6 rounded-lg shadow-md">
        <h2 class="text-xl font-bold mb-4">Lista de Fornecedores</h2>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nome
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">CNPJ
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Telefone</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Status</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Ações</th>
                    </tr>
                </thead>
                <tbody id="fornecedor-list" class="bg-white divide-y divide-gray-200">

                </tbody>
            </table>
        </div>

        <div id="pagination-controls" class="mt-4 flex justify-center items-center space-x-2">

        </div>
    </div>
</div>
<script type="module" src="<?= BASE_URL ?>/public/assets/js/fornecedor/fornecedorWrapper.js"></script>