<?php

namespace App\Shared\Helpers;

class SqlErrorParser
{
    public static function parse(string $message): string
    {
        // Log the original error for debugging purposes
        error_log("Original SQL Error: " . $message);
        
        if (strpos($message, 'foreign key constraint fails') !== false) {
            return "Operação falhou: Existe um relacionamento com outro registro que impede a alteração ou exclusão.";
        }
        if (strpos($message, 'Duplicate entry') !== false) {
            if (preg_match("/Duplicate entry '(.*)' for key/", $message, $matches)) {
                return "Erro: O valor '{$matches[1]}' já existe e não pode ser duplicado.";
            }
            return "Erro: A operação viola uma regra de valor único (chave duplicada).";
        }
        if (strpos($message, 'cannot be null') !== false) {
            if (preg_match("/Column '(.*)' cannot be null/", $message, $matches)) {
                return "Erro: O campo '{$matches[1]}' é obrigatório e não pode ser nulo.";
            }
            return "Erro: Um campo obrigatório não foi preenchido.";
        }
        if (strpos($message, 'Unknown database') !== false) {
            if (preg_match("/Unknown database '(.*)'/", $message, $matches)) {
                return "Erro de Configuração: O banco de dados '{$matches[1]}' não foi encontrado.";
            }
            return "Erro de Configuração: O banco de dados especificado não foi encontrado.";
        }
        if (strpos($message, 'Base table or view not found') !== false) {
             if (preg_match("/Table '.*\\.(.*)' doesn't exist/", $message, $matches)) {
                return "Erro: A tabela '{$matches[1]}' não existe no banco de dados.";
            }
            return "Erro: Uma tabela necessária para a operação não foi encontrada.";
        }
        if (strpos($message, 'Numeric value out of range') !== false) {
            return "Erro: Um valor numérico fornecido é muito grande para a coluna correspondente.";
        }
        if (strpos($message, 'Unknown column') !== false) {
            if (preg_match("/Unknown column '(.*)' in/", $message, $matches)) {
                return "Erro: A coluna '{$matches[1]}' não foi encontrada na tabela.";
            }
             return "Erro: Uma coluna desconhecida foi referenciada na consulta.";
        }
        
        // Default user-friendly message for unhandled DB errors
        return "Ocorreu um erro inesperado no banco de dados. Por favor, contate o suporte.";
    }
}
