<?php function e($v)
{
    return htmlspecialchars((string) $v, ENT_QUOTES, 'UTF-8');
}

function url(string $path): string
{
    return BASE_URL . $path;
}

if (!function_exists('debug_code')) {
    /**
     * Função para depurar variáveis, arrays ou objetos de forma legível.
     *
     * @param mixed $data O dado a ser depurado.
     * @param bool $exit Interrompe a execução do script após a depuração se for true.
     * @return void
     */
    function debug_code($data, $exit = true)
    {
        echo "<pre>";
        print_r($data);
        echo "</pre>";
        if ($exit) {
            exit(0);
        }
    }
}