# MODAL.JS — DOCUMENTAÇÃO DE USO

Este módulo fornece um sistema de modais robusto, com suporte a injeção de elementos DOM, controle de tamanho e API limpa. Diferente do diálogo, o modal é focado em conteúdos mais densos e personalizados.

O modal é acionado diretamente em um elemento DOM através do método:

```javascript
element.modal(options)
```

---

## ESTRUTURA HTML ESPERADA
Para o correto funcionamento, o elemento base deve seguir esta hierarquia de classes:

```html
<div id="appModal" class="modal hidden">
    <div class="modal-backdrop"></div>
    <div class="modal-box">
        <div class="modal-header">
            <h3 class="modal-title"></h3>
            <button class="modal-close">&times;</button>
        </div>

        <div class="modal-body">
            </div>

        <div class="modal-footer">
            <button class="modal-btn modal-cancel">Cancelar</button>
            <button class="modal-btn modal-approve">Confirmar</button>
        </div>
    </div>
</div>
```

---

## OPÇÕES DE CONFIGURAÇÃO (OPTIONS)

| Propriedade | Tipo | Padrão | Descrição |
| :--- | :--- | :--- | :--- |
| `title` | String | `''` | Título exibido no cabeçalho. |
| `content` | String/DOM | `''` | Texto simples ou um elemento HTML (ex: um formulário). |
| `size` | String | `'medium'` | Tamanhos: `'small'`, `'medium'`, `'large'`, `'full'`. |
| `type` | String | `''` | Classe CSS extra para estilização (ex: `'danger'`, `'info'`). |
| `showFooter`| Boolean | `true` | Define se o rodapé com botões deve aparecer. |

---

## EXEMPLOS DE USO

### 1. Modal Simples (Texto)
```javascript
const modal = document.getElementById('appModal');

modal.modal({
    title: 'Aviso do Sistema',
    content: 'Este é um modal básico com texto simples.'
});
```

### 2. Modal com Elemento DOM (Formulário)
Ideal para carregar formulários que estão escondidos na página.
```javascript
const meuForm = document.getElementById('formCliente');

modal.modal({
    title: 'Editar Cadastro',
    content: meuForm, // Injeta o elemento DOM diretamente
    size: 'large',
    onApprove: () => {
        console.log('Salvar dados...');
    }
});
```

### 3. Modal Full Screen sem Rodapé
```javascript
modal.modal({
    title: 'Visualização de Documento',
    content: document.getElementById('preview'),
    size: 'full',
    showFooter: false
});
```

### 4. Modal de Ação Crítica (Danger)
```javascript
modal.modal({
    title: 'Excluir Registro',
    content: 'Tem certeza que deseja apagar este item?',
    type: 'danger',
    onApprove: () => {
        executarExclusao();
    },
    onCancel: () => {
        console.log('Operação abortada');
    }
});
```

---

## CALLBACKS DISPONÍVEIS

```javascript
modal.modal({
    onOpen: () => { /* Dispara ao abrir */ },
    onClose: () => { /* Dispara ao fechar por qualquer motivo */ },
    onApprove: () => { /* Dispara ao clicar no botão confirmar */ },
    onCancel: () => { /* Dispara ao fechar via ESC, Backdrop ou Cancelar */ }
});
```

---

## COMPORTAMENTOS AUTOMÁTICOS
* **Segurança:** Se `content` for uma string, o script usa `textContent` para evitar ataques XSS. Se for um objeto DOM, ele usa `appendChild`.
* **Teclado:** A tecla `ESC` fecha o modal automaticamente.
* **Limpeza:** O modal limpa classes residuais de tamanho e tipo a cada nova chamada.
* **Backdrop:** Clicar fora da `modal-box` dispara o evento de cancelamento e fecha o modal.

---

## BOAS PRÁTICAS
* ✔ **Reutilização:** Utilize apenas um elemento de modal na página para diferentes funções.
* ✔ **Performance:** Passe elementos DOM existentes em vez de criar HTML complexo via string.
* ✔ **UX:** Use o tamanho `small` para avisos rápidos e `large/full` para formulários ou listagens.