<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    <link href="<?= BASE_URL ?>/public/assets/css/style.css" rel="stylesheet">

    <title><?= e($title ?? 'Meu Projeto') ?></title>

    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>

<body class="bg-slate-200 font-inter" data-base-url="<?= BASE_URL ?>">

    <div class="p-4">
        <div class="bg-linear-to-br from-gray-50 to-blue-50 min-h-screen">
            <div class="flex">

                <aside id="sidebar"
                    class="w-72 h-screen bg-gradient-to-br from-white to-blue-50/30 border-r border-blue-100 shadow-xl sticky top-0 transition-all duration-300">

                    <div class="h-20 flex items-center justify-between px-6 border-b border-blue-100/50">
                        <div class="flex items-center gap-3">
                            <div
                                class="w-10 h-10 bg-gradient-to-br from-blue-600 to-indigo-700 rounded-xl flex items-center justify-center shadow-lg shadow-blue-500/30">
                                <i class="fas fa-chart-line text-white text-lg"></i>
                            </div>
                            <div>
                                <h1
                                    class="text-lg font-bold bg-gradient-to-r from-blue-600 to-indigo-700 bg-clip-text text-transparent tracking-tight">
                                    AppFinanceiro
                                </h1>
                                <p class="text-xs text-gray-500">Módulo Financeiro</p>
                            </div>
                        </div>
                    </div>

                    <div class="px-6 py-5 border-b border-blue-100/50">
                        <div class="flex items-center gap-3">
                            <div class="relative">
                                <div
                                    class="w-10 h-10 bg-gradient-to-br from-purple-500 to-pink-500 rounded-full flex items-center justify-center text-white font-bold shadow-md">
                                    <span>JS</span>
                                </div>
                                <div
                                    class="absolute bottom-0 right-0 w-3 h-3 bg-green-400 rounded-full border-2 border-white">
                                </div>
                            </div>
                            <div class="flex-1 overflow-hidden">
                                <h3 class="font-semibold text-gray-800 truncate text-sm">Jane Smith</h3>
                                <p class="text-xs text-gray-500 truncate">Administrador</p>
                            </div>
                        </div>
                    </div>

                    <!-- <nav class="px-4 py-6 space-y-2">

                        <a href="<?= url('/Financeiro') ?>"
                            class="sidebar-item flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-red-50 transition-all group"
                            data-menu-item="home">
                            <div
                                class="w-8 h-8 bg-red-500 rounded-lg flex items-center justify-center shadow-md shadow-red-200 group-hover:scale-110 transition-transform">
                                <i class="fas fa-home text-white text-sm"></i>
                            </div>
                            <span class="font-medium text-gray-700 group-hover:text-red-700">Dashboard</span>
                        </a>

                        <div class="space-y-1">
                            <button type="button"
                                class="sidebar-item flex items-center justify-between w-full px-4 py-3 rounded-xl hover:bg-indigo-50 transition-all group"
                                data-menu="cadastros">
                                <div class="flex items-center gap-3">
                                    <div
                                        class="w-8 h-8 bg-indigo-600 rounded-lg flex items-center justify-center shadow-md shadow-indigo-200">
                                        <i class="fas fa-address-book text-white text-sm"></i>
                                    </div>
                                    <span class="font-medium text-gray-700 group-hover:text-indigo-700">Cadastros</span>
                                </div>
                                <i
                                    class="fas fa-chevron-down text-xs transition-transform duration-300 text-gray-400"></i>
                            </button>

                            <div class="submenu grid grid-rows-[0fr] transition-[grid-template-rows] duration-300 ease-in-out"
                                data-submenu="cadastros">
                                <div class="overflow-hidden">
                                    <div
                                        class="submenu-content ml-6 pl-4 border-l-2 border-indigo-100 space-y-1 pt-2 opacity-0 -translate-y-1 transition-all duration-300">
                                        <a href="<?= url('/cliente') ?>"
                                            class="submenu-item flex items-center gap-2 py-2 px-3 rounded-lg text-sm text-gray-600 hover:bg-indigo-50 hover:text-indigo-700 transition-colors">
                                            <i class="fas fa-user text-[10px]"></i> Clientes
                                        </a>
                                        <a href="<?= url('/Fornecedor') ?>"
                                            class="submenu-item flex items-center gap-2 py-2 px-3 rounded-lg text-sm text-gray-600 hover:bg-indigo-50 hover:text-indigo-700 transition-colors">
                                            <i class="fas fa-truck text-[10px]"></i> Fornecedores
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="space-y-1">
                            <button type="button"
                                class="sidebar-item flex items-center justify-between w-full px-4 py-3 rounded-xl hover:bg-indigo-50 transition-all group"
                                data-menu="estoque">
                                <div class="flex items-center gap-3">
                                    <div
                                        class="w-8 h-8 bg-indigo-600 rounded-lg flex items-center justify-center shadow-md shadow-indigo-200">
                                        <i class="fas fa-address-book text-white text-sm"></i>
                                    </div>
                                    <span class="font-medium text-gray-700 group-hover:text-indigo-700">Estoque</span>
                                </div>
                                <i
                                    class="fas fa-chevron-down text-xs transition-transform duration-300 text-gray-400"></i>
                            </button>

                            <div class="submenu grid grid-rows-[0fr] transition-[grid-template-rows] duration-300 ease-in-out"
                                data-submenu="estoque">
                                <div class="overflow-hidden">
                                    <div
                                        class="submenu-content ml-6 pl-4 border-l-2 border-indigo-100 space-y-1 pt-2 opacity-0 -translate-y-1 transition-all duration-300">
                                        <a href="<?= url('/estoque/produtos') ?>"
                                            class="submenu-item flex items-center gap-2 py-2 px-3 rounded-lg text-sm text-gray-600 hover:bg-indigo-50 hover:text-indigo-700 transition-colors">
                                            <i class="fas fa-user text-[10px]"></i> Produtos
                                        </a>
                                        <a href="<?= url('/estoque/categoriaproduto') ?>"
                                            class="submenu-item flex items-center gap-2 py-2 px-3 rounded-lg text-sm text-gray-600 hover:bg-indigo-50 hover:text-indigo-700 transition-colors">
                                            <i class="fas fa-layer-group text-[10px]"></i> Categoria de Produtos
                                        </a>
                                        <a href="<?= url('/estoque/unidademedida') ?>"
                                            class="submenu-item flex items-center gap-2 py-2 px-3 rounded-lg text-sm text-gray-600 hover:bg-indigo-50 hover:text-indigo-700 transition-colors">
                                            <i class="fas fa-ruler-combined text-[10px]"></i> Unidades de Medida
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="space-y-1">
                            <button type="button"
                                class="sidebar-item flex items-center justify-between w-full px-4 py-3 rounded-xl hover:bg-emerald-50 transition-all group"
                                data-menu="financeiro_mod">
                                <div class="flex items-center gap-3">
                                    <div
                                        class="w-8 h-8 bg-emerald-600 rounded-lg flex items-center justify-center shadow-md shadow-emerald-200">
                                        <i class="fas fa-coins text-white text-sm"></i>
                                    </div>
                                    <span
                                        class="font-medium text-gray-700 group-hover:text-emerald-700">Financeiro</span>
                                </div>
                                <i
                                    class="fas fa-chevron-down text-xs transition-transform duration-300 text-gray-400"></i>
                            </button>

                            <div class="submenu grid grid-rows-[0fr] transition-[grid-template-rows] duration-300 ease-in-out"
                                data-submenu="financeiro_mod">
                                <div class="overflow-hidden">
                                    <div
                                        class="submenu-content ml-6 pl-4 border-l-2 border-emerald-100 space-y-1 pt-2 opacity-0 -translate-y-1 transition-all duration-300">
                                        <a href="<?= url('/Financeiro') ?>"
                                            class="submenu-item flex items-center gap-2 py-2 px-3 rounded-lg text-sm text-gray-600 hover:bg-emerald-50 hover:text-emerald-700 transition-colors">
                                            <i class="fas fa-university text-[10px]"></i> Dashboard Financeiro
                                        </a>
                                        <a href="<?= url('/contasBancarias') ?>"
                                            class="submenu-item flex items-center gap-2 py-2 px-3 rounded-lg text-sm text-gray-600 hover:bg-emerald-50 hover:text-emerald-700 transition-colors">
                                            <i class="fas fa-university text-[10px]"></i> Contas Bancárias
                                        </a>
                                        <a href="<?= url('/Financeiro/PlanoDeContas') ?>"
                                            class="submenu-item flex items-center gap-2 py-2 px-3 rounded-lg text-sm text-gray-600 hover:bg-emerald-50 hover:text-emerald-700 transition-colors">
                                            <i class="fas fa-sitemap text-[10px]"></i> Plano de Contas
                                        </a>
                                        <a href="<?= url('/Financeiro/ContasPagar') ?>"
                                            class="submenu-item flex items-center gap-2 py-2 px-3 rounded-lg text-sm text-gray-600 hover:bg-emerald-50 hover:text-emerald-700 transition-colors">
                                            <i class="fas fa-file-invoice-dollar text-[10px]"></i> Contas a Pagar
                                        </a>
                                        <a href="<?= url('/Financeiro/ContasReceber') ?>"
                                            class="submenu-item flex items-center gap-2 py-2 px-3 rounded-lg text-sm text-gray-600 hover:bg-emerald-50 hover:text-emerald-700 transition-colors">
                                            <i class="fas fa-hand-holding-usd text-[10px]"></i> Contas a Receber
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </nav> -->

                    <nav class="px-3 py-6 space-y-2">
                        <!-- Dashboard -->
                        <a href="<?= url('/Financeiro') ?>"
                            class="sidebar-item relative flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-gradient-to-r hover:from-fuchsia-50 hover:to-transparent transition-all duration-300 group overflow-hidden"
                            data-menu-item="home">
                            <!-- Glow effect -->
                            <div
                                class="absolute inset-0 bg-gradient-to-r from-fuchsia-500/10 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                            </div>

                            <div class="relative">
                                <div
                                    class="w-10 h-10 bg-gradient-to-br from-fuchsia-500 to-fuchsia-600 rounded-xl flex items-center justify-center shadow-lg shadow-fuchsia-200/50 group-hover:shadow-fuchsia-300/70 group-hover:scale-105 transition-all duration-300">
                                    <i class="fas fa-tachometer-alt text-white text-base"></i>
                                </div>
                                <div
                                    class="absolute -inset-1 bg-gradient-to-r from-fuchsia-400/30 to-fuchsia-300/20 rounded-xl blur-sm opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                                </div>
                            </div>

                            <span
                                class="font-semibold text-gray-800 group-hover:text-fuchsia-700 group-hover:translate-x-1 transition-all duration-300 relative">
                                Dashboard
                                <span
                                    class="absolute -bottom-1 left-0 w-0 h-0.5 bg-gradient-to-r from-fuchsia-500 to-fuchsia-400 group-hover:w-full transition-all duration-500"></span>
                            </span>
                        </a>

                        <!-- Cadastros -->
                        <div class="space-y-1">
                            <button type="button"
                                class="sidebar-item relative flex items-center justify-between w-full px-4 py-3 rounded-xl hover:bg-gradient-to-r hover:from-blue-50 hover:to-transparent transition-all duration-300 group overflow-hidden"
                                data-menu="cadastros">
                                <!-- Glow effect -->
                                <div
                                    class="absolute inset-0 bg-gradient-to-r from-blue-500/5 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                                </div>

                                <div class="flex items-center gap-3 relative">
                                    <div
                                        class="w-10 h-10 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center shadow-lg shadow-blue-200/50 group-hover:shadow-blue-300/70">
                                        <i class="fas fa-user-plus text-white text-base"></i>
                                    </div>
                                    <div
                                        class="absolute -inset-1 bg-gradient-to-r from-blue-400/20 to-blue-300/10 rounded-xl blur-sm opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                                    </div>

                                    <span
                                        class="font-semibold text-gray-800 group-hover:text-blue-700 group-hover:translate-x-1 transition-all duration-300 relative">
                                        Cadastros
                                        <span
                                            class="absolute -bottom-1 left-0 w-0 h-0.5 bg-gradient-to-r from-blue-600 to-blue-400 group-hover:w-full transition-all duration-500"></span>
                                    </span>
                                </div>

                                <i
                                    class="fas fa-chevron-down text-xs transition-all duration-500 text-gray-500 group-hover:text-blue-600 group-hover:rotate-180"></i>
                            </button>

                            <div class="submenu grid grid-rows-[0fr] transition-[grid-template-rows] duration-500 ease-[cubic-bezier(0.4,0,0.2,1)]"
                                data-submenu="cadastros">
                                <div class="overflow-hidden">
                                    <div
                                        class="submenu-content ml-12 space-y-1 pt-1 opacity-0 -translate-y-2 transition-all duration-500">
                                        <!-- Clientes -->
                                        <a href="<?= url('/cliente') ?>"
                                            class="submenu-item relative flex items-center justify-between gap-3 py-2.5 px-4 rounded-lg text-sm text-gray-600 hover:text-blue-700 transition-all duration-300 hover:bg-gradient-to-r hover:from-blue-50/80 hover:to-transparent group/item">
                                            <div class="flex items-center gap-3">
                                                <div
                                                    class="w-7 h-7 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center group-hover/item:scale-110 transition-all duration-300">
                                                    <i class="fas fa-users text-white text-xs"></i>
                                                </div>
                                                <span class="font-medium">
                                                    Clientes
                                                </span>
                                            </div>
                                            <!-- Seta indicadora (visível apenas quando ativo) -->
                                            <i
                                                class="fas fa-chevron-right text-xs text-blue-500 opacity-0 group-hover/item:opacity-100 transition-opacity duration-300"></i>
                                        </a>

                                        <!-- Fornecedores -->
                                        <a href="<?= url('/Fornecedor') ?>"
                                            class="submenu-item relative flex items-center justify-between gap-3 py-2.5 px-4 rounded-lg text-sm text-gray-600 hover:text-blue-700 transition-all duration-300 hover:bg-gradient-to-r hover:from-blue-50/80 hover:to-transparent group/item">
                                            <div class="flex items-center gap-3">
                                                <div
                                                    class="w-7 h-7 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center group-hover/item:scale-110 transition-all duration-300">
                                                    <i class="fas fa-truck-loading text-white text-xs"></i>
                                                </div>
                                                <span class="font-medium">
                                                    Fornecedores
                                                </span>
                                            </div>
                                            <!-- Seta indicadora (visível apenas quando ativo) -->
                                            <i
                                                class="fas fa-chevron-right text-xs text-blue-500 opacity-0 group-hover/item:opacity-100 transition-opacity duration-300"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Estoque -->
                        <div class="space-y-1">
                            <button type="button"
                                class="sidebar-item relative flex items-center justify-between w-full px-4 py-3 rounded-xl hover:bg-gradient-to-r hover:from-emerald-50 hover:to-transparent transition-all duration-300 group overflow-hidden"
                                data-menu="estoque">
                                <!-- Glow effect -->
                                <div
                                    class="absolute inset-0 bg-gradient-to-r from-emerald-500/5 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                                </div>

                                <div class="flex items-center gap-3 relative">
                                    <div
                                        class="w-10 h-10 bg-gradient-to-br from-emerald-600 to-emerald-700 rounded-xl flex items-center justify-center shadow-lg shadow-emerald-200/50 group-hover:shadow-emerald-300/70">
                                        <i class="fas fa-boxes text-white text-base"></i>
                                    </div>
                                    <div
                                        class="absolute -inset-1 bg-gradient-to-r from-emerald-300/20 to-emerald-200/10 rounded-xl blur-sm opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                                    </div>

                                    <span
                                        class="font-semibold text-gray-800 group-hover:text-emerald-700 group-hover:translate-x-1 transition-all duration-300 relative">
                                        Estoque
                                        <span
                                            class="absolute -bottom-1 left-0 w-0 h-0.5 bg-gradient-to-r from-emerald-600 to-emerald-400 group-hover:w-full transition-all duration-500"></span>
                                    </span>
                                </div>

                                <i
                                    class="fas fa-chevron-down text-xs transition-all duration-500 text-gray-500 group-hover:text-emerald-600 group-hover:rotate-180"></i>
                            </button>

                            <div class="submenu grid grid-rows-[0fr] transition-[grid-template-rows] duration-500 ease-[cubic-bezier(0.4,0,0.2,1)]"
                                data-submenu="estoque">
                                <div class="overflow-hidden">
                                    <div
                                        class="submenu-content ml-12 space-y-1 pt-1 opacity-0 -translate-y-2 transition-all duration-500">
                                         
                                        <!-- Dashboard Estoque -->
                                        <a href="<?= url('/estoque') ?>"
                                            class="submenu-item relative flex items-center justify-between gap-3 py-2.5 px-4 rounded-lg text-sm text-gray-600 hover:text-emerald-700 transition-all duration-300 hover:bg-gradient-to-r hover:from-emerald-50/80 hover:to-transparent group/item">
                                            <div class="flex items-center gap-3">
                                                <div
                                                     class="w-7 h-7 bg-gradient-to-br from-emerald-500 to-emerald-600 rounded-lg flex items-center justify-center group-hover/item:scale-110 transition-all duration-300">
                                                    <i class="fas fa-tachometer-alt text-white text-xs"></i>
                                                </div>
                                                <span class="font-medium">
                                                    Dashboard
                                                </span>
                                            </div>
                                            <!-- Seta indicadora (visível apenas quando ativo) -->
                                            <i
                                                class="fas fa-chevron-right text-xs text-emerald-500 opacity-0 group-hover/item:opacity-100 transition-opacity duration-300"></i>
                                        </a>
                                        
                                        <!-- Produtos -->
                                        <a href="<?= url('/estoque/produtos') ?>"
                                            class="submenu-item relative flex items-center justify-between gap-3 py-2.5 px-4 rounded-lg text-sm text-gray-600 hover:text-emerald-700 transition-all duration-300 hover:bg-gradient-to-r hover:from-emerald-50/80 hover:to-transparent group/item">
                                            <div class="flex items-center gap-3">
                                                <div
                                                    class="w-7 h-7 bg-gradient-to-br from-emerald-500 to-emerald-600 rounded-lg flex items-center justify-center group-hover/item:scale-110 transition-all duration-300">
                                                    <i class="fas fa-box-open text-white text-xs"></i>
                                                </div>
                                                <span class="font-medium">
                                                    Produtos
                                                </span>
                                            </div>
                                            <!-- Seta indicadora (visível apenas quando ativo) -->
                                            <i
                                                class="fas fa-chevron-right text-xs text-emerald-500 opacity-0 group-hover/item:opacity-100 transition-opacity duration-300"></i>
                                        </a>

                                        <!-- Categoria de Produtos -->
                                        <a href="<?= url('/estoque/categoriaproduto') ?>"
                                            class="submenu-item relative flex items-center justify-between gap-3 py-2.5 px-4 rounded-lg text-sm text-gray-600 hover:text-emerald-700 transition-all duration-300 hover:bg-gradient-to-r hover:from-emerald-50/80 hover:to-transparent group/item">
                                            <div class="flex items-center gap-3">
                                                <div
                                                    class="w-7 h-7 bg-gradient-to-br from-emerald-500 to-emerald-600 rounded-lg flex items-center justify-center group-hover/item:scale-110 transition-all duration-300">
                                                    <i class="fas fa-tags text-white text-xs"></i>
                                                </div>
                                                <span class="font-medium">
                                                    Categorias
                                                </span>
                                            </div>
                                            <!-- Seta indicadora (visível apenas quando ativo) -->
                                            <i
                                                class="fas fa-chevron-right text-xs text-emerald-500 opacity-0 group-hover/item:opacity-100 transition-opacity duration-300"></i>
                                        </a>

                                        <!-- Unidades de Medida -->
                                        <a href="<?= url('/estoque/unidademedida') ?>"
                                            class="submenu-item relative flex items-center justify-between gap-3 py-2.5 px-4 rounded-lg text-sm text-gray-600 hover:text-emerald-700 transition-all duration-300 hover:bg-gradient-to-r hover:from-emerald-50/80 hover:to-transparent group/item">
                                            <div class="flex items-center gap-3">
                                                <div
                                                    class="w-7 h-7 bg-gradient-to-br from-emerald-500 to-emerald-600 rounded-lg flex items-center justify-center group-hover/item:scale-110 transition-all duration-300">
                                                    <i class="fas fa-ruler-combined text-white text-xs"></i>
                                                </div>
                                                <span class="font-medium">
                                                    Unidades de Medida
                                                </span>
                                            </div>
                                            <!-- Seta indicadora (visível apenas quando ativo) -->
                                            <i
                                                class="fas fa-chevron-right text-xs text-emerald-500 opacity-0 group-hover/item:opacity-100 transition-opacity duration-300"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Financeiro -->
                        <div class="space-y-1">
                            <button type="button"
                                class="sidebar-item relative flex items-center justify-between w-full px-4 py-3 rounded-xl hover:bg-gradient-to-r hover:from-amber-50 hover:to-transparent transition-all duration-300 group overflow-hidden"
                                data-menu="financeiro_mod">
                                <!-- Glow effect -->
                                <div
                                    class="absolute inset-0 bg-gradient-to-r from-amber-500/5 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                                </div>

                                <div class="flex items-center gap-3 relative">
                                    <div
                                        class="w-10 h-10 bg-gradient-to-br from-amber-500 to-amber-600 rounded-xl flex items-center justify-center shadow-lg shadow-amber-200/50 group-hover:shadow-amber-300/70">
                                        <i class="fas fa-chart-line text-white text-base"></i>
                                    </div>
                                    <div
                                        class="absolute -inset-1 bg-gradient-to-r from-amber-400/20 to-amber-300/10 rounded-xl blur-sm opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                                    </div>

                                    <span
                                        class="font-semibold text-gray-800 group-hover:text-amber-700 group-hover:translate-x-1 transition-all duration-300 relative">
                                        Financeiro
                                        <span
                                            class="absolute -bottom-1 left-0 w-0 h-0.5 bg-gradient-to-r from-amber-600 to-amber-400 group-hover:w-full transition-all duration-500"></span>
                                    </span>
                                </div>

                                <i
                                    class="fas fa-chevron-down text-xs transition-all duration-500 text-gray-500 group-hover:text-amber-600 group-hover:rotate-180"></i>
                            </button>

                            <div class="submenu grid grid-rows-[0fr] transition-[grid-template-rows] duration-500 ease-[cubic-bezier(0.4,0,0.2,1)]"
                                data-submenu="financeiro_mod">
                                <div class="overflow-hidden">
                                    <div
                                        class="submenu-content ml-12 space-y-1 pt-1 opacity-0 -translate-y-2 transition-all duration-500">
                                        <!-- Dashboard Financeiro -->
                                        <a href="<?= url('/Financeiro') ?>"
                                            class="submenu-item relative flex items-center justify-between gap-3 py-2.5 px-4 rounded-lg text-sm text-gray-600 hover:text-amber-700 transition-all duration-300 hover:bg-gradient-to-r hover:from-amber-50/80 hover:to-transparent group/item">
                                            <div class="flex items-center gap-3">
                                                <div
                                                    class="w-7 h-7 bg-gradient-to-br from-amber-500 to-amber-600 rounded-lg flex items-center justify-center group-hover/item:scale-110 transition-all duration-300">
                                                    <i class="fas fa-tachometer-alt text-white text-xs"></i>
                                                </div>
                                                <span class="font-medium">
                                                    Dashboard Financeiro
                                                </span>
                                            </div>
                                            <!-- Seta indicadora (visível apenas quando ativo) -->
                                            <i
                                                class="fas fa-chevron-right text-xs text-amber-500 opacity-0 group-hover/item:opacity-100 transition-opacity duration-300"></i>
                                        </a>

                                        <!-- Contas Bancárias -->
                                        <a href="<?= url('/contasBancarias') ?>"
                                            class="submenu-item relative flex items-center justify-between gap-3 py-2.5 px-4 rounded-lg text-sm text-gray-600 hover:text-amber-700 transition-all duration-300 hover:bg-gradient-to-r hover:from-amber-50/80 hover:to-transparent group/item">
                                            <div class="flex items-center gap-3">
                                                <div
                                                    class="w-7 h-7 bg-gradient-to-br from-amber-500 to-amber-600 rounded-lg flex items-center justify-center group-hover/item:scale-110 transition-all duration-300">
                                                    <i class="fas fa-university text-white text-xs"></i>
                                                </div>
                                                <span class="font-medium">
                                                    Contas Bancárias
                                                </span>
                                            </div>
                                            <!-- Seta indicadora (visível apenas quando ativo) -->
                                            <i
                                                class="fas fa-chevron-right text-xs text-amber-500 opacity-0 group-hover/item:opacity-100 transition-opacity duration-300"></i>
                                        </a>

                                        <!-- Plano de Contas -->
                                        <a href="<?= url('/Financeiro/PlanoDeContas') ?>"
                                            class="submenu-item relative flex items-center justify-between gap-3 py-2.5 px-4 rounded-lg text-sm text-gray-600 hover:text-amber-700 transition-all duration-300 hover:bg-gradient-to-r hover:from-amber-50/80 hover:to-transparent group/item">
                                            <div class="flex items-center gap-3">
                                                <div
                                                    class="w-7 h-7 bg-gradient-to-br from-amber-500 to-amber-600 rounded-lg flex items-center justify-center group-hover/item:scale-110 transition-all duration-300">
                                                    <i class="fas fa-sitemap text-white text-xs"></i>
                                                </div>
                                                <span class="font-medium">
                                                    Plano de Contas
                                                </span>
                                            </div>
                                            <!-- Seta indicadora (visível apenas quando ativo) -->
                                            <i
                                                class="fas fa-chevron-right text-xs text-amber-500 opacity-0 group-hover/item:opacity-100 transition-opacity duration-300"></i>
                                        </a>

                                        <!-- Contas a Pagar -->
                                        <a href="<?= url('/Financeiro/ContasPagar') ?>"
                                            class="submenu-item relative flex items-center justify-between gap-3 py-2.5 px-4 rounded-lg text-sm text-gray-600 hover:text-amber-700 transition-all duration-300 hover:bg-gradient-to-r hover:from-amber-50/80 hover:to-transparent group/item">
                                            <div class="flex items-center gap-3">
                                                <div
                                                    class="w-7 h-7 bg-gradient-to-br from-amber-500 to-amber-600 rounded-lg flex items-center justify-center group-hover/item:scale-110 transition-all duration-300">
                                                    <i class="fas fa-file-invoice-dollar text-white text-xs"></i>
                                                </div>
                                                <span class="font-medium">
                                                    Contas a Pagar
                                                </span>
                                            </div>
                                            <!-- Seta indicadora (visível apenas quando ativo) -->
                                            <i
                                                class="fas fa-chevron-right text-xs text-amber-500 opacity-0 group-hover/item:opacity-100 transition-opacity duration-300"></i>
                                        </a>

                                        <!-- Contas a Receber -->
                                        <a href="<?= url('/Financeiro/ContasReceber') ?>"
                                            class="submenu-item relative flex items-center justify-between gap-3 py-2.5 px-4 rounded-lg text-sm text-gray-600 hover:text-amber-700 transition-all duration-300 hover:bg-gradient-to-r hover:from-amber-50/80 hover:to-transparent group/item">
                                            <div class="flex items-center gap-3">
                                                <div
                                                    class="w-7 h-7 bg-gradient-to-br from-amber-500 to-amber-600 rounded-lg flex items-center justify-center group-hover/item:scale-110 transition-all duration-300">
                                                    <i class="fas fa-hand-holding-usd text-white text-xs"></i>
                                                </div>
                                                <span class="font-medium">
                                                    Contas a Receber
                                                </span>
                                            </div>
                                            <!-- Seta indicadora (visível apenas quando ativo) -->
                                            <i
                                                class="fas fa-chevron-right text-xs text-amber-500 opacity-0 group-hover/item:opacity-100 transition-opacity duration-300"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Comercial -->
                        <div class="space-y-1">
                            <button type="button"
                                class="sidebar-item relative flex items-center justify-between w-full px-4 py-3 rounded-xl hover:bg-gradient-to-r hover:from-purple-50 hover:to-transparent transition-all duration-300 group overflow-hidden"
                                data-menu="comercial">
                                <!-- Glow effect -->
                                <div
                                    class="absolute inset-0 bg-gradient-to-r from-purple-500/5 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                                </div>

                                <div class="flex items-center gap-3 relative">
                                    <div
                                        class="w-10 h-10 bg-gradient-to-br from-purple-500 to-purple-600 rounded-xl flex items-center justify-center shadow-lg shadow-purple-200/50 group-hover:shadow-purple-300/70">
                                        <i class="fas fa-shopping-cart text-white text-base"></i>
                                    </div>
                                    <div
                                        class="absolute -inset-1 bg-gradient-to-r from-purple-400/20 to-purple-300/10 rounded-xl blur-sm opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                                    </div>

                                    <span
                                        class="font-semibold text-gray-800 group-hover:text-purple-700 group-hover:translate-x-1 transition-all duration-300 relative">
                                        Comercial
                                        <span
                                            class="absolute -bottom-1 left-0 w-0 h-0.5 bg-gradient-to-r from-purple-600 to-purple-400 group-hover:w-full transition-all duration-500"></span>
                                    </span>
                                </div>

                                <i
                                    class="fas fa-chevron-down text-xs transition-all duration-500 text-gray-500 group-hover:text-purple-600 group-hover:rotate-180"></i>
                            </button>

                            <div class="submenu grid grid-rows-[0fr] transition-[grid-template-rows] duration-500 ease-[cubic-bezier(0.4,0,0.2,1)]"
                                data-submenu="comercial">
                                <div class="overflow-hidden">
                                    <div
                                        class="submenu-content ml-12 space-y-1 pt-1 opacity-0 -translate-y-2 transition-all duration-500">

                                        <!-- Dashboard Comercial -->
                                        <a href="<?= url('/comercial') ?>"
                                            class="submenu-item relative flex items-center justify-between gap-3 py-2.5 px-4 rounded-lg text-sm text-gray-600 hover:text-purple-700 transition-all duration-300 hover:bg-gradient-to-r hover:from-purple-50/80 hover:to-transparent group/item">
                                            <div class="flex items-center gap-3">
                                                <div
                                                    class="w-7 h-7 bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg flex items-center justify-center group-hover/item:scale-110 transition-all duration-300">
                                                    <i class="fas fa-tachometer-alt text-white text-xs"></i>
                                                </div>
                                                <span class="font-medium">
                                                    Dashboard
                                                </span>
                                            </div>
                                            <!-- Seta indicadora (visível apenas quando ativo) -->
                                            <i
                                                class="fas fa-chevron-right text-xs text-purple-500 opacity-0 group-hover/item:opacity-100 transition-opacity duration-300"></i>
                                        </a>



                                        <!-- Pedidos -->
                                        <a href="<?= url('/vendas') ?>"
                                            class="submenu-item relative flex items-center justify-between gap-3 py-2.5 px-4 rounded-lg text-sm text-gray-600 hover:text-purple-700 transition-all duration-300 hover:bg-gradient-to-r hover:from-purple-50/80 hover:to-transparent group/item">
                                            <div class="flex items-center gap-3">
                                                <div
                                                    class="w-7 h-7 bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg flex items-center justify-center group-hover/item:scale-110 transition-all duration-300">
                                                    <i class="fas fa-clipboard-list text-white text-xs"></i>
                                                </div>
                                                <span class="font-medium">
                                                    Pedidos
                                                </span>
                                            </div>
                                            <!-- Seta indicadora (visível apenas quando ativo) -->
                                            <i
                                                class="fas fa-chevron-right text-xs text-purple-500 opacity-0 group-hover/item:opacity-100 transition-opacity duration-300"></i>
                                        </a>

                                        <!-- Orçamentos -->
                                        <a href="<?= url('/orcamentos') ?>"
                                            class="submenu-item relative flex items-center justify-between gap-3 py-2.5 px-4 rounded-lg text-sm text-gray-600 hover:text-purple-700 transition-all duration-300 hover:bg-gradient-to-r hover:from-purple-50/80 hover:to-transparent group/item">
                                            <div class="flex items-center gap-3">
                                                <div
                                                    class="w-7 h-7 bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg flex items-center justify-center group-hover/item:scale-110 transition-all duration-300">
                                                    <i class="fas fa-file-contract text-white text-xs"></i>
                                                </div>
                                                <span class="font-medium">
                                                    Orçamentos
                                                </span>
                                            </div>
                                            <!-- Seta indicadora (visível apenas quando ativo) -->
                                            <i
                                                class="fas fa-chevron-right text-xs text-purple-500 opacity-0 group-hover/item:opacity-100 transition-opacity duration-300"></i>
                                        </a>

                                        <!-- Contratos -->
                                        <a href="<?= url('/contratos') ?>"
                                            class="submenu-item relative flex items-center justify-between gap-3 py-2.5 px-4 rounded-lg text-sm text-gray-600 hover:text-purple-700 transition-all duration-300 hover:bg-gradient-to-r hover:from-purple-50/80 hover:to-transparent group/item">
                                            <div class="flex items-center gap-3">
                                                <div
                                                    class="w-7 h-7 bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg flex items-center justify-center group-hover/item:scale-110 transition-all duration-300">
                                                    <i class="fas fa-file-signature text-white text-xs"></i>
                                                </div>
                                                <span class="font-medium">
                                                    Contratos
                                                </span>
                                            </div>
                                            <!-- Seta indicadora (visível apenas quando ativo) -->
                                            <i
                                                class="fas fa-chevron-right text-xs text-purple-500 opacity-0 group-hover/item:opacity-100 transition-opacity duration-300"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Configurações -->
                        <div class="space-y-1">
                            <button type="button"
                                class="sidebar-item relative flex items-center justify-between w-full px-4 py-3 rounded-xl hover:bg-gradient-to-r hover:from-gray-50 hover:to-transparent transition-all duration-300 group overflow-hidden"
                                data-menu="configuracoes">
                                <!-- Glow effect -->
                                <div
                                    class="absolute inset-0 bg-gradient-to-r from-gray-500/5 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                                </div>

                                <div class="flex items-center gap-3 relative">
                                    <div
                                        class="w-10 h-10 bg-gradient-to-br from-gray-600 to-gray-700 rounded-xl flex items-center justify-center shadow-lg shadow-gray-200/50 group-hover:shadow-gray-300/70">
                                        <i class="fas fa-cog text-white text-base"></i>
                                    </div>
                                    <div
                                        class="absolute -inset-1 bg-gradient-to-r from-gray-400/20 to-gray-300/10 rounded-xl blur-sm opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                                    </div>

                                    <span
                                        class="font-semibold text-gray-800 group-hover:text-gray-700 group-hover:translate-x-1 transition-all duration-300 relative">
                                        Configurações
                                        <span
                                            class="absolute -bottom-1 left-0 w-0 h-0.5 bg-gradient-to-r from-gray-600 to-gray-400 group-hover:w-full transition-all duration-500"></span>
                                    </span>
                                </div>

                                <i
                                    class="fas fa-chevron-down text-xs transition-all duration-500 text-gray-500 group-hover:text-gray-600 group-hover:rotate-180"></i>
                            </button>

                            <div class="submenu grid grid-rows-[0fr] transition-[grid-template-rows] duration-500 ease-[cubic-bezier(0.4,0,0.2,1)]"
                                data-submenu="configuracoes">
                                <div class="overflow-hidden">
                                    <div
                                        class="submenu-content ml-12 space-y-1 pt-1 opacity-0 -translate-y-2 transition-all duration-500">

                                        <!-- Dashboard Configurações -->
                                        <a href="<?= url('/configuracoes') ?>"
                                            class="submenu-item relative flex items-center justify-between gap-3 py-2.5 px-4 rounded-lg text-sm text-gray-600 hover:text-gray-700 transition-all duration-300 hover:bg-gradient-to-r hover:from-gray-50/80 hover:to-transparent group/item">
                                            <div class="flex items-center gap-3">
                                                <div
                                                    class="w-7 h-7 bg-gradient-to-br from-gray-500 to-gray-600 rounded-lg flex items-center justify-center group-hover/item:scale-110 transition-all duration-300">
                                                    <i class="fas fa-tachometer-alt text-white text-xs"></i>
                                                </div>
                                                <span class="font-medium">
                                                    Dashboard
                                                </span>
                                            </div>
                                            <!-- Seta indicadora (visível apenas quando ativo) -->
                                            <i
                                                class="fas fa-chevron-right text-xs text-gray-500 opacity-0 group-hover/item:opacity-100 transition-opacity duration-300"></i>
                                        </a>


                                        <!-- Usuários -->
                                        <a href="<?= url('/usuarios') ?>"
                                            class="submenu-item relative flex items-center justify-between gap-3 py-2.5 px-4 rounded-lg text-sm text-gray-600 hover:text-gray-700 transition-all duration-300 hover:bg-gradient-to-r hover:from-gray-50/80 hover:to-transparent group/item">
                                            <div class="flex items-center gap-3">
                                                <div
                                                    class="w-7 h-7 bg-gradient-to-br from-gray-500 to-gray-600 rounded-lg flex items-center justify-center group-hover/item:scale-110 transition-all duration-300">
                                                    <i class="fas fa-user-cog text-white text-xs"></i>
                                                </div>
                                                <span class="font-medium">
                                                    Usuários
                                                </span>
                                            </div>
                                            <!-- Seta indicadora (visível apenas quando ativo) -->
                                            <i
                                                class="fas fa-chevron-right text-xs text-gray-500 opacity-0 group-hover/item:opacity-100 transition-opacity duration-300"></i>
                                        </a>

                                        <!-- Permissões -->
                                        <a href="<?= url('/permissoes') ?>"
                                            class="submenu-item relative flex items-center justify-between gap-3 py-2.5 px-4 rounded-lg text-sm text-gray-600 hover:text-gray-700 transition-all duration-300 hover:bg-gradient-to-r hover:from-gray-50/80 hover:to-transparent group/item">
                                            <div class="flex items-center gap-3">
                                                <div
                                                    class="w-7 h-7 bg-gradient-to-br from-gray-500 to-gray-600 rounded-lg flex items-center justify-center group-hover/item:scale-110 transition-all duration-300">
                                                    <i class="fas fa-shield-alt text-white text-xs"></i>
                                                </div>
                                                <span class="font-medium">
                                                    Permissões
                                                </span>
                                            </div>
                                            <!-- Seta indicadora (visível apenas quando ativo) -->
                                            <i
                                                class="fas fa-chevron-right text-xs text-gray-500 opacity-0 group-hover/item:opacity-100 transition-opacity duration-300"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </nav>

                    <div class="absolute bottom-20 w-full px-4">
                        <a href="<?= url('/auth/logout') ?>"
                            class="flex items-center gap-3 px-4 py-3 rounded-xl text-red-600 hover:bg-red-50 transition-all group">
                            <div
                                class="w-8 h-8 bg-red-500 rounded-lg flex items-center justify-center shadow-md shadow-red-200">
                                <i class="fas fa-sign-out-alt text-white text-sm"></i>
                            </div>
                            <span class="font-medium text-sm">Sair do Sistema</span>
                        </a>
                    </div>

                    <div class="absolute bottom-0 w-full p-4 border-t border-blue-100/50 bg-white/50 backdrop-blur-sm">
                        <div class="flex justify-between text-[10px] text-gray-400 font-bold uppercase">
                            <span>v2.5</span>
                            <span class="text-green-500">Sistema Ativo</span>
                        </div>
                    </div>
                </aside>

                <main id="main-content" class="flex-1 p-4 lg:p-8 transition-all duration-300">
                    <?= $content ?? '' ?>
                </main>

            </div>
        </div>
    </div>

    <section rule="dialog">
        <div id="appDialog" class="dialog hidden">
            <div class="dialog-backdrop"></div>
            <div class="dialog-box" role="dialog" aria-modal="true">
                <div class="dialog-header">
                    <span class="dialog-title"></span>
                    <button type="button" class="dialog-close" aria-label="Fechar">&times;</button>
                </div>
                <div class="dialog-body">
                    <p class="dialog-message"></p>
                    <div class="dialog-input-wrapper"></div>
                </div>
                <div class="dialog-footer">
                    <button type="button" class="dialog-btn dialog-cancel">Cancelar</button>
                    <button type="button" class="dialog-btn dialog-approve">Confirmar</button>
                </div>
            </div>
        </div>
    </section>

    <section rule="modal">
        <div id="appModal" class="modal hidden">
            <div class="modal-backdrop"></div>
            <div class="modal-box">
                <div class="modal-header">
                    <h3 class="modal-title"></h3>
                    <button class="modal-close">&times;</button>
                </div>
                <div class="modal-body"></div>
                <div class="modal-footer">
                    <button class="modal-btn modal-cancel">Cancelar</button>
                    <button class="modal-btn modal-approve">Confirmar</button>
                </div>
            </div>
        </div>
    </section>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const currentPath = window.location.pathname.replace(/\/$/, '');
            const menuButtons = document.querySelectorAll('[data-menu]');
            const submenus = document.querySelectorAll('[data-submenu]');
            const submenuLinks = document.querySelectorAll('.submenu-item');

            // Fechar todos os submenus
            const closeAll = () => {
                submenus.forEach(sm => {
                    sm.classList.remove('grid-rows-[1fr]');
                    sm.classList.add('grid-rows-[0fr]');
                    const content = sm.querySelector('.submenu-content');
                    if (content) {
                        content.classList.remove('opacity-100', 'translate-y-0');
                        content.classList.add('opacity-0', '-translate-y-1');
                    }
                });
                menuButtons.forEach(btn => {
                    btn.querySelector('.fa-chevron-down')?.classList.remove('rotate-180');
                    btn.classList.remove('bg-blue-50');
                });
            };

            // Abrir submenu específico
            const openSubmenu = (name) => {
                const submenu = document.querySelector(`[data-submenu="${name}"]`);
                const button = document.querySelector(`[data-menu="${name}"]`);
                const content = submenu?.querySelector('.submenu-content');

                if (!submenu || !button || !content) return;

                submenu.classList.remove('grid-rows-[0fr]');
                submenu.classList.add('grid-rows-[1fr]');

                button.classList.add('bg-blue-50');
                button.querySelector('.fa-chevron-down')?.classList.add('rotate-180');

                // Transição suave de opacidade
                requestAnimationFrame(() => {
                    content.classList.remove('opacity-0', '-translate-y-1');
                    content.classList.add('opacity-100', 'translate-y-0');
                });
            };

            // Clique nos Menus Pai
            menuButtons.forEach(btn => {
                btn.addEventListener('click', () => {
                    const name = btn.dataset.menu;
                    const submenu = document.querySelector(`[data-submenu="${name}"]`);
                    const isOpen = submenu?.classList.contains('grid-rows-[1fr]');

                    closeAll();
                    if (!isOpen) openSubmenu(name);
                });
            });

            // Lógica de Ativação por URL
            submenuLinks.forEach(link => {
                const linkPath = new URL(link.href).pathname.replace(/\/$/, '');
                if (linkPath === currentPath) {
                    link.classList.add('bg-blue-100', 'text-blue-700', 'font-bold');
                    const parentMenu = link.closest('[data-submenu]');
                    if (parentMenu) {
                        openSubmenu(parentMenu.dataset.submenu);
                    }
                }
            });
        });
    </script>

    <script src="<?= BASE_URL ?>/public/assets/js/shared/dialog.js"></script>
    <script src="<?= BASE_URL ?>/public/assets/js/shared/modal.js"></script>
    <script src="<?= BASE_URL ?>/public/assets/js/shared/menu.js"></script>
    <script src="<?= BASE_URL ?>/public/assets/js/shared/validation.js"></script>

</body>

</html>