import { getConfig } from '../../shared/config.js'

export function init() {

    const form = document.getElementById('unidade-form')
    const toast = document.getElementById('toast')

    let AppConfig
    try {
        AppConfig = getConfig()
    } catch {
        return
    }

    const endpoints = AppConfig.apiEndpoints.unidadeMedida
    const csrfToken = AppConfig.csrfToken

    if (!form) return

    function showToast(message, isError = false) {
        if (!toast) return
        toast.textContent = message
        toast.style.backgroundColor = isError ? '#ef4444' : '#22c55e'
        toast.style.display = 'block'
        toast.style.opacity = 1
        setTimeout(() => {
            toast.style.opacity = 0
            setTimeout(() => (toast.style.display = 'none'), 400)
        }, 4000)
    }

    form.addEventListener('submit', async (e) => {
        e.preventDefault()

        const submitBtn = document.getElementById('submit-btn')
        const originalBtnText = submitBtn.innerHTML
        submitBtn.disabled = true
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Salvando...'

        const formData = new FormData(form)
        const data = Object.fromEntries(formData.entries())

        const id = data.unidade_medida_id
        const isUpdate = !!id
        const endpoint = isUpdate 
            ? `${endpoints.update}/${id}`
            : endpoints.create

        try {
            const response = await fetch(endpoint, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken
                },
                body: JSON.stringify(data)
            })

            const result = await response.json()

            if (result.success) {
                showToast(result.message)
                if (!isUpdate) {
                    form.reset()
                }
                
                setTimeout(() => {
                     const listUrl = endpoints.list.replace('/list', '')
                     window.location.href = listUrl;
                }, 1000);
                
            } else {
                showToast(result.message || 'Erro ao salvar.', true)
            }
        } catch (err) {
            console.error(err)
            showToast('Erro de conexão.', true)
        } finally {
            submitBtn.disabled = false
            submitBtn.innerHTML = originalBtnText
        }
    })
}
