import { loadConfig } from '../../shared/config.js'
import { init as initList } from './unidadeMedidaList.js'
import { init as initForm } from './unidadeMedidaForm.js'

document.addEventListener('DOMContentLoaded', async () => {
    try {
        await loadConfig('unidadeMedida')
        
        initList?.()
        initForm?.()

    } catch (err) {
        console.error(err)
        const dialog = document.getElementById('appDialog');
        if (dialog) {
            const footer = dialog.querySelector('.dialog-footer');
            dialog.dialog({
                title: 'Erro',
                message: 'Falha ao carregar recursos essenciais.',
                type: 'danger',
                onOpen: () => footer && (footer.style.display = 'none'),
                onClose: () => footer && (footer.style.display = '')
            });
        }
    }
})
