document.addEventListener('DOMContentLoaded', function() {
    const passwordInput = document.getElementById('password');
    const passwordToggle = document.querySelector('.password-toggle');

    if (passwordToggle && passwordInput) {
        passwordToggle.addEventListener('click', function() {
            // Toggle the type attribute
            const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordInput.setAttribute('type', type);
            
            // Toggle the eye icon
            const icon = this.querySelector('i');
            icon.classList.toggle('fa-eye');
            icon.classList.toggle('fa-eye-slash');
        });
    }

    // Since the new design uses floating labels, we just need to make sure
    // the server-side validation error is visible if it exists.
    // The form submission will be handled by the browser and PHP backend.
    const form = document.querySelector('.login-form');
    const emailInput = document.getElementById('email');

    // Autofocus the email field if it's empty
    if(emailInput && emailInput.value === '') {
        emailInput.focus();
    }
});