import { loadConfig } from '../shared/config.js'
import { init as initList } from './planodecontasList.js'
import { init as initForm } from './planodecontasForm.js'

document.addEventListener('DOMContentLoaded', async () => {
    try {
        await loadConfig('planoDeContas')

        // Inicializa somente o que existir na página
        initList?.()
        initForm?.()

    } catch (err) {
        console.error(err)
        const dialog = document.getElementById('appDialog');
        if (dialog) {
            const footer = dialog.querySelector('.dialog-footer');
            dialog.dialog({
                title: 'Erro',
                message: 'Falha ao carregar recursos essenciais.',
                type: 'danger',
                onOpen: () => footer && (footer.style.display = 'none'),
                onClose: () => footer && (footer.style.display = '')
            });
        } else {
            alert('Falha ao carregar recursos essenciais.');
        }
    }
})