let AppConfig = { apiEndpoints: {} };
let loadingPromises = {};

function getBaseUrl() {
    const baseUrl = document.body.dataset.baseUrl;
    if (!baseUrl) {
        console.error('data-base-url not found on body');
        return window.location.origin;
    }
    return baseUrl;
}

export async function loadConfig(modulo) {
    if (loadingPromises[modulo]) return loadingPromises[modulo];

    loadingPromises[modulo] = (async () => {
        const baseUrl = getBaseUrl();
        const configUrl = `${baseUrl}/Config?module=${modulo}`;
        const response = await fetch(configUrl);

        if (!response.ok) {
            delete loadingPromises[modulo];
            throw new Error(`Erro ao carregar config para ${modulo}`);
        }

        const moduleConfig = await response.json();

        // Set global fields if not already set
        if (!AppConfig.baseUrl) AppConfig.baseUrl = moduleConfig.baseUrl;
        if (!AppConfig.csrfToken) AppConfig.csrfToken = moduleConfig.csrfToken;

        // Merge endpoints
        AppConfig.apiEndpoints = {
            ...AppConfig.apiEndpoints,
            ...moduleConfig.apiEndpoints
        };
    })();

    return loadingPromises[modulo];
}

export function getConfig() {
    if (Object.keys(AppConfig).length === 0 || Object.keys(AppConfig.apiEndpoints).length === 0) {
        throw new Error('Config não carregado. Chame loadConfig() primeiro.');
    }
    return AppConfig;
}

