document.addEventListener('DOMContentLoaded', function () {
    // Variáveis principais
    let isCollapsed = false;
    const sidebar = document.getElementById('sidebar');
    const toggleButton = document.getElementById('toggle-sidebar');
    const toggleIcon = document.getElementById('toggle-icon');
    const toggleTooltip = document.getElementById('toggle-tooltip');
    const mainContent = document.getElementById('main-content');

    // Função para atualizar texto baseado no tamanho da tela
    function updateTextForScreenSize() {
        const isMobile = window.innerWidth < 1024;

        // Elementos de texto
        const contasText = document.getElementById('contas-text');
        const separatorText = document.getElementById('separator-text');
        const userRoleSpans = document.querySelectorAll('#user-info p span:last-child');

        if (isMobile) {
            // Atualizar textos para mobile
            if (contasText) contasText.textContent = 'Contas';
            if (separatorText) separatorText.textContent = 'Mais';

            userRoleSpans.forEach(span => {
                if (span.textContent.includes('Administrador')) {
                    span.textContent = 'Admin';
                }
            });
        } else {
            // Atualizar textos para desktop
            if (contasText) contasText.textContent = 'Contas Bancárias';
            if (separatorText) separatorText.textContent = 'Outros Módulos';

            userRoleSpans.forEach(span => {
                if (span.textContent === 'Admin') {
                    span.textContent = 'Administrador Financeiro';
                }
            });
        }
    }

    // Função para alternar classes de elemento
    function toggleClasses(element, addClasses = [], removeClasses = []) {
        if (element) {
            if (removeClasses.length > 0) {
                element.classList.remove(...removeClasses);
            }
            if (addClasses.length > 0) {
                element.classList.add(...addClasses);
            }
        }
    }

    // Toggle sidebar functionality
    if (toggleButton) {
        toggleButton.addEventListener('click', function () {
            isCollapsed = !isCollapsed;

            if (isCollapsed) {
                // Colapsar sidebar
                toggleClasses(sidebar, ['w-16'], ['w-72']);

                // Rotacionar ícone
                if (toggleIcon) {
                    toggleIcon.style.transform = 'rotate(180deg)';
                }
                if (toggleTooltip) {
                    toggleTooltip.textContent = 'Expandir menu';
                }

                // Esconder elementos de texto
                const textElements = document.querySelectorAll(
                    '#logo-text, #user-info, #separator-text, #home-text, #clientes-text, #fornecedores-text, #contas-text, #additional-menu span'
                );
                textElements.forEach(el => {
                    toggleClasses(el, ['opacity-0', 'w-0', 'overflow-hidden', 'scale-0']);
                });

                // Esconder badges
                const badges = document.querySelectorAll(
                    '#home-badge, #clientes-badge, #fornecedores-badge, #contas-badge'
                );
                badges.forEach(el => {
                    toggleClasses(el, ['opacity-0', 'w-0', 'overflow-hidden', 'scale-0']);
                });

                // Esconder linhas do separador
                const separatorLines = document.querySelectorAll('#separator .flex-1');
                separatorLines.forEach(el => {
                    toggleClasses(el, ['opacity-0']);
                });

                // Esconder rodapé de estatísticas
                const statsFooter = document.getElementById('stats-footer');
                if (statsFooter) {
                    toggleClasses(statsFooter, ['opacity-0', 'h-0', 'overflow-hidden', 'p-0', 'scale-0'], ['p-3', 'lg:p-5']);
                }

                // Expandir conteúdo principal
                toggleClasses(mainContent, ['lg:ml-16'], ['lg:ml-0']);

            } else {
                // Expandir sidebar
                toggleClasses(sidebar, ['w-72'], ['w-16']);

                // Rotacionar ícone de volta
                if (toggleIcon) {
                    toggleIcon.style.transform = 'rotate(0deg)';
                }
                if (toggleTooltip) {
                    toggleTooltip.textContent = 'Recolher menu';
                }

                // Mostrar elementos de texto
                const textElements = document.querySelectorAll(
                    '#logo-text, #user-info, #separator-text, #home-text, #clientes-text, #fornecedores-text, #contas-text, #additional-menu span'
                );
                textElements.forEach(el => {
                    toggleClasses(el, [], ['opacity-0', 'w-0', 'overflow-hidden', 'scale-0']);
                });

                // Mostrar badges
                const badges = document.querySelectorAll(
                    '#home-badge, #clientes-badge, #fornecedores-badge, #contas-badge'
                );
                badges.forEach(el => {
                    toggleClasses(el, [], ['opacity-0', 'w-0', 'overflow-hidden', 'scale-0']);
                });

                // Mostrar linhas do separador
                const separatorLines = document.querySelectorAll('#separator .flex-1');
                separatorLines.forEach(el => {
                    toggleClasses(el, [], ['opacity-0']);
                });

                // Mostrar rodapé de estatísticas
                const statsFooter = document.getElementById('stats-footer');
                if (statsFooter) {
                    toggleClasses(statsFooter, ['p-3', 'lg:p-5'], ['opacity-0', 'h-0', 'overflow-hidden', 'p-0', 'scale-0']);
                }

                // Resetar conteúdo principal
                toggleClasses(mainContent, [], ['lg:ml-16']);

                // Atualizar textos baseado no tamanho da tela
                updateTextForScreenSize();
            }
        });
    }

    // Interação com itens do menu
    const sidebarItems = document.querySelectorAll('.sidebar-item');
    sidebarItems.forEach(item => {
        item.addEventListener('click', function (e) {
            // Remover classe active de todos os itens
            sidebarItems.forEach(el => {
                el.classList.remove('active-item');
            });

            // Adicionar classe active ao item clicado
            this.classList.add('active-item');
        });
    });

    // Atualizar textos no redimensionamento
    window.addEventListener('resize', function () {
        if (!isCollapsed) {
            updateTextForScreenSize();
        }
    });

    // Configuração inicial
    updateTextForScreenSize();

    // Animar pontos de notificação
    const notificationDots = document.querySelectorAll('.notification-dot');
    notificationDots.forEach((dot, index) => {
        dot.style.animationDelay = (index * 0.5) + 's';
    });

    // Ajustes responsivos - auto colapsar em telas muito pequenas
    function handleResize() {
        const windowWidth = window.innerWidth;

        if (toggleButton) {
            if (windowWidth < 1024 && !isCollapsed) {
                // Auto-colapsar em telas pequenas
                toggleButton.click();
            } else if (windowWidth >= 1024 && isCollapsed) {
                // Auto-expandir em telas maiores
                toggleButton.click();
            }
        }
    }

    // Verificar no carregamento
    window.addEventListener('load', handleResize);

    // Verificar no redimensionamento
    window.addEventListener('resize', handleResize);

    // Adicionar tooltips em elementos que precisam
    const tooltipElements = document.querySelectorAll('[data-toggle="tooltip"]');
    tooltipElements.forEach(element => {
        const tooltipText = element.getAttribute('data-tooltip');

        if (tooltipText) {
            element.addEventListener('mouseenter', function () {
                const tooltip = document.createElement('div');
                tooltip.className = 'tooltip absolute bg-gray-900 text-white px-2 py-1 rounded text-xs z-50';
                tooltip.textContent = tooltipText;
                document.body.appendChild(tooltip);

                const rect = this.getBoundingClientRect();
                tooltip.style.top = (rect.top - 30 + window.scrollY) + 'px';
                tooltip.style.left = (rect.left + (rect.width / 2) - 50 + window.scrollX) + 'px';

                // Guardar referência para remover depois
                element.tooltip = tooltip;
            });

            element.addEventListener('mouseleave', function () {
                if (this.tooltip) {
                    this.tooltip.remove();
                    this.tooltip = null;
                }
            });
        }
    });

    // Efeito de hover nos cards de estatísticas
    const gradientCards = document.querySelectorAll('.bg-gradient-to-br');
    gradientCards.forEach(card => {
        card.addEventListener('mouseenter', function () {
            this.classList.add('transform', 'scale-[1.00]', 'transition-transform', 'duration-200');
        });

        card.addEventListener('mouseleave', function () {
            this.classList.remove('transform', 'scale-[1.00]');
        });
    });

    // Atualizar horário em tempo real
    function updateClock() {
        const now = new Date();
        const timeString = now.toLocaleTimeString('pt-BR', {
            hour: '2-digit',
            minute: '2-digit'
        });

        // Criar ou atualizar elemento do relógio
        let liveClock = document.getElementById('live-clock');
        if (!liveClock) {
            liveClock = document.createElement('div');
            liveClock.id = 'live-clock';
            liveClock.className = 'fixed bottom-4 right-4 text-xs text-gray-500 bg-white/80 px-3 py-1 rounded-full shadow-sm hidden lg:block';
            document.body.appendChild(liveClock);
        }
        liveClock.textContent = timeString;
    }

    // Atualizar relógio a cada minuto
    updateClock();
    setInterval(updateClock, 60000);

    // Suporte para múltiplos elementos com mesma classe (para remover classes)
    NodeList.prototype.removeClasses = function (classNames) {
        this.forEach(element => {
            classNames.split(' ').forEach(className => {
                element.classList.remove(className);
            });
        });
    };

    // Suporte para múltiplos elementos com mesma classe (para adicionar classes)
    NodeList.prototype.addClasses = function (classNames) {
        this.forEach(element => {
            classNames.split(' ').forEach(className => {
                element.classList.add(className);
            });
        });
    };

});
