(function () {
    HTMLElement.prototype.modal = function (options = {}) {
        const modal = this

        const {
            title = '',
            content = '',
            size = 'medium',
            type = '',
            showFooter = true,
            onOpen,
            onClose,
            onApprove,
            onCancel
        } = options

        const box = modal.querySelector('.modal-box')
        const header = modal.querySelector('.modal-header')
        const titleEl = modal.querySelector('.modal-title')
        const body = modal.querySelector('.modal-body')
        const footer = modal.querySelector('.modal-footer')
        const btnClose = modal.querySelector('.modal-close')
        const btnCancel = modal.querySelector('.modal-cancel')
        const btnApprove = modal.querySelector('.modal-approve')
        const backdrop = modal.querySelector('.modal-backdrop')

        // reset classes
        modal.className = 'modal'
        modal.classList.add(size)
        if (type) modal.classList.add(type)

        // title
        titleEl.textContent = title

        // content
        body.innerHTML = ''
        if (content instanceof HTMLElement) {
            body.appendChild(content)
        } else {
            body.textContent = content
        }

        // footer
        footer.style.display = showFooter ? 'flex' : 'none'

        function close() {
            modal.classList.add('hidden')
            document.removeEventListener('keydown', escHandler)
            onClose && onClose()
        }

        function escHandler(e) {
            if (e.key === 'Escape') {
                onCancel && onCancel()
                close()
            }
        }

        btnClose.onclick = () => {
            onCancel && onCancel()
            close()
        }

        btnCancel.onclick = () => {
            onCancel && onCancel()
            close()
        }

        btnApprove.onclick = () => {
            onApprove && onApprove()
            close()
        }

        backdrop.onclick = () => {
            onCancel && onCancel()
            close()
        }

        modal.classList.remove('hidden')
        document.addEventListener('keydown', escHandler)

        onOpen && onOpen()
    }
})()
