document.addEventListener('DOMContentLoaded', function () {

    // Validação em tempo real
    const inputs = document.querySelectorAll('#fornecedor-form input, #fornecedor-form select');
    inputs.forEach(input => {
        input.addEventListener('blur', function () {
            if (this.hasAttribute('required') && !this.value.trim()) {
                this.classList.add('border-red-500', 'ring-2', 'ring-red-500/30');
            } else if (this.type === 'email' && this.value && !this.value.match(/^[^\s@]+@[^\s@]+\.[^\s@]+$/)) {
                this.classList.add('border-red-500', 'ring-2', 'ring-red-500/30');
            } else {
                this.classList.remove('border-red-500', 'ring-2', 'ring-red-500/30');
            }
        });
    });

    // Ajustar labels para campos preenchidos
    const filledInputs = document.querySelectorAll('#fornecedor-form input:not(:placeholder-shown)');
    filledInputs.forEach(input => {
        const label = input.nextElementSibling;
        if (label && label.tagName === 'LABEL') {
            label.classList.add('-translate-y-3', 'scale-90');
        }
    });
});