CREATE TABLE IF NOT EXISTS cliente (
    cliente_id INT AUTO_INCREMENT PRIMARY KEY,
    cliente_nome VARCHAR(255) NOT NULL,
    cliente_telefone VARCHAR(20),
    cliente_cpf VARCHAR(14) UNIQUE,
    cliente_endereco TEXT,
    cliente_limiteCredito DECIMAL(10, 2),
    cliente_criadoEm TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    cliente_alteradoEm TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS fornecedor (
    fornecedor_id INT AUTO_INCREMENT PRIMARY KEY,
    fornecedor_nome VARCHAR(255) NOT NULL,
    fornecedor_cnpj VARCHAR(18) NOT NULL,
    fornecedor_email VARCHAR(255),
    fornecedor_telefone VARCHAR(20),
    fornecedor_endereco VARCHAR(255),
    fornecedor_cidade VARCHAR(100),
    fornecedor_estado CHAR(2),
    fornecedor_limiteCredito DECIMAL(10, 2) DEFAULT 0.00,
    fornecedor_ativo TINYINT(1) DEFAULT 1,
    fornecedor_criadoEm TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    fornecedor_alteradoEm TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

CREATE TABLE conta_bancaria (
    conta_bancaria_id INT AUTO_INCREMENT PRIMARY KEY,
    conta_bancaria_nome_banco VARCHAR(100) NOT NULL,
    conta_bancaria_codigoBanco CHAR(3) NOT NULL,
    -- ex: 001, 237, 341
    conta_bancaria_agencia VARCHAR(10) NOT NULL,
    conta_bancaria_digitoAgencia VARCHAR(2),
    conta_bancaria_conta VARCHAR(20) NOT NULL,
    conta_bancaria_digitoConta VARCHAR(2),
    conta_bancaria_tipo ENUM(
        'corrente',
        'poupanca',
        'salario',
        'investimento'
    ) NOT NULL DEFAULT 'corrente',
    conta_bancaria_titular VARCHAR(255) NOT NULL,
    conta_bancaria_cpfCnpj VARCHAR(18) NOT NULL,
    conta_bancaria_saldoInicial DECIMAL(15, 2) DEFAULT 0.00,
    conta_bancaria_ativa TINYINT(1) DEFAULT 1,
    conta_bancaria_observacao TEXT,
    conta_bancaria_criadoEm TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    conta_bancaria_alteradoEm TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- -- MySQL Workbench Synchronization
-- -- Generated: 2025-12-22 13:07
-- -- Model: New Model
-- -- Version: 1.0
-- -- Project: Name of the project
-- -- Author: ROMDEV-01
-- SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
-- SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
-- SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION';
-- USE appfinanceiro;
-- CREATE TABLE IF NOT EXISTS cliente (
--   `cliente_id` INT NOT NULL AUTO_INCREMENT,
--   `cliente_nome` VARCHAR(255),
--   `cliente_telefone` VARCHAR(20),
--   `cliente_cpf` VARCHAR(14),
--   `cliente_endereco` TEXT,
--   `cliente_limiteCredito` DECIMAL(10,2),
--   `cliente_criadoEm` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
--   `cliente_alteradoEm` TIMESTAMP NOT NULL
--     DEFAULT CURRENT_TIMESTAMP
--     ON UPDATE CURRENT_TIMESTAMP,
--   PRIMARY KEY (cliente_id),
--   UNIQUE KEY cliente_cpf_UNIQUE (cliente_cpf)
-- ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- CREATE TABLE IF NOT EXISTS fornecedor (
--   `fornecedor_id` INT NOT NULL AUTO_INCREMENT,
--   `fornecedor_nome` VARCHAR(255) NOT NULL,
--   `fornecedor_cnpj` VARCHAR(25) NOT NULL,
--   `fornecedor_email` VARCHAR(255) NOT NULL,
--   `fornecedor_telefone` VARCHAR(20) NULL,
--   `fornecedor_status` ENUM('Ativo','Inativo')
--     NOT NULL DEFAULT 'Ativo',
--   `fornecedor_criadoEm` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
--   `fornecedor_alteradoEm` TIMESTAMP
--     DEFAULT CURRENT_TIMESTAMP
--     ON UPDATE CURRENT_TIMESTAMP,
--   PRIMARY KEY (fornecedor_id)
-- ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- CREATE TABLE IF NOT EXISTS conta_bancaria (
--   `conta_bancaria_id` INT NOT NULL AUTO_INCREMENT,
--   `conta_bancaria_nome` VARCHAR(255),
--   `conta_bancaria_conta` VARCHAR(25),
--   `conta_bancaria_tipo` ENUM('corrente','poupanca','salario','investimento')
--     NOT NULL DEFAULT 'corrente',
--   `conta_bancaria_titular` VARCHAR(255),
--   `conta_bancaria_status` ENUM('Ativa','Inativa') DEFAULT 'Ativa',
--   `conta_bancaria_observacao` TEXT,
--   `conta_bancaria_criadoEm` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
--   `conta_bancaria_alteradoEm` TIMESTAMP
--     DEFAULT CURRENT_TIMESTAMP
--     ON UPDATE CURRENT_TIMESTAMP,
--   PRIMARY KEY (conta_bancaria_id)
-- ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- SET SQL_MODE=@OLD_SQL_MODE;
-- SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
-- SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;
CREATE TABLE IF NOT EXISTS plano_de_conta (
    plano_conta_id INT AUTO_INCREMENT PRIMARY KEY,
    plano_conta_descricao VARCHAR(255) NOT NULL,
    plano_conta_status ENUM('Ativo', 'Inativo') DEFAULT 'Ativo',
    plano_conta_criadoEm TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    plano_conta_alteradoEm TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    plano_conta_codigo VARCHAR(255),
    plano_conta_tipo_conta ENUM('receita', 'despesa'),
    plano_conta_contabil VARCHAR(255)
);

CREATE TABLE IF NOT EXISTS conta_pagar (
    conta_pagar_id INT AUTO_INCREMENT PRIMARY KEY,
    conta_pagar_valor DECIMAL(10, 2) NOT NULL,
    conta_pagar_vencimento DATE NOT NULL,
    conta_pagar_plano_contas INT,
    conta_pagar_descricao VARCHAR(255),
    conta_pagar_status ENUM('pendente', 'pago', 'atrasado') DEFAULT 'pendente',
    conta_pagar_data_pagamento DATE,
    conta_pagar_fornecedor INT,
    conta_pagar_criadoEm TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    conta_pagar_atualizadoEm TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (conta_pagar_plano_contas) REFERENCES plano_conta(plano_conta_id),
    FOREIGN KEY (conta_pagar_fornecedor) REFERENCES fornecedor(fornecedor_id)
);

CREATE TABLE IF NOT EXISTS conta_receber (
    conta_receber_id INT AUTO_INCREMENT PRIMARY KEY,
    conta_receber_valor DECIMAL(10, 2) NOT NULL,
    conta_receber_vencimento DATE NOT NULL,
    conta_receber_plano_contas INT,
    conta_receber_descricao VARCHAR(255),
    conta_receber_status ENUM('pendente', 'pago', 'atrasado') DEFAULT 'pendente',
    conta_receber_data_pagamento DATE,
    conta_receber_cliente INT,
    conta_receber_criadoEm TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    conta_receber_atualizadoEm TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (conta_receber_plano_contas) REFERENCES plano_conta(plano_conta_id),
    FOREIGN KEY (conta_receber_cliente) REFERENCES cliente(cliente_id)
);