<?php

namespace Modules\Mercado\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;
use Modules\LandingPage\Entities\MarketplacePageSetting;

class MarketPlaceSeederTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard();

        $data['product_main_banner'] = '';
        $data['product_main_status'] = 'on';
        $data['product_main_heading'] = 'Mercado';
        $data['product_main_description'] = '<p>Mercado Pago is an online payment platform that allows Zoho Invoice users to receive and process payments quickly and securely. Once you share the invoice link with your customer, they can make payments through multiple payment modes such as debit/credit cards, cash, and red link transfers.</p>';
        $data['product_main_demo_link'] = '#';
        $data['product_main_demo_button_text'] = 'View Live Demo';
        $data['dedicated_theme_heading'] = '<h2>Mercado<b> Payment</b> Getway</h2>';
        $data['dedicated_theme_description'] = '<p>Mercado is an online payment processing and credit card processing platform for businesses.</p>';
        $data['dedicated_theme_sections'] = '[{"dedicated_theme_section_image":"","dedicated_theme_section_heading":"Why use Mercado Pago","dedicated_theme_section_description":"<p>Mercado Pago allows customers to use the own currencies of latin american countries as part of a payment, without the need to make the conversion to dollars or euros known by the multiple world processes. Within this system, the customer can make payments through credit cards, bank transfer, balance from their account, and even within the Mercado Pago portal itself.<\/p>","dedicated_theme_section_cards":{"1":{"title":null,"description":null}}},{"dedicated_theme_section_image":"","dedicated_theme_section_heading":"Benefits of using Mercado Pago","dedicated_theme_section_description":"<p>You can use or transfer the money any time you want. It’s automatic, you only need to activate it once and never take more actions. The use of QR codes allows your customers to select this payment method at checkout in most businesses. Additionally, there’s a mobile app available for iOS and Android operating systems, allowing for cutting edge technology in a contactless form.<\/p>","dedicated_theme_section_cards":{"1":{"title":null,"description":null}}}]';
        $data['dedicated_theme_sections_heading'] = '';
        $data['screenshots'] = '[{"screenshots":"","screenshots_heading":"Mercado"},{"screenshots":"","screenshots_heading":"Mercado"},{"screenshots":"","screenshots_heading":"Mercado"},{"screenshots":"","screenshots_heading":"Mercado"},{"screenshots":"","screenshots_heading":"Mercado"}]';
        $data['addon_heading'] = '<h2>Why choose dedicated modules<b> for Your Business?</b></h2>';
        $data['addon_description'] = '<p>With Dash, you can conveniently manage all your business functions from a single location.</p>';
        $data['addon_section_status'] = 'on';
        $data['whychoose_heading'] = 'Why choose dedicated modulesfor Your Business?';
        $data['whychoose_description'] = '<p>With Dash, you can conveniently manage all your business functions from a single location.</p>';
        $data['pricing_plan_heading'] = 'Empower Your Workforce with DASH';
        $data['pricing_plan_description'] = '<p>Access over Premium Add-ons for Accounting, HR, Payments, Leads, Communication, Management, and more, all in one place!</p>';
        $data['pricing_plan_demo_link'] = '#';
        $data['pricing_plan_demo_button_text'] = 'View Live Demo';
        $data['pricing_plan_text'] = '{"1":{"title":"Pay-as-you-go"},"2":{"title":"Unlimited installation"},"3":{"title":"Secure cloud storage"}}';
        $data['whychoose_sections_status'] = 'on';
        $data['dedicated_theme_section_status'] = 'on';

        foreach($data as $key => $value){
            if(!MarketplacePageSetting::where('name', '=', $key)->where('module', '=', 'Mercado')->exists()){
                MarketplacePageSetting::updateOrCreate(
                [
                    'name' => $key,
                    'module' => 'Mercado'

                ],
                [
                    'value' => $value
                ]);
            }
        }
    }
}
