<?php

namespace Modules\Mercado\Http\Controllers;

use App\Models\Order;
use App\Models\Plan;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Rawilk\Settings\Support\Context;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Exception;
use Illuminate\Support\Facades\Session;
use LivePixel\MercadoPago\MP;
use Modules\Mercado\Events\MercadoPaymentStatus;

class MercadoController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public $token;
    public $is_enabled;
    public $currancy;
    public $mode;

    public function setting(Request $request)
    {

        if(Auth::user()->can('mercado manage'))
        {
            if($request->has('mercado_payment_is_on'))
            {
                $validator = Validator::make($request->all(),
                [
                    'company_mercado_mode' => 'required|string',
                    'company_mercado_access_token' => 'required|string',
                ]);

                if($validator->fails()){
                    $messages = $validator->getMessageBag();

                    return redirect()->back()->with('error', $messages->first());
                }
            }
            $userContext = new Context(['user_id' => Auth::user()->id,'workspace_id'=>getActiveWorkSpace()]);
            if($request->has('mercado_payment_is_on')){
                \Settings::context($userContext)->set('company_mercado_mode', $request->company_mercado_mode);
                \Settings::context($userContext)->set('company_mercado_access_token', $request->company_mercado_access_token);
                \Settings::context($userContext)->set('mercado_payment_is_on', 'on');
            }else{
                \Settings::context($userContext)->set('mercado_payment_is_on', 'off');
            }
            return redirect()->back()->with('success','Mercado Payment Setting save successfully.');
        }
        else
        {
            return redirect()->back()->with('error', __('Permission denied.'));
        }
    }

    public function payment_setting($id=null,$workspace=Null)
    {
        if (!empty($id) && empty($workspace)){
            $this->currancy = !empty(company_setting('defult_currancy',$id)) ? company_setting('defult_currancy',$id) : '$';
            $this->token = !empty(company_setting('company_mercado_access_token',$id)) ? company_setting('company_mercado_access_token',$id) : '';
            $this->mode = !empty(company_setting('company_mercado_mode',$id)) ? company_setting('company_mercado_mode',$id) : '';
            $this->is_enabled = !empty(company_setting('mercado_payment_is_on',$id)) ? company_setting('mercado_payment_is_on',$id) : 'off';
        }
        elseif(!empty($id) && !empty($workspace)){
            $this->currancy = !empty(company_setting('defult_currancy',$id,$workspace)) ? company_setting('defult_currancy',$id,$workspace) : '$';
            $this->token = !empty(company_setting('company_mercado_access_token',$id,$workspace)) ? company_setting('company_mercado_access_token',$id,$workspace) : '';
            $this->mode = !empty(company_setting('company_mercado_mode',$id,$workspace)) ? company_setting('company_mercado_mode',$id,$workspace) : '';
            $this->is_enabled = !empty(company_setting('mercado_payment_is_on',$id,$workspace)) ? company_setting('mercado_payment_is_on',$id,$workspace) : 'off';
        }
        else{
            $this->currancy = !empty(company_setting('defult_currancy')) ? company_setting('defult_currancy') : '$';
            $this->token = !empty(company_setting('company_mercado_access_token')) ? company_setting('company_mercado_access_token') : '';
            $this->mode = !empty(company_setting('company_mercado_mode')) ? company_setting('company_mercado_mode') : '';
            $this->is_enabled = !empty(company_setting('mercado_payment_is_on')) ? company_setting('mercado_payment_is_on') : 'off';
        }
    }

    public function invoicePayWithMercado(Request $request)
    {
        $validatorArray = [
            'amount' => 'required',
            'invoice_id' => 'required',
        ];
        $validator      = Validator::make(
            $request->all(),
            $validatorArray
        )->setAttributeNames(
            ['invoice_id' => 'Invoice']
        );

        $invoiceID = $request->invoice_id;

        if($request->type == 'invoice')
        {
            $invoice   = \App\Models\Invoice::find($invoiceID);
            $user_id        = $invoice->created_by;
            $workspace = $invoice->workspace;
        }
        elseif($request->type == 'salesinvoice')
        {
            $invoice   = \Modules\Sales\Entities\SalesInvoice::find($invoiceID);
            $user_id        = $invoice->created_by;
            $workspace = $invoice->workspace;
        } elseif($request->type == 'retainer')
        {
            $invoice   = \Modules\Retainer\Entities\Retainer::find($invoiceID);
            $user_id        = $invoice->created_by;
            $workspace = $invoice->workspace;
        }


        if ($validator->fails()) {
            return redirect()->back()->with('error', __($validator->errors()->first()));
        }

        if (Auth::check()) {
            $user = Auth::user();
        } else {
            $user = User::find($user_id);
        }

        self::payment_setting($user_id,$workspace);

        if ($invoice->getDue() < $request->amount) {
            return redirect()->back()->with('error', 'not correct amount');
        }

        $preference_data = array(
            "items" => array(
                array(
                    "title" => "Invoice : " . $request->invoice_id,
                    "quantity" => 1,
                    "currency_id" => $this->currancy,
                    "unit_price" => (float)$request->amount,
                ),
            ),
        );
        try{
            \MercadoPago\SDK::setAccessToken($this->token);
        }catch(Exception $e){
            return redirect()->back()->with('error', $e->getMessage());
        }
        $users = User::where('id', $user_id)->where('workspace_id',$workspace)->first();
        if($users)
        {
            try {
                // Create a preference object
                $preference = new \MercadoPago\Preference();
                // Create an item in the preference
                $item = new \MercadoPago\Item();
                $item->title = "Invoice : " . $request->invoice_id;
                $item->quantity = 1;
                $item->unit_price = (float)$request->amount;
                $preference->items = array($item);
                $success_url = route('invoice.mercado', [encrypt($invoice->id), 'amount' => (float)$request->amount, 'flag' => 'success',$request->type]);
                $failure_url = route('invoice.mercado', [encrypt($invoice->id), 'flag' => 'failure',$request->type]);
                $pending_url = route('invoice.mercado', [encrypt($invoice->id), 'flag' => 'pending',$request->type]);
                $preference->back_urls = array(
                    "success" => $success_url,
                    "failure" => $failure_url,
                    "pending" => $pending_url
                );

                $preference->auto_return = "approved";
                $preference->save();

                // Create a customer object
                $payer = new \MercadoPago\Payer();
                // Create payer information
                $payer->name = Auth::check() ? Auth::user()->name : $users->name;
                $payer->email = Auth::check() ? Auth::user()->email : $users->email;
                $payer->address = array(
                    "street_name" => ''
                );

                if ($this->mode == 'live') {
                    $redirectUrl = $preference->init_point;
                } else {
                    $redirectUrl = $preference->sandbox_init_point;
                }
                return redirect($redirectUrl);
            } catch (\Throwable $th) {
                return redirect()->back()->with('error',$th->getMessage());
            }
        }
        return redirect()->back()->with('error', 'User Not Found');
    }

    public function getInvoicePaymentStatus($invoice_id, Request $request,$type)
    {
        if (!empty($invoice_id)) {

            $invoice_id = decrypt($invoice_id);
            if($type == 'invoice')
            {
                $invoice    = \App\Models\Invoice::find($invoice_id);
                $orderID = strtoupper(str_replace('.', '', uniqid('', true)));
                if ($invoice && $request->has('status')) {
                    try {

                        if ($request->status == 'approved' && $request->flag == 'success') {
                            $invoice_payment                 = new \App\Models\InvoicePayment();
                            $invoice_payment->invoice_id     = $invoice_id;
                            $invoice_payment->date           = Date('Y-m-d');
                            $invoice_payment->account_id     = 0;
                            $invoice_payment->payment_method = 0;
                            $invoice_payment->amount         = $request->has('amount') ? $request->amount : 0;
                            $invoice_payment->order_id       = $orderID;
                            $invoice_payment->payment_type = 'Mercado Pago';
                            $invoice_payment->save();
                            $due     = $invoice->getDue();
                            if ($due <= 0) {
                                $invoice->status = 4;
                                $invoice->save();
                            } else {
                                $invoice->status = 3;
                                $invoice->save();
                            }

                            event(new MercadoPaymentStatus($invoice,$type,$invoice_payment));

                            return redirect()->route('pay.invoice', \Illuminate\Support\Facades\Crypt::encrypt($invoice_id))->with('success', __('Invoice paid Successfully!'));
                        } else {

                            return redirect()->route('pay.invoice', \Illuminate\Support\Facades\Crypt::encrypt($invoice_id))->with('success', __('Transaction fail'));
                        }
                    } catch (\Exception $e) {

                        return redirect()->route('pay.invoice', \Illuminate\Support\Facades\Crypt::encrypt($invoice_id))->with('success', $e->getMessage());
                    }
                } else {

                    return redirect()->route('pay.invoice', \Illuminate\Support\Facades\Crypt::encrypt($invoice_id))->with('success', __('Invoice not found.'));
                }

            }
            elseif($type == 'salesinvoice')
            {
                $salesinvoice  = \Modules\Sales\Entities\SalesInvoice::find($invoice_id);
                if ($salesinvoice && $request->has('status')) {
                    try {

                        if ($request->status == 'approved' && $request->flag == 'success') {
                            $salesinvoice_payment                 = new \Modules\Sales\Entities\SalesInvoicePayment();
                            $salesinvoice_payment->invoice_id     = $invoice_id;
                            $salesinvoice_payment->transaction_id = app('Modules\Sales\Http\Controllers\SalesInvoiceController')->transactionNumber($salesinvoice->created_by);
                            $salesinvoice_payment->date           = Date('Y-m-d');
                            $salesinvoice_payment->amount         = $request->has('amount') ? $request->amount : 0;
                            $salesinvoice_payment->client_id      = Auth::check()?Auth::user()->id:' public';
                            $salesinvoice_payment->payment_type = 'Mercado Pago';
                            $salesinvoice_payment->save();
                            $due     = $salesinvoice->getDue();
                            if ($due <= 0) {
                                $salesinvoice->status = 3;
                                $salesinvoice->save();
                            } else {
                                $salesinvoice->status = 2;
                                $salesinvoice->save();
                            }

                            event(new MercadoPaymentStatus($salesinvoice,$type,$salesinvoice_payment));

                            return redirect()->route('pay.salesinvoice', \Illuminate\Support\Facades\Crypt::encrypt($invoice_id))->with('success', __('Sales Invoice paid Successfully!'));
                        } else {
                            return redirect()->route('pay.salesinvoice', \Illuminate\Support\Facades\Crypt::encrypt($invoice_id))->with('success', __('Transaction fail'));
                        }
                    } catch (\Exception $e) {

                        return redirect()->route('pay.salesinvoice', \Illuminate\Support\Facades\Crypt::encrypt($invoice_id))->with('success', $e->getMessage());
                    }
                } else {

                    return redirect()->route('pay.salesinvoice', \Illuminate\Support\Facades\Crypt::encrypt($invoice_id))->with('success', __('Sales Invoice not found.'));
                }
            }
            elseif($type == 'retainer')
            {
                $retainer  = \Modules\Retainer\Entities\Retainer::find($invoice_id);
                $orderID = strtoupper(str_replace('.', '', uniqid('', true)));
                if ($retainer && $request->has('status')) {
                    try {

                        if ($request->status == 'approved' && $request->flag == 'success') {
                            $retainer_payment                 = new \Modules\Retainer\Entities\RetainerPayment();
                            $retainer_payment->retainer_id     = $invoice_id;
                            $retainer_payment->date           = Date('Y-m-d');
                            $retainer_payment->account_id     = 0;
                            $retainer_payment->payment_method = 0;
                            $retainer_payment->amount         = $request->has('amount') ? $request->amount : 0;
                            $retainer_payment->order_id       = $orderID;
                            $retainer_payment->payment_type = 'Mercado Pago';
                            $retainer_payment->save();
                            $due     = $retainer->getDue();
                            if ($due <= 0) {
                                $retainer->status = 3;
                                $retainer->save();
                            } else {
                                $retainer->status = 2;
                                $retainer->save();
                            }

                            event(new MercadoPaymentStatus($retainer,$type,$retainer_payment));

                            return redirect()->route('pay.retainer', \Illuminate\Support\Facades\Crypt::encrypt($invoice_id))->with('success', __('Retainer paid Successfully!'));
                        } else {
                            return redirect()->route('pay.retainer', \Illuminate\Support\Facades\Crypt::encrypt($invoice_id))->with('success', __('Transaction fail'));
                        }
                    } catch (\Exception $e) {
                        return redirect()->route('pay.retainer', \Illuminate\Support\Facades\Crypt::encrypt($invoice_id))->with('success', $e->getMessage());
                    }
                } else {

                    return redirect()->route('pay.retainer', \Illuminate\Support\Facades\Crypt::encrypt($invoice_id))->with('success', __('Retainer not found.'));
                }
            }
        } else {
            if (Auth::check()) {
                return redirect()->back()->with('error', __('Invoice not found.'));
            } else {
                return redirect()->back()->with('error', __('Invoice not found.'));
            }
        }
    }

    public function planPayWithMercado(Request $request)
    {
        $plan = Plan::find($request->plan_id);
        if ($plan) {
            $user_counter = !empty($request->user_counter_input) ? $request->user_counter_input : 0;
            $user_module = !empty($request->user_module_input) ? $request->user_module_input : '';
            $duration = !empty($request->time_period) ? $request->time_period : 'Month';
            $user_module_price = 0;
            if(!empty($user_module) && $plan->custom_plan == 1 )
            {
                $user_module_array =    explode(',',$user_module);
                foreach ($user_module_array as $key => $value)
                {
                    $temp = ($duration == 'Year') ? ModulePriceByName($value)['yearly_price'] : ModulePriceByName($value)['monthly_price'];
                    $user_module_price = $user_module_price + $temp;
                }
            }
            $user_price = 0;
            if($user_counter > 0)
            {
                $temp = ($duration == 'Year') ? $plan->price_per_user_yearly : $plan->price_per_user_monthly;

                $user_price = $user_counter * $temp;
            }
            $plan->discounted_price = false;
            $plan_price = ($duration == 'Year') ? $plan->package_price_yearly : $plan->package_price_monthly;
            $price                  = $plan_price + $user_module_price + $user_price;
            if($price <= 0){
                $assignPlan= DirectAssignPlan($plan->id,$duration,$user_module,$user_counter,'Mercado Pago');
                if($assignPlan['is_success']){
                   return redirect()->route('plans.index')->with('success', __('Plan activated Successfully!'));
                }else{
                   return redirect()->route('plans.index')->with('error', __('Something went wrong, Please try again,'));
                }
            }
            /* Check for code usage */
            $this->token = admin_setting('company_mercado_access_token');
            $this->mode = admin_setting('company_mercado_mode');
            $this->is_enabled = admin_setting('mercado_payment_is_on');

            \MercadoPago\SDK::setAccessToken($this->token);
            try {
                $product = !empty($plan->name) ? $plan->name :'Basic Package';
                // Create a preference object
                $preference = new \MercadoPago\Preference();
                // Create an item in the preference
                $item = new \MercadoPago\Item();
                $item->title = "Plan : " . $product;
                $item->quantity = 1;
                $item->unit_price = (float)$price;
                $preference->items = array($item);
                $success_url = route('plan.get.mercado.status', [$plan->id, 'payment_frequency=' . $request->time_period, 'user_module=' . $user_module,'duration=' . $duration,'user_counter=' . $user_counter,'price=' . $price, 'flag' => 'success']);

                $failure_url = route('plan.get.mercado.status', [$plan->id, 'flag' => 'failure']);
                $pending_url = route('plan.get.mercado.status', [$plan->id, 'flag' => 'pending']);

                $preference->back_urls = array(
                    "success" => $success_url,
                    "failure" => $failure_url,
                    "pending" => $pending_url
                );

                $preference->auto_return = "approved";
                $preference->save();

                // Create a customer object
                $payer = new \MercadoPago\Payer();
                // Create payer information
                $payer->name = Auth::user()->name;
                $payer->email = Auth::user()->email;
                $payer->address = array(
                    "street_name" => ''
                );
                if ($this->mode == 'live') {
                    $redirectUrl = $preference->init_point;
                } else {

                    $redirectUrl = $preference->sandbox_init_point;
                }
                return redirect($redirectUrl);
            } catch (Exception $e) {

                return redirect()->back()->with('error', $e->getMessage());
            }
            // callback url :  domain.com/plan/mercado

        } else {
            return redirect()->back()->with('error', 'Plan is deleted.');
        }
    }

    public function planGetMercadoStatus(Request $request, $plan)
    {
        $plan           = Plan::find($plan);
        $user           = User::find(Auth::user()->id);
        $orderID        = strtoupper(str_replace('.', '', uniqid('', true)));
        if ($plan) {
            try
            {
            if ($plan && $request->has('status')) {

                if ($request->status == 'approved' && $request->flag == 'success') {
                    if (!empty($user->payment_subscription_id) && $user->payment_subscription_id != '') {
                        try {
                            $user->cancel_subscription($user->id);
                        } catch (\Exception $exception) {
                            \Log::debug($exception->getMessage());
                        }
                    }
                $product = !empty($plan->name) ? $plan->name :'Basic Package';
                    $order = Order::create(
                        [
                            'order_id' => $orderID,
                            'name' => null,
                            'email' => null,
                            'card_number' => null,
                            'card_exp_month' => null,
                            'card_exp_year' => null,
                            'plan_name' => $product,
                            'plan_id' => $plan->id,
                            'price' => !empty($request->price)?$request->price:0,
                            'price_currency' => admin_setting('defult_currancy'),
                            'txn_id' => '',
                            'payment_type' => __('Mercado Pago'),
                            'payment_status' => 'succeeded',
                            'receipt' => null,
                            'user_id' => $user->id,
                        ]
                    );

                    $type = 'Subscription';
                    $assignPlan = $user->assignPlan($plan->id,$request->duration,$request->user_module,$request->user_counter);

                    event(new MercadoPaymentStatus($plan,$type,$order));

                    $value = Session::get('user-module-selection');
                    if(!empty($value))
                    {
                        Session::forget('user-module-selection');
                    }
                    if ($assignPlan['is_success']) {
                        return redirect()->route('plans.index')->with('success', __('Plan activated Successfully!'));
                    } else {
                        return redirect()->route('plans.index')->with('error', __($assignPlan['error']));
                    }
                } else {
                    return redirect()->route('plans.index')->with('error', __('Transaction has been failed! '));
                }
            } else {
                return redirect()->route('plans.index')->with('error', __('Transaction has been failed! '));
            }
            }
            catch(\Exception $e)
            {
                return redirect()->route('plans.index')->with('error', __('Plan not found!'));
            }
        }
    }
}
