<?php

namespace Modules\Mercado\Providers;

use Illuminate\Support\ServiceProvider;

class SalesInvoicePayment extends ServiceProvider
{
    /**
     * Register the service provider.
     *
     * @return void
     */

    public function boot(){
        view()->composer(['sales::salesinvoice.invoicepay'], function ($view)
        {
            $route = \Request::route()->getName();
            if($route =='pay.salesinvoice')
            {
                try {
                    $ids = \Request::segment(3);
                    if(!empty($ids))
                    {
                        $id = \Illuminate\Support\Facades\Crypt::decrypt($ids);
                        $invoice = \Modules\Sales\Entities\SalesInvoice::where('id',$id)->first();
                        $type = 'salesinvoice';
                        if(module_is_active('Mercado',$invoice->created_by,$invoice->workspace) && (company_setting('mercado_payment_is_on', $invoice->created_by,$invoice->workspace)) == 'on' && !empty(company_setting('company_mercado_mode', $invoice->created_by,$invoice->workspace)) && !empty(company_setting('company_mercado_access_token', $invoice->created_by,$invoice->workspace)))
                        {
                            $view->getFactory()->startPush('salesinvoice_payment_tab', view('mercado::payment.sidebar'));
                            $view->getFactory()->startPush('salesinvoice_payment_div', view('mercado::payment.nav_containt_div',compact('type','invoice')));
                        }
                    }
                } catch (\Throwable $th) {

                }
            }
        });
    }

    public function register()
    {
        //
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return [];
    }
}
