<?php

namespace Modules\Mercado\Providers;

use Illuminate\Support\ServiceProvider;

class ViewComposer extends ServiceProvider
{
    /**
     * Register the service provider.
     *
     * @return void
     */

    public function boot()
    {
        view()->composer(['plans*','settings*'], function ($view)
        {
            if(\Auth::check())
            {
                $active_module = explode(',',\Auth::user()->active_module);
                $dependency = explode(',','Mercado');
                if(\Auth::user()->type == 'super admin' || !empty(array_intersect($dependency,$active_module)))
                {
                    $view->getFactory()->startPush('payment_setting_sidebar', view('mercado::setting.sidebar'));
                    $view->getFactory()->startPush('payment_setting_sidebar_div', view('mercado::setting.nav_containt_div'));
                }
                if(admin_setting('mercado_payment_is_on') == 'on' && !empty(admin_setting('company_mercado_mode')) && !empty(admin_setting('company_mercado_access_token')))
                {
                    $view->getFactory()->startPush('company_plan_payment', view('mercado::payment.plan_payment'));
                }
            }
        });
    }

    public function register()
    {
        //
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return [];
    }
}
