@can('mercado manage')

<div class="card" id="mercado_sidenav">
    {{ Form::open(['route' => ['mercado.company_setting.store'], 'enctype' => 'multipart/form-data', 'id' => 'payment-form']) }}

    <div class="card-header">
        <div class="row">
            <div class="col-lg-10 col-md-10 col-sm-10">
                <h5 class="">{{ __('Mercado Pago') }}</h5>
                @if(\Auth::user()->type == "super admin")
                    <small>{{ __('These details will be used to collect subscription plan payments.Each subscription plan will have a payment button based on the below configuration.') }}</small>
                @else
                    <small>{{ __('These details will be used to collect invoice payments. Each invoice will have a payment button based on the below configuration.') }}</small>
                @endif
            </div>
            <div class="col-lg-2 col-md-2 col-sm-2 text-end">
                <div class="form-check form-switch custom-switch-v1 float-end">
                    <input type="checkbox" name="mercado_payment_is_on" class="form-check-input input-primary" id="mercado_payment_is_on" {{ company_setting('mercado_payment_is_on')=='on'?' checked ':'' }} >
                    <label class="form-check-label" for="mercado_payment_is_on"></label>
                </div>
            </div>
        </div>
    </div>

    <div class="card-body">
        <div class="row">
            <div class="col-md-12">
                <label class="mercado-label col-form-label" for="mercado_mode">{{ __('Mercado Mode') }}</label> <br>
                <div class="d-flex">
                    <div class="mr-2">
                        <div class="border card p-3">
                            <div class="form-check">
                                <label class="form-check-labe text-dark">
                                    <input type="radio" name="company_mercado_mode" value="sandbox" class="form-check-input"
                                        {{ empty(company_setting('company_mercado_mode')) || company_setting('company_mercado_mode') == '' || company_setting('company_mercado_mode') == 'sandbox' ? 'checked="checked"' : '' }}>

                                    {{ __('Sandbox') }}
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="mr-2">
                        <div class="border card p-3">
                            <div class="form-check">
                                <label class="form-check-labe text-dark">
                                    <input type="radio" name="company_mercado_mode" value="live" class="form-check-input"
                                        {{ !empty(company_setting('company_mercado_mode')) && company_setting('company_mercado_mode') == 'live' ? 'checked="checked"' : '' }}>

                                    {{ __('Live') }}
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="company_mercado_access_token" class="col-form-label">{{ __('Public Key') }}</label>
                    <input type="text" name="company_mercado_access_token" id="company_mercado_access_token" class="form-control" value="{{company_setting('company_mercado_access_token') }}" placeholder="{{ __('Public Key') }}"{{ company_setting('mercado_payment_is_on')=='on'?'':' disabled' }}>
                    @if($errors->has('company_mercado_secret_key'))
                    <span class="invalid-feedback d-block">
                        {{ $errors->first('mercado_access_token') }}
                    </span>
                @endif
                </div>
            </div>
        </div>
    </div>
    <div class="card-footer text-end">
        <input class="btn btn-print-invoice btn-primary m-r-10" type="submit" value="{{ __('Save Changes') }}">
    </div>
    {{ Form::close() }}

</div>

@push('scripts')
<script>
   $(document).on('click','#mercado_payment_is_on',function(){
        if( $('#mercado_payment_is_on').prop('checked') )
        {
            $("#company_mercado_access_token").removeAttr("disabled");
        } else {
            $('#company_mercado_access_token').attr("disabled", "disabled");
        }
    });
</script>
@endpush

@endcan


