<?php


use Illuminate\Support\Facades\Route;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Modules\Mercado\Http\Controllers\MercadoController;

Route::group(['middleware' => 'PlanModuleCheck:Mercado'], function ()
{
  Route::post('/setting/mercado_store', 'MercadoController@setting')->name('mercado.company_setting.store')->middleware(['auth']);
});
Route::post('/invoice.pay.with.mercado', 'MercadoController@invoicePayWithmercado')->name('invoice.pay.with.mercado');
Route::get('/invoice/mercado/{invoice}/{type}', 'MercadoController@getInvoicePaymentStatus')->name('invoice.mercado');
Route::post('/plan/mercado/payment', 'MercadoController@planPayWithMercado')->name('plan.pay.with.mercado')->middleware(['auth']);
Route::get('/plan/mercado/{plan}', [MercadoController::class,'planGetMercadoStatus'])->name('plan.get.mercado.status')->middleware(['auth']);

