<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('loans'))
        {
            Schema::create('loans', function (Blueprint $table) {
                $table->id();
                $table->integer('employee_id');
                $table->integer('loan_option');
                $table->string('title');
                $table->string('type')->nullable();
                $table->integer('amount');
                $table->date('start_date');
                $table->date('end_date');
                $table->string('reason');
                $table->integer('workspace')->nullable();
                $table->integer('created_by');
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('loans');
    }
};
