<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<title>404 HTML</title>


	<style>
		* {
			-webkit-box-sizing: border-box;
			box-sizing: border-box
		}

		body {
			padding: 0;
			margin: 0
		}

		#notfound {
			position: relative;
			height: 100vh;
			background: transparent;
		}

		#notfound .notfound {
			position: absolute;
			left: 50%;
			top: 50%;
			-webkit-transform: translate(-50%, -50%);
			-ms-transform: translate(-50%, -50%);
			transform: translate(-50%, -50%)
		}

		.notfound {
			max-width: 767px;
			width: 100%;
			line-height: 1.4;
			text-align: center
		}

		.notfound .notfound-404 {
			position: relative;
			height: 180px;
			margin-bottom: 20px;
			z-index: -1
		}

		.notfound .notfound-404 h1 {
			font-family: montserrat, sans-serif;
			position: absolute;
			left: 50%;
			top: 50%;
			-webkit-transform: translate(-50%, -50%);
			-ms-transform: translate(-50%, -50%);
			transform: translate(-50%, -50%);
			font-size: 224px;
			font-weight: 900;
			margin-top: 0;
			margin-bottom: 0;
			margin-left: -12px;
			color: #0fa7f0;
			text-transform: uppercase;
			text-shadow: -1px -1px 0 #8400ff, 1px 1px 0 #ff005a;
			letter-spacing: -20px
		}

		.notfound .notfound-404 h2 {
			font-family: montserrat, sans-serif;
			position: absolute;
			left: 0;
			right: 0;
			top: 110px;
			font-size: 42px;
			font-weight: 700;
			color: #fff;
			text-transform: uppercase;
			text-shadow: 0 2px 0 #8400ff;
			letter-spacing: 13px;
			line-height: 50px;
			margin: 0
		}

		.notfound a {
			font-family: montserrat, sans-serif;
			display: inline-block;
			text-transform: uppercase;
			color: #0fa7f0;
			text-decoration: none;
			border: 2px solid;
			background: 0 0;
			padding: 10px 40px;
			font-size: 14px;
			font-weight: 700;
			-webkit-transition: .2s all;
			transition: .2s all
		}

		.notfound a:hover {
			color: #EFEC18
		}

		@media only screen and (max-width:767px) {
			.notfound .notfound-404 h2 {
				font-size: 24px
			}
		}

		@media only screen and (max-width:480px) {
			.notfound .notfound-404 h1 {
				font-size: 182px
			}
		}
	</style>


	<!--[if lt IE 9]>
		  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
		  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->
	<meta name="robots" content="noindex, follow">
</head>

<body>
	<div id="notfound">
		<div class="notfound">
			<div class="notfound-404">
				<h1>404</h1>
				<h2>Página não encontrada</h2>
			</div>
			<a href="<?= __URLSITE__ ?>" style="margin-top: 30px;">Página inicial</a>
		</div>
	</div>

</body>

</html>