function loadingTab(url, param) {
  var receptor = $("#system_tabs_content");
  receptor.html("");
  receptor.addClass("loading");
  $.post(url, param)
    .done(function (data, textStatus, xhr) {
      receptor.html(data);
    })
    .fail(function (xhr) {
      if (xhr.status == 404) {
        receptor.html(
          '<div class="ui red message large"><i class="fas fa-exclamation-circle"></i> Desculpe, não encontramos a página solicitada.</div>'
        );
      }
    })
    .always(function () {
      setTimeout(function () {
        receptor.removeClass("loading");
      }, 500);
    });
}
function checkBetweenDate(intervaloInicio, intervaloFim, dataComparada) {
  var intervaloInicio,
    intervaloFim,
    dataComparada,
    retorno = {};
  dataComparada = new Date(dataComparada);
  intervaloInicio = new Date(intervaloInicio);
  intervaloFim = new Date(intervaloFim);

  if (
    Date.parse(dataComparada) <= Date.parse(intervaloFim) &&
    Date.parse(dataComparada) >= Date.parse(intervaloInicio)
  ) {
    retorno.intervalo = true;
  } else {
    retorno.intervalo = false;
  }

  if (Date.parse(dataComparada) >= Date.parse(intervaloInicio)) {
    retorno.data_valida = false;
  } else {
    retorno.data_valida = true;
  }
  return retorno;
}

function init_addons() {
  // Ativar dropdowns
  $(".ui.dropdown").dropdown();
  // Ajustes
  if ($(".body_system").height() <= 500) {
    $(".body_system").css({
      "padding-bottom": "600px",
    });
  } else if (
    $(".body_system").height() > 500 &&
    $(".body_system").height() < 700
  ) {
    $(".body_system").css({
      "padding-bottom": "400px",
    });
  } else {
    $(".body_system").css({
      "padding-bottom": "80px",
    });
  }
}
$(document).ready(function () {
  init_addons();
});
$(window).on("load", function () {
  $("#preloader-active").delay(450).fadeOut("slow");
  $("body").delay(350).css({
    overflow: "visible",
  });
});

function toast(tipo, mensagem) {
  let cor = "teal";
  let icone = "check circle";
  if (tipo == "erro") {
    cor = "red";
    icone = "exclamation circle";
  }
  $.toast({
    position: "centered",
    class: cor,
    showIcon: icone,
    message: mensagem,
    showProgress: "bottom",
    displayTime: 2000,
    compact: false,
  });
}
function validarFormulario(elemento) {
  var form = elemento.closest("form");
  var validation = 0;
  form.find("input, select, textarea").each(function () {
    if ($(this).prop("required") == true) {
      if ($(this).is("select")) {
        if ($(this).val() == "") {
          $(this).siblings("label").addClass("text-danger");
          validation++;
        } else {
          $(this).siblings("label").removeClass("text-danger");
        }
      } else {
        if ($(this).is(".date")) {
          if (
            $(this).val() == "" ||
            parseInt($(this).attr("minlength")) > $(this).val().length
          ) {
            $(this).parent().parent().siblings("label").addClass("text-danger");
            validation++;
          } else {
            $(this)
              .parent()
              .parent()
              .siblings("label")
              .removeClass("text-danger");
          }
        } else if ($(this).prop("type") == "hidden") {
          if (
            $(this).val() == "" ||
            parseInt($(this).attr("minlength")) > $(this).val().length
          ) {
            $(this).parent().siblings("label").addClass("text-danger");
            validation++;
          } else {
            $(this).parent().siblings("label").removeClass("text-danger");
          }
        } else {
          if (
            $(this).val() == "" ||
            parseInt($(this).attr("minlength")) > $(this).val().length
          ) {
            $(this).siblings("label").addClass("text-danger");
            validation++;
          } else {
            $(this).siblings("label").removeClass("text-danger");
          }
        }
      }
    }
  });
  return validation;
}
function adicionarAsteriscos() {
  $("form")
    .find("input, select, textarea")
    .each(function () {
      if ($(this).prop("required") == true) {
        if ($(this).is(".date")) {
          $(this).parent().parent().siblings("label").append(" *");
        } else if ($(this).prop("type") == "hidden") {
          $(this).parent().siblings("label").append(" *");
        } else {
          $(this).siblings("label").append(" *");
        }
      }
    });
}

function remover_linha(botao) {
  $(botao).closest("tr").remove();
  $(botao).closest("table").find("tr:eq(0)").focus();
  return false;
}
